/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.workflow.service;

import com.dvsum.logger.CustomLogger;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;

public class ThreadStats {
    private static final CustomLogger logger = CustomLogger.getLogger(ThreadStats.class);
    private static final String WORKFLOW_THREAD_PREFIX = "WorkflowThread-";

    public static void logThreads() {
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        threadBean.setThreadContentionMonitoringEnabled(true);
        long[] threadIds = threadBean.getAllThreadIds();
        ThreadInfo[] threadInfos = threadBean.getThreadInfo(threadIds);
        int workflowThreads = 0;
        int blockedWorkflowThreads = 0;
        int waitingWorkflowThreads = 0;
        long totalBlockedTime = 0L;
        long totalWaitedTime = 0L;
        ThreadInfo[] threadInfoArray = threadInfos;
        int n = threadInfos.length;
        int n2 = 0;
        while (n2 < n) {
            String threadName;
            ThreadInfo info = threadInfoArray[n2];
            if (info != null && (threadName = info.getThreadName()).startsWith(WORKFLOW_THREAD_PREFIX)) {
                ++workflowThreads;
                if (info.getBlockedCount() > 0L) {
                    ++blockedWorkflowThreads;
                    totalBlockedTime += info.getBlockedTime();
                }
                if (info.getWaitedCount() > 0L) {
                    ++waitingWorkflowThreads;
                    totalWaitedTime += info.getWaitedTime();
                }
            }
            ++n2;
        }
        logger.info("Workflow Thread Statistics:");
        logger.info("  Total Workflow Threads: " + workflowThreads);
        logger.info("  Blocked Workflow Threads: " + blockedWorkflowThreads);
        logger.info("  Waiting Workflow Threads: " + waitingWorkflowThreads);
        logger.info("  Total Blocked Time: %.2f seconds", (double)totalBlockedTime / 1000.0);
        logger.info("  Total Waited Time: %.2f seconds", (double)totalWaitedTime / 1000.0);
    }
}

