/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.workflow.service;

import com.dvsum.logger.CustomLogger;
import com.dvsum.util.DateUtil;
import com.dvsum.websocket.ConnectionManager;
import com.dvsum.workflow.model.Action.Action;
import com.dvsum.workflow.model.State;
import com.dvsum.workflow.model.Workflow;
import com.dvsum.workflow.model.WorkflowDataStore;
import org.json.simple.JSONObject;

public class LogHandler {
    private static final CustomLogger logger = CustomLogger.getLogger(LogHandler.class);

    public static void sendLogMessageToUI(WorkflowDataStore workflowDataStore, String message) {
        logger.info("Sending log message to UI. Message :", message);
        JSONObject websocketPayload = LogHandler.generateWebsocketPayload(null, null, workflowDataStore.findBrowserWebSocketConnectionId(), workflowDataStore.findExecutionId(), message, false, false, workflowDataStore.findToolId(), workflowDataStore.findToolName(), 200);
        ConnectionManager.sendWebsocketMessageWithRetry(websocketPayload);
    }

    public static void sendQueryToUI(WorkflowDataStore workflowDataStore, String query) {
        logger.info("Sending Query to UI. Message :", query);
        JSONObject websocketPayload = LogHandler.generateWebsocketPayloadForSql(query, workflowDataStore.findExecutionId(), workflowDataStore.findBrowserWebSocketConnectionId());
        ConnectionManager.sendWebsocketMessageWithRetry(websocketPayload);
    }

    public static void sendLogMessageToUI(WorkflowDataStore workflowDataStore, String message, boolean isLastMsg, int statusCode) {
        logger.info("Sending log message to UI. Message :", message);
        JSONObject websocketPayload = LogHandler.generateWebsocketPayload(null, null, workflowDataStore.findBrowserWebSocketConnectionId(), workflowDataStore.findExecutionId(), message, false, isLastMsg, workflowDataStore.findToolId(), workflowDataStore.findToolName(), statusCode);
        ConnectionManager.sendWebsocketMessageWithRetry(websocketPayload);
    }

    public static void sendLogMessageToUI(WorkflowDataStore workflowDataStore, String message, boolean isLastMsg) {
        logger.info("Sending last log message to UI. Message :", message);
        JSONObject websocketPayload = LogHandler.generateWebsocketPayload(null, null, workflowDataStore.findBrowserWebSocketConnectionId(), workflowDataStore.findExecutionId(), message, false, isLastMsg, workflowDataStore.findToolId(), workflowDataStore.findToolName(), 200);
        ConnectionManager.sendWebsocketMessageWithRetry(websocketPayload);
    }

    public static void sendLogMessageToUI(WorkflowDataStore workflowDataStore, State state, Action action, String message, boolean isCompletionMsg, boolean isLastMsg) {
        logger.info("Sending log message to UI. Message :", message);
        JSONObject websocketPayload = LogHandler.generateWebsocketPayload(state, action, workflowDataStore.findBrowserWebSocketConnectionId(), workflowDataStore.findExecutionId(), message, isCompletionMsg, isLastMsg, workflowDataStore.findToolId(), workflowDataStore.findToolName(), 200);
        ConnectionManager.sendWebsocketMessageWithRetry(websocketPayload);
    }

    public static void sendActionCompletionLogToUI(Workflow workflow, State state, Action action) {
        action.setEndTime(DateUtil.getCurrentEpochTimeInMillis());
        String logMessage = "Execution completed for state: " + state.getId() + " and action: " + action.getId() + ".";
        LogHandler.sendLogMessageToUI(workflow.getWorkflowDataStore(), state, action, logMessage, true, false);
    }

    public static void sendActionStartLogToUI(Workflow workflow, State state, Action action) {
        action.setStartTime(DateUtil.getCurrentEpochTimeInMillis());
        String logMessage = "Execution started for state: " + state.getId() + " and action: " + action.getId();
        LogHandler.sendLogMessageToUI(workflow.getWorkflowDataStore(), state, action, logMessage, false, false);
    }

    public static void sendInvalidWFLogMessageToUI(JSONObject workflowJson, String message) {
        logger.info("Sending invalid workflow log message to UI. Message :", message);
        try {
            logger.info("Workflow Json = ", workflowJson.toJSONString());
            JSONObject workflowDataStore = new JSONObject();
            workflowDataStore = workflowJson.containsKey((Object)"query_metadata_info") ? (JSONObject)workflowJson.get((Object)"query_metadata_info") : (JSONObject)((JSONObject)workflowJson.get((Object)"workflow_data_store")).get((Object)"context");
            String browserWSConnectionId = String.valueOf(workflowDataStore.get((Object)"browser_websocket_connection_id"));
            String executionId = String.valueOf(workflowDataStore.get((Object)"execution_id"));
            JSONObject websocketPayload = LogHandler.generateWebsocketPayload(browserWSConnectionId, executionId, message);
            ConnectionManager.sendWebsocketMessageWithRetry(websocketPayload);
        }
        catch (Exception e) {
            logger.error("Error while sending invalid WF log message to UI. Error: ", e.getMessage());
            e.printStackTrace();
        }
    }

    private static JSONObject generateWebsocketPayload(String browserWebsocketConnectionId, String executionId, String verboseMessage) {
        JSONObject websocketMessage = new JSONObject();
        int statusCode = 500;
        try {
            JSONObject messageContent = new JSONObject();
            messageContent.put((Object)"verbose_response", (Object)verboseMessage);
            messageContent.put((Object)"browser_websocket_connection_id", (Object)browserWebsocketConnectionId);
            messageContent.put((Object)"is_completion_msg", (Object)true);
            messageContent.put((Object)"timestamp", (Object)DateUtil.getCurrentEpochTimeInMillis());
            JSONObject messageObject = new JSONObject();
            messageObject.put((Object)"message_content", (Object)messageContent);
            messageObject.put((Object)"is_last_msg", (Object)true);
            messageObject.put((Object)"query_id", (Object)executionId);
            messageObject.put((Object)"status_code", (Object)statusCode);
            messageObject.put((Object)"qry_status", (Object)(statusCode == 500 ? "FL" : "PS"));
            websocketMessage.put((Object)"action", (Object)"sendMessage");
            websocketMessage.put((Object)"source", (Object)"dvsumConnector");
            websocketMessage.put((Object)"context", (Object)"logSyncUI");
            websocketMessage.put((Object)"message", (Object)messageObject);
        }
        catch (Exception e) {
            logger.error("Error while generating websocket payload. Error :", e.getMessage());
            e.printStackTrace();
        }
        return websocketMessage;
    }

    private static JSONObject generateWebsocketPayload(State state, Action action, String browserWebsocketConnectionId, String executionId, String verboseMessage, boolean isCompletionMsg, boolean isLastMsg, String toolId, String toolName, int statusCode) {
        JSONObject websocketMessage = new JSONObject();
        try {
            JSONObject messageContent = new JSONObject();
            messageContent.put((Object)"verbose_response", (Object)verboseMessage);
            messageContent.put((Object)"browser_websocket_connection_id", (Object)browserWebsocketConnectionId);
            messageContent.put((Object)"is_completion_msg", (Object)isCompletionMsg);
            messageContent.put((Object)"timestamp", (Object)DateUtil.getCurrentEpochTimeInMillis());
            LogHandler.updateMessageWithActionProps(messageContent, state, action);
            JSONObject messageObject = new JSONObject();
            messageObject.put((Object)"message_content", (Object)messageContent);
            messageObject.put((Object)"is_last_msg", (Object)isLastMsg);
            messageObject.put((Object)"query_id", (Object)executionId);
            messageObject.put((Object)"status_code", (Object)statusCode);
            messageObject.put((Object)"qry_status", (Object)(statusCode == 500 ? "FL" : "PS"));
            messageObject.put((Object)"tool_id", (Object)toolId);
            messageObject.put((Object)"tool_name", (Object)toolName);
            websocketMessage.put((Object)"action", (Object)"sendMessage");
            websocketMessage.put((Object)"source", (Object)"dvsumConnector");
            websocketMessage.put((Object)"context", (Object)"logSyncUI");
            websocketMessage.put((Object)"message", (Object)messageObject);
        }
        catch (Exception e) {
            logger.error("Error while generating websocket payload. Error :", e.getMessage());
            e.printStackTrace();
        }
        return websocketMessage;
    }

    public static JSONObject generateWebsocketPayloadForSql(String query, String executionId, String browserWebsocketConnectionId) {
        JSONObject messageContent = new JSONObject();
        messageContent.put((Object)"isSql", (Object)true);
        messageContent.put((Object)"query", (Object)query);
        messageContent.put((Object)"browser_websocket_connection_id", (Object)browserWebsocketConnectionId);
        JSONObject nestedWebsocketMessage = new JSONObject();
        nestedWebsocketMessage.put((Object)"message_content", (Object)messageContent);
        nestedWebsocketMessage.put((Object)"is_json_content", (Object)true);
        nestedWebsocketMessage.put((Object)"query_id", (Object)executionId);
        JSONObject websocketMessage = new JSONObject();
        websocketMessage.put((Object)"action", (Object)"sendMessage");
        websocketMessage.put((Object)"source", (Object)"dvsumConnector");
        websocketMessage.put((Object)"context", (Object)"logSyncUI");
        websocketMessage.put((Object)"message", (Object)nestedWebsocketMessage);
        return websocketMessage;
    }

    private static void updateMessageWithActionProps(JSONObject message, State state, Action action) {
        if (state != null && action != null) {
            message.put((Object)"start_time", (Object)action.getStartTime());
            message.put((Object)"end_time", (Object)action.getEndTime());
            message.put((Object)"action_id", (Object)action.getId());
            message.put((Object)"state_id", (Object)state.getId());
        }
    }
}

