/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.workflow.service;

import com.google.gson.JsonElement;

class JsonNavigator {
    private final JsonElement jsonObject;

    public JsonNavigator(JsonElement jsonObject) {
        this.jsonObject = jsonObject;
    }

    public Object findAttribute(String attrPath) {
        String[] keys = attrPath.split("\\.");
        JsonElement currentObj = this.jsonObject;
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if ((currentObj = this.navigate(currentObj, key)) == null || currentObj.isJsonNull()) {
                return null;
            }
            ++n2;
        }
        return currentObj;
    }

    private JsonElement navigate(JsonElement currentObj, String key) {
        if (key.contains("[") && key.contains("]")) {
            String[] splitKey = key.split("\\[");
            String listKey = splitKey[0];
            String expr = splitKey[1].replaceAll("\\]", "");
            if (expr.contains("=")) {
                String[] exprSplit = expr.split("=");
                String filterKey = exprSplit[0];
                String filterValue = exprSplit[1].replaceAll("\"", "");
                if ((currentObj = currentObj.getAsJsonObject().get(listKey)).isJsonArray()) {
                    for (JsonElement item : currentObj.getAsJsonArray()) {
                        if (!item.isJsonObject() || !item.getAsJsonObject().has(filterKey) || !item.getAsJsonObject().get(filterKey).getAsString().equals(filterValue)) continue;
                        return item;
                    }
                }
                return null;
            }
            try {
                int index = Integer.parseInt(expr);
                currentObj = currentObj.getAsJsonObject().get(listKey);
                if (currentObj.isJsonArray() && currentObj.getAsJsonArray().size() > index) {
                    return currentObj.getAsJsonArray().get(index);
                }
            }
            catch (NumberFormatException e) {
                return null;
            }
            return null;
        }
        currentObj = currentObj.getAsJsonObject().get(key);
        return currentObj;
    }
}

