/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.workflow.model;

import com.dvsum.workflow.model.State;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class StateMachine {
    @JsonProperty(value="state_machine_name")
    private String stateMachineName;
    @JsonProperty(value="start_state")
    private String startState;
    @JsonProperty(value="default_timeout")
    private Long defaultTimeout;
    @JsonProperty(value="current_execution_state")
    private String currentExecutionState;
    @JsonProperty(value="states")
    private List<State> states;

    public String getStateMachineName() {
        return this.stateMachineName;
    }

    public void setStateMachineName(String stateMachineName) {
        this.stateMachineName = stateMachineName;
    }

    public String getCurrentExecutionState() {
        if (this.currentExecutionState == null) {
            this.currentExecutionState = "NOT_STARTED";
        }
        return this.currentExecutionState;
    }

    public void setCurrentExecutionState(String currentExecutionState) {
        this.currentExecutionState = currentExecutionState;
    }

    public String getStartState() {
        return this.startState;
    }

    public void setStartState(String startState) {
        this.startState = startState;
    }

    public List<State> getStates() {
        return this.states;
    }

    public void setStates(List<State> states) {
        this.states = states;
    }

    public void setDefaultTimeout(Long defaultTimeout) {
        this.defaultTimeout = defaultTimeout;
    }

    public Long getDefaultTimeout() {
        if (this.defaultTimeout == null) {
            this.defaultTimeout = 120L;
        }
        return this.defaultTimeout;
    }

    public State findState(String stateId) {
        for (State state : this.states) {
            if (!state.getId().equals(stateId)) continue;
            return state;
        }
        return null;
    }
}

