/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.workflow.model;

import com.dvsum.util.JsonObjectMapperUtil;
import com.dvsum.util.TLSHttpsRequestor;
import com.dvsum.workflow.model.Ref.RefCustomFunctionType;
import com.dvsum.workflow.service.PythonCodeExecutor;
import com.fasterxml.jackson.annotation.JsonProperty;

public class CustomFunction {
    @JsonProperty(value="function")
    private String function;
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="code")
    private String code;

    public String getFunction() {
        return this.function;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String downloadCode() {
        String code = this.getCode();
        if (RefCustomFunctionType.isUrl(this.getType())) {
            code = TLSHttpsRequestor.downloadWithPresignedUrl(this.getCode(), true);
        }
        return code;
    }

    public static void main(String[] args) {
        String jsonString = "{\r\n            \"function\":\"process_data_for_llm\",\r\n            \"type\":\"CODE\",\r\n            \"code\": \"def process_data_for_llm(data: dict):\\n    import json\\n    return json.dumps(data)\\n\\nprint(process_data_for_llm($$.data))\"\r\n        }";
        CustomFunction customFunction = JsonObjectMapperUtil.getObjectFromJsonString(jsonString, CustomFunction.class);
        String data = "{\r\n  \"Name\": [\"John\", \"Anna\", \"Peter\"],\r\n  \"Age\": [28, 24, 35],\r\n  \"City\": [\"New York\", \"Paris\", \"Berlin\"]\r\n}\r\n";
        String code = customFunction.getCode().replace("$$.data", data);
        System.out.println(code);
        PythonCodeExecutor.executePythonCode(code);
    }
}

