/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.workflow.model.Action;

import com.dvsum.logger.CustomLogger;
import com.dvsum.util.AuthorizationHeaderGenerator;
import com.dvsum.util.JsonUtil;
import com.dvsum.util.Util;
import com.dvsum.workflow.model.Action.Action;
import com.dvsum.workflow.model.AuthInfo;
import com.dvsum.workflow.model.Ref.RefAuthType;
import com.dvsum.workflow.model.SourceConfig;
import com.dvsum.workflow.model.State;
import com.dvsum.workflow.model.Workflow;
import com.dvsum.workflow.service.DynamicParamExtractor;
import com.dvsum.workflow.service.URLGenerator;
import com.dvsum.workflow.service.WorkflowRequestHandler;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;

public class RestAction
extends Action {
    private static final CustomLogger logger = CustomLogger.getLogger(RestAction.class);
    @JsonProperty(value="url")
    private String url;
    @JsonProperty(value="method")
    private String method;
    @JsonProperty(value="payload")
    private Map<String, Object> payload;
    @JsonProperty(value="payload_mapping")
    private String payloadMapping;
    @JsonProperty(value="query_parameters")
    private Map<String, String> queryParameters;
    private StringBuilder consolidatedResponse;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getPayloadMapping() {
        return this.payloadMapping;
    }

    public void setPayloadMapping(String payloadMapping) {
        this.payloadMapping = payloadMapping;
    }

    public Map<String, Object> getPayload() {
        return this.payload;
    }

    public void setPayload(Map<String, Object> payload) {
        this.payload = payload;
    }

    public Map<String, String> getQueryParameters() {
        return this.queryParameters;
    }

    public void setQueryParameters(Map<String, String> queryParameters) {
        this.queryParameters = queryParameters;
    }

    public StringBuilder getConsolidatedResponse() {
        return this.consolidatedResponse;
    }

    public void setConsolidatedResponse(StringBuilder consolidatedResponse) {
        this.consolidatedResponse = consolidatedResponse;
    }

    public void applyQueryParams(Workflow workflow, State state, Integer iteration) throws Exception {
        String urlWithQueryParams = this.getUrl();
        if (this.getQueryParameters() != null) {
            if (urlWithQueryParams.contains("?")) {
                urlWithQueryParams = urlWithQueryParams.split("\\?")[0];
            }
            for (String paramKey : this.getQueryParameters().keySet()) {
                String attr;
                String paramVal = this.getQueryParameters().get(paramKey);
                if (paramVal.contains("[0]")) {
                    String[] splittedValues = paramVal.split("\\[");
                    paramVal = String.valueOf(splittedValues[0]) + "[" + (iteration - 1) + splittedValues[1].substring(1);
                }
                if (Util.isNotNullOrEmpty(attr = DynamicParamExtractor.fetchDynamicParam(workflow, paramVal))) {
                    paramVal = attr.trim();
                    urlWithQueryParams = URLGenerator.concatQueryParam(paramKey, paramVal, urlWithQueryParams);
                    continue;
                }
                logger.info("Parameter " + paramKey + " is null or empty.");
                if (paramKey.equalsIgnoreCase("fnId")) {
                    throw new Exception("Error: Action " + state.getId() + "." + this.id + " failed. No device id or fiber id found. Skipping this.");
                }
                if (paramKey.equalsIgnoreCase("page_token")) continue;
                throw new Exception("Error: Action " + state.getId() + "." + this.id + " failed. Invalid value provided for query parameter " + paramKey + ". Skipping this.");
            }
            this.setUrl(urlWithQueryParams);
            logger.info("Setting URL = ", urlWithQueryParams);
        } else {
            logger.info("No query parameters are provided for action " + this.id);
        }
    }

    @Override
    public String execute(Workflow workflow, State state, SourceConfig sourceConfig, JSONObject webhookPayload) throws Exception {
        logger.info("Executing Rest Api call action. Action id:", this.getId());
        String response = "";
        try {
            AuthInfo authInfo = sourceConfig.getAuthInfo();
            Map<String, Object> headers = authInfo.getHeaders();
            if (!RefAuthType.isBearer(authInfo.getAuthType()) || headers.containsKey("Authorization") && !String.valueOf(headers.get("Authorization")).contains("Bearer")) {
                headers = this.generateRestApiHeaders(authInfo, workflow);
            }
            String resolvedUrl = URLGenerator.generateAndResolveUrl(workflow, sourceConfig.getDomain(), this.getUrl());
            this.setUrl(resolvedUrl);
            boolean loopCondition = false;
            int iteration = 1;
            do {
                this.applyQueryParams(workflow, state, iteration);
                logger.info("Resolved URL : ", this.getUrl());
                workflow.getWorkflowDataStore().updateStateIdAndActionIdInContext(state, this);
                Map<String, Object> payload = this.generatePayload(workflow, state);
                logger.info("Payload generated successfully for action:", this.getId(), "and for iteration:", iteration);
                response = WorkflowRequestHandler.executeHttpRequest(workflow, state, this, headers, payload);
                if (this.iteratorParameters != null || this.outputMapping != null) {
                    if (this.iteratorParameters != null) {
                        response = this.filterReponseData(response);
                    }
                    this.updateActionMetadata(workflow.getWorkflowDataStore(), this.outputFilePath, JsonUtil.parseToJson(response), "PENDING", "SUCCESS");
                    if (this.iteratorParameters != null) {
                        loopCondition = this.getLoopCondition(workflow, iteration);
                    }
                    if (this.outputMapping != null) {
                        response = this.applyOutputMappings(workflow, iteration);
                    }
                    if (this.iteratorParameters != null) {
                        response = this.saveOrConsolidateResponse(response, workflow, state, iteration);
                    }
                }
                ++iteration;
            } while (loopCondition);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while executing Rest Api action. Error :", e.getMessage());
            this.handleError(workflow, state, e.getMessage(), false);
        }
        return response;
    }

    private String saveOrConsolidateResponse(String response, Workflow workflow, State state, Integer iteration) throws ParseException {
        if (this.iteratorParameters.containsKey("consolidate")) {
            boolean consolidate = Boolean.valueOf(String.valueOf(this.iteratorParameters.get("consolidate")));
            Object outputData = JsonUtil.parseToJsonOrReturn(response);
            if (!consolidate && this.getSaveToFile().booleanValue()) {
                String resultsFilePath = String.valueOf(workflow.generateBaseFilePath()) + "iteration" + "_" + iteration + "_" + this.generateActionResultsFilePath(state);
                if (this.getUploadRawResponseToCloud().booleanValue()) {
                    this.uploadRawResults(workflow, state, response, resultsFilePath);
                }
                this.saveResultsToFile(workflow, state, outputData, resultsFilePath);
            }
            if (iteration != 1) {
                this.appendOutput(response, outputData);
            } else {
                this.consolidatedResponse.append(response);
            }
        }
        return this.consolidatedResponse.toString();
    }

    private void appendOutput(String response, Object outputData) throws ParseException {
        if (outputData instanceof JSONArray) {
            JSONArray existingOutput = (JSONArray)JsonUtil.parseToJsonOrReturn(this.consolidatedResponse.toString());
            JSONArray parsedJsonOutput = (JSONArray)outputData;
            existingOutput.addAll((Collection)parsedJsonOutput);
            response = existingOutput.toJSONString();
            this.consolidatedResponse = new StringBuilder(response);
        } else {
            this.consolidatedResponse.append(",").append(response);
        }
    }

    private Boolean getLoopCondition(Workflow workflow, Integer iteration) throws Exception {
        boolean loopCondition = false;
        if (this.iteratorParameters.containsKey("end_iter")) {
            String iteratorArray;
            String dynamicEndIter = String.valueOf(this.iteratorParameters.get("end_iter"));
            if (dynamicEndIter.contains("==")) {
                String[] listString = dynamicEndIter.split("\\=\\=");
                String value = DynamicParamExtractor.fetchDynamicParam(workflow, listString[0].trim());
                if (value != null) {
                    loopCondition = !listString[1].trim().equalsIgnoreCase(value);
                }
            } else if (dynamicEndIter.contains("length") && (iteratorArray = DynamicParamExtractor.fetchDynamicParam(workflow, String.valueOf(this.iteratorParameters.get("iterator")))) != null) {
                JSONArray iteratorJsonArray = JsonUtil.parseToJsonArray(iteratorArray);
                boolean bl = loopCondition = iteration < iteratorJsonArray.size();
            }
            if (loopCondition) {
                boolean bl = loopCondition = !this.iteratorParameters.containsKey("iter_limit") || (Integer)this.iteratorParameters.get("iter_limit") > iteration;
            }
            if (loopCondition && this.queryParameters != null && this.queryParameters.containsKey("offset") && this.iteratorParameters.containsKey("batch_size")) {
                int batchSize = (Integer)this.iteratorParameters.get("batch_size");
                int offset = Integer.valueOf(this.queryParameters.get("offset"));
                this.queryParameters.put("offset", String.valueOf(offset + batchSize));
            }
        }
        return loopCondition;
    }

    public Map<String, Object> generatePayload(Workflow workflow, State state) throws Exception {
        Map<String, Object> payload;
        if (Util.isNotNullOrEmpty(this.getPayloadMapping())) {
            Object payloadFromMapping = JsonUtil.parseToJson(DynamicParamExtractor.fetchDynamicParam(workflow, this.getPayloadMapping()));
            this.setPayload((Map<String, Object>)((JSONObject)payloadFromMapping));
        }
        if ((payload = DynamicParamExtractor.resolveMap(this.getPayload(), workflow)) == null) {
            throw new Exception("Error: Action " + state.getId() + "." + this.getId() + " failed. Invalid payload. Skipping this.");
        }
        return payload;
    }

    public Map<String, Object> generateRestApiHeaders(AuthInfo authInfo, Workflow workflow) {
        Map<String, Object> headers = authInfo.getHeaders();
        String authorizationHeader = "";
        try {
            if (RefAuthType.isBasic(authInfo.getAuthType()) && authInfo.isBase64Encoding()) {
                authorizationHeader = AuthorizationHeaderGenerator.generateBasicAuthorizationHeader(authInfo.getUserName(), authInfo.getPassword());
                headers.replace("Authorization", authorizationHeader);
            } else if (RefAuthType.isBearer(authInfo.getAuthType())) {
                authorizationHeader = AuthorizationHeaderGenerator.generateBearerAuthorizationHeader(workflow, String.valueOf(headers.get("Authorization")));
                headers.replace("Authorization", authorizationHeader);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while processing REST API headers. Error :", e.getMessage());
        }
        return headers;
    }
}

