/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.workflow.model.Action;

import com.dvsum.dataSource.DataSource;
import com.dvsum.factory.DataSourceFactory;
import com.dvsum.logger.CustomLogger;
import com.dvsum.logger.LogFormat;
import com.dvsum.util.JsonObjectMapperUtil;
import com.dvsum.util.JsonUtil;
import com.dvsum.util.Util;
import com.dvsum.workflow.model.Action.Action;
import com.dvsum.workflow.model.SourceConfig;
import com.dvsum.workflow.model.State;
import com.dvsum.workflow.model.Workflow;
import com.dvsum.workflow.service.DynamicParamExtractor;
import com.dvsum.workflow.service.LogHandler;
import com.dvsum.workflow.service.URLGenerator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class JdbcAction
extends Action {
    private static final CustomLogger logger = CustomLogger.getLogger(JdbcAction.class);
    private DataSourceFactory dataSourceFactory;
    @JsonProperty(value="query")
    protected String query;
    @JsonProperty(value="query_parameters")
    private Map<String, String> queryParameters;
    @JsonProperty(value="chart_config")
    protected JSONObject chartConfig;

    public DataSourceFactory getDataSourceFactory() {
        return this.dataSourceFactory;
    }

    public void setDataSourceFactory(DataSourceFactory dataSourceFactory) {
        this.dataSourceFactory = dataSourceFactory;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public Map<String, String> getQueryParameters() {
        return this.queryParameters;
    }

    public void setQueryParameters(Map<String, String> queryParameters) {
        this.queryParameters = queryParameters;
    }

    public JSONObject getChartConfig() {
        return this.chartConfig;
    }

    public void setChartConfig(JSONObject chartConfig) {
        this.chartConfig = chartConfig;
    }

    public void applyQueryParams(Workflow workflow) {
        String queryWithQueryParams = this.getQuery();
        if (this.getQueryParameters() != null) {
            for (String paramKey : this.getQueryParameters().keySet()) {
                String paramVal = this.getQueryParameters().get(paramKey);
                String attr = DynamicParamExtractor.fetchDynamicParam(workflow, paramVal);
                if (!Util.isNotNullOrEmpty(attr)) continue;
                paramVal = attr.trim();
                queryWithQueryParams = URLGenerator.replaceParam(paramKey, paramVal, queryWithQueryParams);
            }
            this.setQuery(queryWithQueryParams);
        }
    }

    @Override
    public String execute(Workflow workflow, State state, SourceConfig sourceConfig, JSONObject webhookPayload) throws Exception {
        logger.info("Executing JDBC call action. Action id :", this.getId());
        String response = "";
        try {
            String resolvedQuery = URLGenerator.resolveDynamicPathParameters(workflow, this.getQuery());
            try {
                LogHandler.sendQueryToUI(workflow.getWorkflowDataStore(), resolvedQuery);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("Error while sending query to websocket. Error: ", e.getMessage());
            }
            JSONObject responseJson = this.executeQuery(resolvedQuery, sourceConfig);
            JSONArray resultsJson = this.getResultsFromJdbcResponse(responseJson, state, this, workflow);
            response = resultsJson.toJSONString();
            if (this.iteratorParameters != null) {
                response = this.filterReponseData(response);
            }
            this.updateActionMetadata(workflow.getWorkflowDataStore(), this.outputFilePath, JsonUtil.parseToJson(response), "PENDING", "SUCCESS");
            if (this.outputMapping != null) {
                response = this.applyOutputMappings(workflow, 0);
            }
            logger.info("JDBC Action execution successful.");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while executing JDBC call action. Error :", e.getMessage());
            this.handleError(workflow, state, "Unable to execute query. Error: " + e.getMessage(), false);
        }
        return response;
    }

    public JSONArray getResultsFromJdbcResponse(JSONObject responseJson, State state, Action action, Workflow workflow) throws Exception {
        JSONArray responseArray = new JSONArray();
        JSONObject jSONObject = responseJson = responseJson.containsKey((Object)"runJson") ? (JSONObject)responseJson.get((Object)"runJson") : responseJson;
        if (!responseJson.containsKey((Object)"results")) {
            String errorMessage = "Error: Action " + state.getId() + "." + action.getId() + " Failed. Unable to retrieve query results.";
            throw new Exception(errorMessage);
        }
        responseArray = (JSONArray)responseJson.get((Object)"results");
        return responseArray;
    }

    public DataSource connectToJDBC(SourceConfig sourceConfig) {
        DataSource dataSource = null;
        try {
            String sourceType = sourceConfig.getSrcType();
            logger.info("Source Type: ", sourceType);
            JSONObject dataSourceConfigJson = JsonObjectMapperUtil.getJsonObjectFromObject(sourceConfig);
            dataSource = this.dataSourceFactory.getDataSource(String.valueOf(sourceType), dataSourceConfigJson, false, new LogFormat());
            dataSource.connect();
            logger.info("Connection successful.");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while connecting to JDBC. Error :", e.getMessage());
        }
        return dataSource;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JSONObject executeQuery(String sqlQuery, SourceConfig sourceConfig) {
        DataSource dataSource;
        long startTime;
        JSONObject resultsJson;
        block26: {
            resultsJson = new JSONObject();
            startTime = System.currentTimeMillis();
            dataSource = this.connectToJDBC(sourceConfig);
            try {
                try {
                    Throwable throwable = null;
                    Object var8_9 = null;
                    try {
                        Connection conn = dataSource.connection;
                        try {
                            block25: {
                                Statement stmt = conn.createStatement();
                                try {
                                    try (ResultSet rs = stmt.executeQuery(sqlQuery);){
                                        stmt.setQueryTimeout(60);
                                        if (!conn.isValid(2)) {
                                            throw new SQLException("Connection invalid");
                                        }
                                        if (rs.next()) {
                                            resultsJson = new JsonUtil().ResultSet2JSONObject(rs, false);
                                        } else {
                                            resultsJson.put((Object)"status", (Object)"empty");
                                        }
                                        dataSource.connection.close();
                                    }
                                    if (stmt == null) break block25;
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    if (stmt == null) throw throwable;
                                    stmt.close();
                                    throw throwable;
                                }
                                stmt.close();
                            }
                            if (conn == null) break block26;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (conn == null) throw throwable;
                            conn.close();
                            throw throwable;
                        }
                        conn.close();
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                            throw throwable;
                        }
                        if (throwable == throwable4) throw throwable;
                        throwable.addSuppressed(throwable4);
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    logger.error("Error while running SQL Query: {}", sqlQuery, e);
                    resultsJson.put((Object)"error", (Object)e.getMessage());
                    dataSource.disconnect();
                    logger.debug("Execution Time: {}s", (double)(System.currentTimeMillis() - startTime) / 1000.0);
                    return resultsJson;
                }
            }
            catch (Throwable throwable) {
                dataSource.disconnect();
                logger.debug("Execution Time: {}s", (double)(System.currentTimeMillis() - startTime) / 1000.0);
                throw throwable;
            }
        }
        dataSource.disconnect();
        logger.debug("Execution Time: {}s", (double)(System.currentTimeMillis() - startTime) / 1000.0);
        return resultsJson;
    }
}

