/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.workflow.model.Action;

import com.dvsum.logger.CustomLogger;
import com.dvsum.util.FileUtil;
import com.dvsum.util.HttpRequestUtil;
import com.dvsum.util.JsonObjectMapperUtil;
import com.dvsum.util.TLSHttpsRequestor;
import com.dvsum.util.Util;
import com.dvsum.workflow.model.Action.Action;
import com.dvsum.workflow.model.CustomFunction;
import com.dvsum.workflow.model.SourceConfig;
import com.dvsum.workflow.model.State;
import com.dvsum.workflow.model.Workflow;
import com.dvsum.workflow.service.DynamicParamExtractor;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONObject;

public class CustomFunctionAction
extends Action {
    private static final CustomLogger logger = CustomLogger.getLogger(CustomFunctionAction.class);
    @JsonProperty(value="function")
    protected String function;
    @JsonProperty(value="function_call")
    protected String functionCall;
    @JsonProperty(value="function_params")
    protected Map<String, Object> functionParams;
    private String pythonCodeExecutionApiUrl;

    public String getFunction() {
        return this.function;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public String getFunctionCall() {
        return this.functionCall;
    }

    public void setFunctionCall(String functionCall) {
        this.functionCall = functionCall;
    }

    public Map<String, Object> getFunctionParams() {
        return this.functionParams;
    }

    public void setFunctionParams(Map<String, Object> functionParams) {
        this.functionParams = functionParams;
    }

    public String getPythonCodeExecutionApiUrl() {
        return this.pythonCodeExecutionApiUrl;
    }

    public void setPythonCodeExecutionApiUrl(String pythonCodeExecutionApiUrl) {
        this.pythonCodeExecutionApiUrl = pythonCodeExecutionApiUrl;
    }

    @Override
    public String execute(Workflow workflow, State state, SourceConfig sourceConfig, JSONObject webhookPayload) throws Exception {
        String response = null;
        try {
            if (!Util.isNotNullOrEmpty(this.getFunction())) {
                throw new Exception("For " + state.getId() + "." + this.id + ", function is empty or null.");
            }
            CustomFunction customFunction = workflow.findCustomFunction(this.getFunction());
            response = this.executePythonScript(workflow, customFunction);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            throw e;
        }
        return response;
    }

    public String executePythonScript(Workflow workflow, CustomFunction customFunction) {
        String response = null;
        try {
            Map<String, Object> payload = this.generatePayloadForPythonService(workflow, customFunction);
            String stringifiedPayload = JsonObjectMapperUtil.getJsonStringFromObject(payload);
            boolean isCloudSaws = Boolean.parseBoolean(FileUtil.getPropertyWithDefault("is.cloud.saws", "false"));
            if (isCloudSaws) {
                response = TLSHttpsRequestor.postJsonData(this.getPythonCodeExecutionApiUrl(), stringifiedPayload, FileUtil.getAPIkey());
            } else {
                String host = "127.0.0.1";
                String pythonServicePort = FileUtil.getPropertyWithDefault("python.service.port", "8190");
                String url = String.format("http://%s:%s/code-execution/python", host, pythonServicePort);
                response = HttpRequestUtil.sendPostRequest(url, stringifiedPayload);
            }
        }
        catch (Exception e) {
            logger.error("Error while executing python script. Error:", e.getMessage());
            e.printStackTrace();
        }
        return response;
    }

    public Map<String, Object> generatePayloadForPythonService(Workflow workflow, CustomFunction customFunction) {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("function_params", this.resolveFunctionParams(workflow));
        payload.put("function", customFunction.getFunction());
        payload.put("code", customFunction.downloadCode());
        payload.put("function_call", this.getFunctionCall());
        return payload;
    }

    public Map<String, Object> resolveFunctionParams(Workflow workflow) {
        return DynamicParamExtractor.resolveMap(this.functionParams, workflow);
    }

    public static void main(String[] args) {
    }
}

