/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.workflow.controller;

import com.dvsum.controller.BaseController;
import com.dvsum.logger.CustomLogger;
import com.dvsum.util.JsonUtil;
import com.dvsum.util.TLSHttpsRequestor;
import com.dvsum.workflow.service.WorkflowExecutionService;
import javax.servlet.http.HttpServletRequest;
import org.json.simple.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/webservice"})
public class WorkflowController
extends BaseController {
    private static final long serialVersionUID = -5685734283467606858L;
    private static final CustomLogger logger = CustomLogger.getLogger(WorkflowController.class);
    @Autowired
    private WorkflowExecutionService workflowExecutionService;

    @CrossOrigin
    @ResponseBody
    @PostMapping(value={"/integrations/webhook"})
    public ResponseEntity<String> processWebhookRequest(HttpServletRequest request, @RequestBody String body) {
        try {
            Thread executionThread = new Thread(() -> {
                try {
                    this.sendEmail(body);
                    logger.info("Webhook payload received: ", body);
                    JSONObject webhookPayload = JsonUtil.parseToJsonObject(body);
                    this.workflowExecutionService.resumeExecution(webhookPayload);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error("Error while processing webhook response. Error = " + e.getMessage());
                }
            });
            executionThread.start();
            return ResponseEntity.ok((Object)"Gateway execution is in progress...");
        }
        catch (Exception e) {
            logger.error("Error while processing webhook request", e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"An error occurred while processing the webhook request");
        }
    }

    private void sendEmail(String payload) {
        try {
            TLSHttpsRequestor.executePost("https://apis-dev.dvsum.ai/mock/lla/api3", payload, new String[0], new String[0]);
        }
        catch (Exception e) {
            logger.error("Error while sending email. Error: ", e.getMessage());
            e.printStackTrace();
        }
    }

    @CrossOrigin
    @ResponseBody
    @PostMapping(value={"/workflow/execute"})
    public ResponseEntity<String> executeWorkflow(@RequestBody String body) {
        Thread executionThread = new Thread(() -> {
            try {
                JSONObject workflowJson = JsonUtil.parseToJsonObject(body);
                this.workflowExecutionService.startExecution(workflowJson);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("Error while executing query. Error = " + e.getMessage());
            }
        });
        executionThread.start();
        return ResponseEntity.ok((Object)"Gateway execution in progress...");
    }

    private boolean validateApiKey(HttpServletRequest request) {
        String apiKey = request.getHeader("x-api-key");
        logger.info("X-API-KEY :", apiKey);
        if (apiKey == null || apiKey.trim().isEmpty()) {
            return false;
        }
        apiKey = apiKey.trim();
        String HARD_CODED_API_KEY = "5lp8dMV2HXXEzNt7DCzs7OI0r25Vulw9vCROfhrh";
        return apiKey.equals(HARD_CODED_API_KEY);
    }
}

