/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.websocket;

import com.dvsum.logger.CustomLogger;
import com.dvsum.services.AnalyticsQueryExecutorService;
import com.dvsum.services.DataSourceConnectionService;
import com.dvsum.services.RuleExecutionService;
import com.dvsum.util.FileUtil;
import com.dvsum.util.JsonUtil;
import com.dvsum.util.TLSHttpsRequestor;
import com.dvsum.util.Util;
import com.dvsum.websocket.APIGatewayWebsocketClient;
import com.dvsum.workflow.service.WorkflowExecutionService;
import java.net.URI;
import org.java_websocket.handshake.ServerHandshake;
import org.json.simple.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ConnectionManager {
    public static APIGatewayWebsocketClient client;
    @Autowired
    AnalyticsQueryExecutorService analyticsQueryExecutorService;
    @Autowired
    RuleExecutionService ruleExecutionService;
    @Autowired
    WorkflowExecutionService workflowExecutionService;
    @Autowired
    DataSourceConnectionService cdataTestConnectionService;
    @Value(value="${websocket.URL}")
    private String websocketURL;
    @Value(value="${get.websocket.url}")
    private String getWebsocketURL;
    private static final CustomLogger logger;

    static {
        logger = CustomLogger.getLogger(ConnectionManager.class);
    }

    @Scheduled(fixedDelay=60000L)
    public void connect() {
        String API_KEY = FileUtil.getAPIkey();
        if ((client == null || !client.isOpen()) && Util.isNotNullOrEmpty(API_KEY)) {
            client = new APIGatewayWebsocketClient(this.getServerURI(), this, this.analyticsQueryExecutorService, this.ruleExecutionService, this.workflowExecutionService, this.cdataTestConnectionService);
            client.connectToApiGatewayWebsocket();
            client.addHeader("x-api-key", API_KEY);
        } else {
            logger.info("Socket is connected .... ");
        }
    }

    public static boolean checkConnection(String websocketUrl, String API_KEY) {
        final boolean[] isConnected = new boolean[1];
        final boolean[] connectionAttemptComplete = new boolean[1];
        try {
            URI serverURI = new URI(websocketUrl);
            APIGatewayWebsocketClient websocketClient = new APIGatewayWebsocketClient(serverURI, null, null, null, null, null){

                @Override
                public void onOpen(ServerHandshake handshake) {
                    super.onOpen(handshake);
                    isConnected[0] = true;
                    connectionAttemptComplete[0] = true;
                }

                @Override
                public void onError(Exception ex) {
                    super.onError(ex);
                    isConnected[0] = false;
                    connectionAttemptComplete[0] = true;
                    logger.error("WebSocket connection error: " + ex.getMessage());
                }
            };
            if (Util.isNotNullOrEmpty(API_KEY)) {
                websocketClient.addHeader("x-api-key", API_KEY);
            }
            websocketClient.connectToApiGatewayWebsocket();
            long startTime = System.currentTimeMillis();
            long timeout = 30000L;
            while (!connectionAttemptComplete[0] && System.currentTimeMillis() - startTime < timeout) {
                Thread.sleep(1000L);
            }
            if (!connectionAttemptComplete[0]) {
                logger.error("WebSocket connection attempt timed out");
                isConnected[0] = false;
            }
            if (websocketClient.isOpen()) {
                logger.info("Closing WebSocket connection.");
                websocketClient.close();
            }
        }
        catch (Exception e) {
            isConnected[0] = false;
            logger.error("Error while building connection to WebSocket. Error: " + e.getMessage());
            e.printStackTrace();
        }
        return isConnected[0];
    }

    public static void sendWebsocketMessageWithRetry(JSONObject websocketMessage) {
        int maxRetries = 5;
        int retryDelayMillis = 30000;
        int retry = 1;
        while (retry <= maxRetries) {
            try {
                client.sendMessage(websocketMessage.toJSONString());
                break;
            }
            catch (Exception e) {
                if (retry < maxRetries) {
                    logger.error("Error while sending the websocket message. Retrying (Attempt " + retry + " of " + maxRetries + ")");
                    try {
                        Thread.sleep(retryDelayMillis);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                } else {
                    logger.error("Failed to send websocket message after " + maxRetries + " retries. Error: " + e.getMessage());
                }
                ++retry;
            }
        }
    }

    private URI getServerURI() {
        try {
            String response;
            String socketURL = this.websocketURL;
            String websocketApiUrl = this.getWebsocketURL;
            String API_KEY = FileUtil.getAPIkey();
            if (Util.isNullOrEmpty(socketURL) && Util.isNotNullOrEmpty(response = TLSHttpsRequestor.executeGet(websocketApiUrl, new Object[0], new Object[0], API_KEY))) {
                JSONObject responseJson = JsonUtil.parseToJsonObject(response);
                socketURL = String.valueOf(responseJson.get((Object)"websocket_connection_url"));
            }
            logger.info("websocket URL: " + socketURL);
            return new URI(socketURL);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void reconnect() {
        this.close();
        this.connect();
    }

    public void sendMessage(String websocketMessage) throws Exception {
        client.sendMessage(websocketMessage);
    }

    public void close() {
        if (client != null) {
            client.close();
            client = null;
        }
    }
}

