/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.websocket;

import com.dvsum.logger.CustomLogger;
import com.dvsum.logger.LogFormat;
import com.dvsum.services.AnalyticsQueryExecutorService;
import com.dvsum.services.DataSourceConnectionService;
import com.dvsum.services.ExecutorServiceHandler;
import com.dvsum.services.RuleExecutionService;
import com.dvsum.util.FileUtil;
import com.dvsum.util.JsonUtil;
import com.dvsum.util.Util;
import com.dvsum.websocket.ConnectionManager;
import com.dvsum.websocket.SSLContextManager;
import com.dvsum.workflow.service.WorkflowExecutionService;
import java.net.URI;
import java.util.concurrent.Executors;
import javax.net.ssl.SSLContext;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.json.simple.JSONObject;

public class APIGatewayWebsocketClient
extends WebSocketClient {
    private static final CustomLogger logger = CustomLogger.getLogger(APIGatewayWebsocketClient.class);
    private final ConnectionManager connectionManager;
    private AnalyticsQueryExecutorService analyticsQueryExecutorService;
    private RuleExecutionService ruleExecutionService;
    private WorkflowExecutionService workflowExecutionService;
    private DataSourceConnectionService cdataTestConnectionService;
    private JsonUtil jsonUtil;

    public APIGatewayWebsocketClient(URI serverUri, ConnectionManager connectionManager, AnalyticsQueryExecutorService analyticsQueryExecutorService, RuleExecutionService ruleExecutionService, WorkflowExecutionService workflowExecutionService, DataSourceConnectionService cdataTestConnectionService) {
        super(serverUri);
        this.connectionManager = connectionManager;
        this.jsonUtil = new JsonUtil();
        this.analyticsQueryExecutorService = analyticsQueryExecutorService;
        this.ruleExecutionService = ruleExecutionService;
        this.workflowExecutionService = workflowExecutionService;
        this.cdataTestConnectionService = cdataTestConnectionService;
    }

    public void sendMessage(String message) throws Exception {
        if (!this.isOpen()) {
            JSONObject messageJson = this.jsonUtil.parseStringToJsonObject(message);
            if (messageJson.get((Object)"context") == null || Util.isNullOrEmpty(String.valueOf(messageJson.get((Object)"context"))) || !String.valueOf(messageJson.get((Object)"context")).equals("logSync")) {
                logger.error("WebSocket connection is not open. Cannot send message: " + message);
            }
            throw new Exception("Websocket Connection Closed unexpectedly.");
        }
        this.send(message);
    }

    public void onOpen(ServerHandshake handshake) {
        logger.info("Connected to API Gateway WebSocket endpoint: " + this.getURI());
        String isCloudSAWS = FileUtil.getPropertyWithDefault("is.cloud.saws", "false");
        String jobIds = ExecutorServiceHandler.getExistingJobIds();
        if (isCloudSAWS.equals("true") && jobIds != null) {
            JSONObject message = new JSONObject();
            message.put((Object)"job_ids", (Object)jobIds);
            message.put((Object)"is_cloud_saws", (Object)isCloudSAWS);
            JSONObject websocketMessage = new JSONObject();
            websocketMessage.put((Object)"context", (Object)"reconnectSocketConnection");
            websocketMessage.put((Object)"source", (Object)"dvsumConnector");
            websocketMessage.put((Object)"type", (Object)"JobIds");
            websocketMessage.put((Object)"message", (Object)message);
            logger.info("Sending websocket message after reconnecting ", websocketMessage.toJSONString());
            ConnectionManager.sendWebsocketMessageWithRetry(websocketMessage);
        }
    }

    public void onClose(int code, String reason, boolean remote) {
        logger.info("Disconnected from API Gateway WebSocket endpoint: " + reason);
        logger.info("Error code: ", code);
        if (code == 1001 || "going away".equalsIgnoreCase(reason)) {
            this.connectionManager.reconnect();
        }
    }

    public void onMessage(String websocketMessage) {
        Executors.newSingleThreadExecutor().submit(() -> {
            block22: {
                logger.info("Received message from API Gateway WebSocket endpoint...");
                LogFormat logFormat = new LogFormat();
                try {
                    JSONObject websocketMessageJSON;
                    block23: {
                        String action;
                        websocketMessageJSON = this.jsonUtil.parseStringToJsonObject(websocketMessage);
                        if (!websocketMessageJSON.containsKey((Object)"action")) break block23;
                        switch (action = String.valueOf(websocketMessageJSON.get((Object)"action"))) {
                            case "cancel-scan": {
                                JSONObject cancelScanDetails = (JSONObject)websocketMessageJSON.get((Object)"message");
                                logFormat.setLogFormat("scan", cancelScanDetails);
                                String jobId = (String)cancelScanDetails.get((Object)"scan_id");
                                logger.info(logFormat.getFormattedLog(), "Cancel scan request received for scan job :", jobId);
                                ExecutorServiceHandler.shutDownExecutorService(jobId);
                                logger.info(logFormat.getFormattedLog(), "Scan job", jobId, "cancelled successfully.");
                                break;
                            }
                            case "job-exec-cancel-scan": {
                                JSONObject cancelJobDetails = (JSONObject)websocketMessageJSON.get((Object)"message");
                                logFormat.setLogFormat("rule", cancelJobDetails);
                                String jobId = (String)cancelJobDetails.get((Object)"job_id");
                                logger.info(logFormat.getFormattedLog(), "Cancel scan request received for job :", jobId);
                                ExecutorServiceHandler.shutDownExecutorService(jobId);
                                logger.info(logFormat.getFormattedLog(), "job", jobId, "cancelled successfully.");
                                break;
                            }
                            case "job-exec": {
                                logger.info("Job Execution request received.");
                                JSONObject ruleExecutionMetadata = this.ruleExecutionService.getExecutionMetadataFromPayload(websocketMessageJSON);
                                this.ruleExecutionService.startExecution(ruleExecutionMetadata);
                                break;
                            }
                            case "workflow-exec": {
                                logger.info("Request received for workflow execution.");
                                JSONObject workflowJson = (JSONObject)websocketMessageJSON.get((Object)"message");
                                this.workflowExecutionService.startExecution(workflowJson);
                                break;
                            }
                            case "authenticate": {
                                JSONObject getDatabasesDetails = (JSONObject)websocketMessageJSON.get((Object)"message");
                                String srcId = String.valueOf(getDatabasesDetails.get((Object)"src_id"));
                                logFormat.setLogFormat("scan", "", srcId);
                                logger.info(logFormat.getFormattedLog(), "Request received for getting databases.");
                                this.cdataTestConnectionService.getDatabases(JsonUtil.getJsonString(getDatabasesDetails), Integer.parseInt(srcId), logFormat);
                                break;
                            }
                            default: {
                                logger.info("No suitable action defined in websocket message. Received action is ", action);
                                break;
                            }
                        }
                        break block22;
                    }
                    logFormat.setLogFormat("chat", websocketMessageJSON);
                    if (websocketMessageJSON.get((Object)"query_id") == null) {
                        return;
                    }
                    logger.info(logFormat.getFormattedLog(), "CADDI request received for query id :", String.valueOf(websocketMessageJSON.get((Object)"query_id")));
                    this.analyticsQueryExecutorService.executeQueries(websocketMessageJSON, logFormat);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error("websocket on message Error: ", e);
                }
            }
        });
    }

    public void onError(Exception ex) {
        ex.printStackTrace();
        logger.error("websocket Error: ", ex);
    }

    public void connectToApiGatewayWebsocket() {
        try {
            SSLContext sslContext = SSLContextManager.createSSLContext();
            this.setSocketFactory(sslContext.getSocketFactory());
            this.connect();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("connect websocket Error: ", e);
        }
    }
}

