/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.util;

import com.dvsum.logger.CustomLogger;
import com.dvsum.util.DateUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class Util {
    private static final CustomLogger logger = CustomLogger.getLogger(Util.class);

    public static void main(String[] arg) {
    }

    public static boolean isNullOrEmpty(String value) {
        return value == null || "".equals(value) || "null".equalsIgnoreCase(value);
    }

    public static boolean isNotNullOrEmpty(String value) {
        return !Util.isNullOrEmpty(value);
    }

    public static boolean isNullOrEmptyTrimmed(String value) {
        return value == null || "".equals(value.trim()) || "null".equals(value);
    }

    public static String concate(List<? extends Object> strings, String seprater) {
        if (strings == null) {
            return "";
        }
        return Util.concate(strings.toArray(new Object[strings.size()]), seprater);
    }

    public static String concate(Object[] strings, String seprater) {
        String str = "";
        if (strings != null) {
            Object[] objectArray = strings;
            int n = strings.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj != null && !Util.isNullOrEmptyTrimmed(obj.toString())) {
                    if (!str.isEmpty()) {
                        str = String.valueOf(str) + seprater;
                    }
                    str = String.valueOf(str) + obj.toString();
                }
                ++n2;
            }
        }
        return str;
    }

    public static Double parseDouble(String value) {
        if (Util.isNullOrEmpty(value)) {
            return null;
        }
        try {
            return Double.valueOf(value);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static Boolean parseBoolean(String value) {
        try {
            return Boolean.valueOf(value);
        }
        catch (Exception e) {
            logger.error("Exception: ", e);
            return null;
        }
    }

    public static Long parseLong(String value) {
        if (Util.isNullOrEmpty(value)) {
            return null;
        }
        try {
            return Long.valueOf(value.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static Integer parseInteger(String value) {
        if (Util.isNullOrEmpty(value)) {
            return null;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static List<Long> splitIds(String str, String seprator) {
        String[] arr;
        ArrayList<Long> ids = new ArrayList<Long>();
        if (Util.isNullOrEmpty(str) || Util.isNullOrEmpty(seprator)) {
            return ids;
        }
        String[] stringArray = arr = str.split(seprator);
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            String idStr = stringArray[n2];
            Long id = Util.parseLong(idStr.trim());
            if (id != null) {
                ids.add(id);
            }
            ++n2;
        }
        return ids;
    }

    public static String[] split(String str, String seprator) {
        if (Util.isNullOrEmpty(str) || Util.isNullOrEmpty(seprator)) {
            return new String[0];
        }
        return str.split(seprator);
    }

    public static String getUniqueId() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String getHexString(Long id, int length) {
        if (id == null) {
            return null;
        }
        String str = Long.toHexString(id);
        while (str.length() < length) {
            str = "0" + str;
        }
        return str;
    }

    public static String getFileExtension(String fileName) {
        if (Util.isNullOrEmptyTrimmed(fileName)) {
            return null;
        }
        int mid = fileName.lastIndexOf(".");
        if (mid < 0) {
            return null;
        }
        return fileName.substring(mid + 1);
    }

    public static Long[] toArray(List<Long> ids) {
        if (ids != null) {
            return ids.toArray(new Long[ids.size()]);
        }
        return new Long[0];
    }

    public static String getFormatString(String queryKeyword) {
        if (Util.isNullOrEmptyTrimmed(queryKeyword)) {
            return null;
        }
        String formatedString = "";
        String[] stringArray = queryKeyword.split(" ");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            if (!Util.isNullOrEmptyTrimmed(word)) {
                formatedString = String.valueOf(formatedString) + word + " ";
            }
            ++n2;
        }
        return formatedString.trim();
    }

    public static String formatStringForUrlQuery(String queryKeyword) {
        String urlQuery = "";
        String[] queryTokens = queryKeyword.split(" ");
        int index = 0;
        while (index < queryTokens.length) {
            urlQuery = index == queryKeyword.split(" ").length - 1 ? String.valueOf(urlQuery) + queryTokens[index] : String.valueOf(urlQuery) + queryTokens[index] + "+";
            ++index;
        }
        return urlQuery;
    }

    public static String getUserEmailAddress(HttpServletRequest request) {
        String userKey = (String)request.getSession().getAttribute("loggedInUserName");
        return userKey;
    }

    public static double roundDouble(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        long factor = (long)Math.pow(10.0, places);
        long tmp = Math.round(value *= (double)factor);
        return (double)tmp / (double)factor;
    }

    public static JSONArray getJsonFromResultSet(ResultSet rs) throws Exception {
        JSONArray json = new JSONArray();
        ResultSetMetaData rsmd = rs.getMetaData();
        while (rs.next()) {
            int numColumns = rsmd.getColumnCount();
            JSONObject obj = new JSONObject();
            int i = 1;
            while (i < numColumns + 1) {
                String column_name = rsmd.getColumnName(i);
                Object columnValue = rs.getObject(i);
                if (columnValue == null) {
                    obj.put((Object)column_name, rs.getObject(i));
                } else if (rsmd.getColumnType(i) == 2003) {
                    obj.put((Object)column_name, (Object)rs.getArray(i));
                } else if (rsmd.getColumnType(i) == -5) {
                    obj.put((Object)column_name, (Object)rs.getInt(i));
                } else if (rsmd.getColumnType(i) == 16) {
                    obj.put((Object)column_name, (Object)rs.getBoolean(i));
                } else if (rsmd.getColumnType(i) == 2004) {
                    obj.put((Object)column_name, (Object)rs.getBlob(i));
                } else if (rsmd.getColumnType(i) == 8) {
                    obj.put((Object)column_name, (Object)rs.getDouble(i));
                } else if (rsmd.getColumnType(i) == 6) {
                    obj.put((Object)column_name, (Object)Float.valueOf(rs.getFloat(i)));
                } else if (rsmd.getColumnType(i) == 4) {
                    obj.put((Object)column_name, (Object)rs.getInt(i));
                } else if (rsmd.getColumnType(i) == -9) {
                    obj.put((Object)column_name, (Object)rs.getNString(i));
                } else if (rsmd.getColumnType(i) == 12) {
                    obj.put((Object)column_name, (Object)rs.getString(i));
                } else if (rsmd.getColumnType(i) == -6) {
                    obj.put((Object)column_name, (Object)rs.getInt(i));
                } else if (rsmd.getColumnType(i) == 5) {
                    obj.put((Object)column_name, (Object)rs.getInt(i));
                } else if (rsmd.getColumnType(i) == 91) {
                    obj.put((Object)column_name, (Object)DateUtil.getFormattedStr(rs.getDate(i), "MM/dd/yyyy"));
                } else if (rsmd.getColumnType(i) == 93) {
                    obj.put((Object)column_name, (Object)DateUtil.getFormattedStr(rs.getTimestamp(i), "MM/dd/yyyy"));
                } else {
                    obj.put((Object)column_name, rs.getObject(i));
                }
                ++i;
            }
            json.add((Object)obj);
        }
        return json;
    }

    public static String getStacktrace(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    public static boolean checkIfMachineIs64Bit() {
        boolean is64bit = false;
        is64bit = System.getProperty("os.name").contains("Windows") ? System.getenv("ProgramFiles(x86)") != null : System.getProperty("os.arch").indexOf("64") != -1;
        return is64bit;
    }

    public static List<String> splitStringIntoBatches(String content, int charLimitInBatch) {
        ArrayList<String> splitStrings = new ArrayList<String>();
        while (content.length() > charLimitInBatch) {
            int endIndex = content.lastIndexOf("\r\n", charLimitInBatch);
            if (endIndex <= 0) {
                endIndex = charLimitInBatch;
            }
            String chunk = content.substring(0, endIndex + 2);
            splitStrings.add(chunk);
            content = endIndex + 2 < content.length() && content.charAt(endIndex + 2) != '\r' ? content.substring(endIndex + 2) : content.substring(endIndex + 2).trim();
        }
        if (!content.isEmpty()) {
            splitStrings.add(content);
        }
        return splitStrings;
    }
}

