/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.util;

import com.dvsum.exception.FileUploadException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.springframework.web.multipart.MultipartFile;

public class UnzipUtil {
    private static final int BUFFER_SIZE = 4096;

    public static void unzip(String destDirectory, MultipartFile zipFile) throws Exception {
        File destDir = new File(destDirectory);
        if (!destDir.exists()) {
            throw new FileUploadException("Destination folder " + destDir.getName() + " does not exist. Please contact your System Administrator or DvSum Support");
        }
        ZipInputStream zipIn = new ZipInputStream(zipFile.getInputStream());
        ZipEntry entry = zipIn.getNextEntry();
        while (entry != null) {
            String filePath = String.valueOf(destDirectory) + File.separator + entry.getName();
            if (entry.isDirectory()) {
                throw new FileUploadException("The zip file uploaded has errors. Only zip files without sub-folders can be added");
            }
            UnzipUtil.extractFile(zipIn, filePath);
            zipIn.closeEntry();
            entry = zipIn.getNextEntry();
        }
        zipIn.close();
    }

    private static void extractFile(ZipInputStream zipIn, String filePath) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));
        byte[] bytesIn = new byte[4096];
        int read = 0;
        while ((read = zipIn.read(bytesIn)) != -1) {
            bos.write(bytesIn, 0, read);
        }
        bos.close();
    }
}

