/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.util;

import com.dvsum.logger.CustomLogger;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;

public class TimezoneUtil {
    private static final CustomLogger logger = CustomLogger.getLogger(TimezoneUtil.class);

    public static String[] getLocalTimeZone() {
        try {
            ZoneId zone = ZoneId.systemDefault();
            ZoneOffset offset = zone.getRules().getOffset(Instant.now());
            int hours = offset.getTotalSeconds() / 3600;
            int minutes = Math.abs(offset.getTotalSeconds() % 3600) / 60;
            String symbol = offset.getTotalSeconds() >= 0 ? "+" : "-";
            String zoneId = zone.getId();
            String offsetFromUTC = String.format("%s%02d:%02d", symbol, hours, minutes);
            logger.info("Gateway Local Time Zone ID: " + zoneId);
            logger.info("Gateway Local Time Zone Offset from UTC: " + offsetFromUTC);
            return new String[]{zoneId, offsetFromUTC};
        }
        catch (Exception e) {
            logger.error("Error occurred while retrieving time zone information: " + e.getMessage());
            return new String[]{"Unknown", "Unknown"};
        }
    }
}

