/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.util;

import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.Comparator;

public final class ThreadUtilities {
    private static ThreadGroup rootThreadGroup = null;

    public static void main(String[] args) {
        Thread[] th = ThreadUtilities.getAllThreads();
        System.out.println(th.length);
    }

    private ThreadUtilities() {
    }

    public static ThreadGroup getRootThreadGroup() {
        ThreadGroup ptg;
        if (rootThreadGroup != null) {
            return rootThreadGroup;
        }
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        while ((ptg = tg.getParent()) != null) {
            tg = ptg;
        }
        rootThreadGroup = tg;
        return tg;
    }

    public static ThreadGroup[] getAllThreadGroups() {
        ThreadGroup root = ThreadUtilities.getRootThreadGroup();
        int nAlloc = root.activeGroupCount();
        int n = 0;
        ThreadGroup[] groups = null;
        while ((n = root.enumerate(groups = new ThreadGroup[nAlloc *= 2], true)) == nAlloc) {
        }
        ThreadGroup[] allGroups = new ThreadGroup[n + 1];
        allGroups[0] = root;
        System.arraycopy(groups, 0, allGroups, 1, n);
        return allGroups;
    }

    public static ThreadGroup getThreadGroup(String name) {
        ThreadGroup[] groups;
        if (name == null) {
            throw new NullPointerException("Null name");
        }
        ThreadGroup[] threadGroupArray = groups = ThreadUtilities.getAllThreadGroups();
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            ThreadGroup group = threadGroupArray[n2];
            if (group.getName().equals(name)) {
                return group;
            }
            ++n2;
        }
        return null;
    }

    public static Thread[] getAllThreads() {
        ThreadGroup root = ThreadUtilities.getRootThreadGroup();
        ThreadMXBean thbean = ManagementFactory.getThreadMXBean();
        int nAlloc = thbean.getThreadCount();
        int n = 0;
        Thread[] threads = null;
        while ((n = root.enumerate(threads = new Thread[nAlloc *= 2], true)) == nAlloc) {
        }
        return Arrays.copyOf(threads, n);
    }

    public static Thread[] getGroupThreads(ThreadGroup group) {
        if (group == null) {
            throw new NullPointerException("Null group");
        }
        int nAlloc = group.activeCount();
        int n = 0;
        Thread[] threads = null;
        while ((n = group.enumerate(threads = new Thread[nAlloc *= 2], false)) == nAlloc) {
        }
        return Arrays.copyOf(threads, n);
    }

    public static Thread[] getGroupThreads(String name) {
        ThreadGroup group = ThreadUtilities.getThreadGroup(name);
        if (group == null) {
            return null;
        }
        return ThreadUtilities.getGroupThreads(group);
    }

    public static Thread[] getAllThreadsPrioritized() {
        Thread[] allThreads = ThreadUtilities.getAllThreads();
        Arrays.sort(allThreads, new Comparator<Thread>(){

            @Override
            public int compare(Thread t1, Thread t2) {
                return t2.getPriority() - t1.getPriority();
            }
        });
        return allThreads;
    }

    public static Thread[] getAllDaemonThreads() {
        Thread[] allThreads = ThreadUtilities.getAllThreads();
        Thread[] daemons = new Thread[allThreads.length];
        int nDaemon = 0;
        Thread[] threadArray = allThreads;
        int n = allThreads.length;
        int n2 = 0;
        while (n2 < n) {
            Thread thread = threadArray[n2];
            if (thread.isDaemon()) {
                daemons[nDaemon++] = thread;
            }
            ++n2;
        }
        return Arrays.copyOf(daemons, nDaemon);
    }

    public static Thread[] getAllThreads(Thread.State state) {
        Thread[] allThreads = ThreadUtilities.getAllThreads();
        Thread[] found = new Thread[allThreads.length];
        int nFound = 0;
        Thread[] threadArray = allThreads;
        int n = allThreads.length;
        int n2 = 0;
        while (n2 < n) {
            Thread thread = threadArray[n2];
            if (thread.getState() == state) {
                found[nFound++] = thread;
            }
            ++n2;
        }
        return Arrays.copyOf(found, nFound);
    }

    public static Thread getThread(String name) {
        Thread[] threads;
        if (name == null) {
            throw new NullPointerException("Null name");
        }
        Thread[] threadArray = threads = ThreadUtilities.getAllThreads();
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            Thread thread = threadArray[n2];
            if (thread.getName().equals(name)) {
                return thread;
            }
            ++n2;
        }
        return null;
    }

    public static Thread getThread(long id) {
        Thread[] threads;
        Thread[] threadArray = threads = ThreadUtilities.getAllThreads();
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            Thread thread = threadArray[n2];
            if (thread.getId() == id) {
                return thread;
            }
            ++n2;
        }
        return null;
    }

    public static Thread getThread(ThreadInfo info) {
        if (info == null) {
            throw new NullPointerException("Null info");
        }
        return ThreadUtilities.getThread(info.getThreadId());
    }

    public static ThreadInfo[] getAllThreadInfos() {
        ThreadMXBean thbean = ManagementFactory.getThreadMXBean();
        long[] ids = thbean.getAllThreadIds();
        ThreadInfo[] infos = !thbean.isObjectMonitorUsageSupported() || !thbean.isSynchronizerUsageSupported() ? thbean.getThreadInfo(ids) : thbean.getThreadInfo(ids, true, true);
        ThreadInfo[] notNulls = new ThreadInfo[infos.length];
        int nNotNulls = 0;
        ThreadInfo[] threadInfoArray = infos;
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            ThreadInfo info = threadInfoArray[n2];
            if (info != null) {
                notNulls[nNotNulls++] = info;
            }
            ++n2;
        }
        if (nNotNulls == infos.length) {
            return infos;
        }
        return Arrays.copyOf(notNulls, nNotNulls);
    }

    public static ThreadInfo getThreadInfo(String name) {
        Thread[] threads;
        if (name == null) {
            throw new NullPointerException("Null name");
        }
        Thread[] threadArray = threads = ThreadUtilities.getAllThreads();
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            Thread thread = threadArray[n2];
            if (thread.getName().equals(name)) {
                return ThreadUtilities.getThreadInfo(thread.getId());
            }
            ++n2;
        }
        return null;
    }

    public static ThreadInfo getThreadInfo(long id) {
        ThreadMXBean thbean = ManagementFactory.getThreadMXBean();
        if (!thbean.isObjectMonitorUsageSupported() || !thbean.isSynchronizerUsageSupported()) {
            return thbean.getThreadInfo(id);
        }
        ThreadInfo[] infos = thbean.getThreadInfo(new long[]{id}, true, true);
        if (infos.length == 0) {
            return null;
        }
        return infos[0];
    }

    public static ThreadInfo getThreadInfo(Thread thread) {
        if (thread == null) {
            throw new NullPointerException("Null thread");
        }
        return ThreadUtilities.getThreadInfo(thread.getId());
    }

    public static Thread getLockingThread(Object object) {
        if (object == null) {
            throw new NullPointerException("Null object");
        }
        long identity = System.identityHashCode(object);
        Thread[] allThreads = ThreadUtilities.getAllThreads();
        ThreadInfo info = null;
        MonitorInfo[] monitors = null;
        Thread[] threadArray = allThreads;
        int n = allThreads.length;
        int n2 = 0;
        while (n2 < n) {
            Thread thread = threadArray[n2];
            info = ThreadUtilities.getThreadInfo(thread.getId());
            if (info != null) {
                MonitorInfo[] monitorInfoArray = monitors = info.getLockedMonitors();
                int n3 = monitors.length;
                int n4 = 0;
                while (n4 < n3) {
                    MonitorInfo monitor = monitorInfoArray[n4];
                    if (identity == (long)monitor.getIdentityHashCode()) {
                        return thread;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    public static Thread getBlockingThread(Thread blockedThread) {
        ThreadInfo info = ThreadUtilities.getThreadInfo(blockedThread);
        if (info == null) {
            return null;
        }
        long id = info.getLockOwnerId();
        if (id == -1L) {
            return null;
        }
        return ThreadUtilities.getThread(id);
    }
}

