/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.util;

import com.dvsum.logger.CustomLogger;
import com.dvsum.logger.LogFormat;
import com.dvsum.model.HttpResponseData;
import com.dvsum.services.SawsUpgradeService;
import com.dvsum.util.AWSSimpleEmailServiceUtil;
import com.dvsum.util.FileUtil;
import com.dvsum.util.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.simple.JSONObject;

public class TLSHttpsRequestor {
    private static final CustomLogger logger = CustomLogger.getLogger(TLSHttpsRequestor.class);

    public static String downloadWithPresignedUrl(String preSignedUrl) {
        return TLSHttpsRequestor.downloadWithPresignedUrl(preSignedUrl, false);
    }

    public static String downloadWithPresignedUrl(String preSignedUrl, boolean preserveFormatting) {
        String fileContent;
        block14: {
            fileContent = null;
            try {
                if (!TLSHttpsRequestor.isSSLValidationEnabled()) {
                    TLSHttpsRequestor.disableSSLValidation();
                }
                URL url = new URL(preSignedUrl);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                int responseCode = connection.getResponseCode();
                if (responseCode == 200) {
                    Throwable throwable = null;
                    Object var7_9 = null;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                        String line;
                        StringBuilder response = new StringBuilder();
                        while ((line = reader.readLine()) != null) {
                            response.append(line);
                            if (!preserveFormatting) continue;
                            response.append("\n");
                        }
                        fileContent = response.toString();
                        break block14;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                System.err.println("Failed to download file. Response code: " + responseCode);
            }
            catch (Exception e) {
                logger.error("Error while downloading file with Presigned Url. Error :", e.getMessage());
                e.printStackTrace();
            }
        }
        return fileContent;
    }

    public static String downloadFile(String url, Object[] parameterValues, Object[] parametersName) {
        logger.info("Get request to........." + url);
        if (!TLSHttpsRequestor.isSSLValidationEnabled()) {
            TLSHttpsRequestor.disableSSLValidation();
        }
        HttpGet httpGet = new HttpGet(url);
        Integer requestTimeout = Integer.valueOf(FileUtil.getPropertyWithDefault("request.timeout.get", "1800000"));
        if (requestTimeout != null) {
            httpGet.setConfig(TLSHttpsRequestor.getRequestConfig(requestTimeout));
        }
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        CloseableHttpClient client = null;
        try {
            int i = 1;
            while (i <= parameterValues.length) {
                parameters.add(new BasicNameValuePair(parametersName[i - 1].toString(), parameterValues[i - 1].toString()));
                ++i;
            }
            URI uri = new URIBuilder(httpGet.getURI()).addParameters(parameters).build();
            httpGet.setURI(uri);
            client = TLSHttpsRequestor.getHttpClient();
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpGet);
            int status = response.getStatusLine().getStatusCode();
            HttpEntity entity = null;
            long totalSize = 0L;
            double previousProgress = 0.0;
            if (status >= 200 && status <= 300) {
                entity = response.getEntity();
                InputStream is = entity.getContent();
                totalSize = entity.getContentLength();
                File outputFile = new File(SawsUpgradeService.TEMP_SAWS_FILE);
                FileOutputStream fos = new FileOutputStream(outputFile);
                previousProgress = 1.0;
                int read = 0;
                byte[] buffer = new byte[32768];
                while ((read = is.read(buffer)) > 0) {
                    fos.write(buffer, 0, read);
                }
                fos.close();
                is.close();
                return "SUCCESS";
            }
        }
        catch (Exception e) {
            logger.error("Exception:", e);
            e.printStackTrace();
        }
        finally {
            if (client != null) {
                try {
                    client.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private static Double getPercentage(Long total, Long value) {
        Double result = value.doubleValue() / total.doubleValue() * 100.0;
        return result;
    }

    private static void printAbsolutePercentage(Double value) {
        String valStr = String.valueOf(value);
        String valDecimal = valStr.substring(valStr.indexOf(".") + 1, valStr.length());
        Double valDouble = Double.parseDouble(valDecimal);
        if (valDouble == 0.0) {
            System.out.println(String.valueOf(value.intValue()) + "%");
        }
    }

    public static String executeGet(String url, Object[] parameterValues, Object[] parametersName, Object[] headerNames, Object[] headerValues) {
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        String responseString = null;
        CloseableHttpClient client = null;
        try {
            client = TLSHttpsRequestor.getHttpClient();
            HttpGet httpget = new HttpGet(url);
            Integer requestTimeout = Integer.valueOf(FileUtil.getPropertyWithDefault("request.timeout.get", "1800000"));
            if (requestTimeout != null) {
                httpget.setConfig(TLSHttpsRequestor.getRequestConfig(requestTimeout));
            }
            logger.info("polling ........." + httpget.getURI());
            int i = 1;
            while (i <= parameterValues.length) {
                parameters.add(new BasicNameValuePair(parametersName[i - 1].toString(), parameterValues[i - 1].toString()));
                ++i;
            }
            URI uri = new URIBuilder(httpget.getURI()).addParameters(parameters).build();
            httpget.setURI(uri);
            if (headerValues != null) {
                int i2 = 0;
                while (i2 < headerValues.length) {
                    httpget.setHeader(String.valueOf(headerNames[i2]), String.valueOf(headerValues[i2]));
                    ++i2;
                }
            }
            CloseableHttpResponse resp = client.execute((HttpUriRequest)httpget);
            HttpEntity entity = resp.getEntity();
            responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            StatusLine status = resp.getStatusLine();
            logger.info(" Status code ---- " + status.getStatusCode());
            logger.info("Request Complete .........");
            if (status.getStatusCode() == 500) {
                return "error";
            }
        }
        catch (Exception exp) {
            TLSHttpsRequestor.sendErrorEmail(exp.getMessage(), url);
            exp.printStackTrace();
            logger.error("Exception: ", exp);
        }
        finally {
            if (client != null) {
                try {
                    client.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return responseString;
    }

    public static int executeGet(String url, String API_KEY) {
        int statusCode;
        block14: {
            System.out.println(" API_KEY" + API_KEY);
            ArrayList parameters = new ArrayList();
            String responseString = null;
            CloseableHttpClient client = null;
            statusCode = 200;
            try {
                try {
                    client = TLSHttpsRequestor.getHttpClient();
                    HttpGet httpget = new HttpGet(url);
                    Integer requestTimeout = Integer.valueOf(FileUtil.getPropertyWithDefault("request.timeout.get", "1800000"));
                    if (requestTimeout != null) {
                        httpget.setConfig(TLSHttpsRequestor.getRequestConfig(requestTimeout));
                    }
                    logger.info("polling ........." + httpget.getURI());
                    URI uri = new URIBuilder(httpget.getURI()).addParameters(parameters).build();
                    httpget.setURI(uri);
                    if (Util.isNotNullOrEmpty(API_KEY)) {
                        httpget.setHeader("x-api-key", API_KEY);
                    }
                    CloseableHttpResponse resp = client.execute((HttpUriRequest)httpget);
                    HttpEntity entity = resp.getEntity();
                    responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                    StatusLine status = resp.getStatusLine();
                    logger.info(" Status code ---- " + status.getStatusCode());
                    logger.info("Request Complete .........");
                    statusCode = status.getStatusCode();
                }
                catch (Exception exp) {
                    statusCode = 500;
                    TLSHttpsRequestor.sendErrorEmail(exp.getMessage(), url);
                    exp.printStackTrace();
                    logger.error("Exception: ", exp);
                    if (client == null) break block14;
                    try {
                        client.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return statusCode;
    }

    public static String executeGet(String url, Object[] parameterValues, Object[] parametersName) {
        return TLSHttpsRequestor.executeGet(url, parameterValues, parametersName, null);
    }

    public static String executeGet(String url, Object[] parameterValues, Object[] parametersName, String API_KEY) {
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        String responseString = null;
        CloseableHttpClient client = null;
        try {
            client = TLSHttpsRequestor.getHttpClient();
            HttpGet httpget = new HttpGet(url);
            Integer requestTimeout = Integer.valueOf(FileUtil.getPropertyWithDefault("request.timeout.get", "1800000"));
            if (requestTimeout != null) {
                httpget.setConfig(TLSHttpsRequestor.getRequestConfig(requestTimeout));
            }
            logger.info("polling ........." + httpget.getURI());
            System.out.println("polling ........." + httpget.getURI());
            int i = 1;
            while (i <= parameterValues.length) {
                parameters.add(new BasicNameValuePair(parametersName[i - 1].toString(), parameterValues[i - 1].toString()));
                ++i;
            }
            URI uri = new URIBuilder(httpget.getURI()).addParameters(parameters).build();
            httpget.setURI(uri);
            if (Util.isNotNullOrEmpty(API_KEY)) {
                httpget.setHeader("x-api-key", API_KEY);
            }
            CloseableHttpResponse resp = client.execute((HttpUriRequest)httpget);
            HttpEntity entity = resp.getEntity();
            responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            StatusLine status = resp.getStatusLine();
            logger.info(" Status code ---- " + status.getStatusCode());
            System.out.println(" Status code ---- " + status.getStatusCode());
            logger.info("Request Complete .........");
            if (status.getStatusCode() == 500) {
                return "error";
            }
        }
        catch (Exception exp) {
            TLSHttpsRequestor.sendErrorEmail(exp.getMessage(), url);
            exp.printStackTrace();
            logger.error("Exception: ", exp);
        }
        finally {
            if (client != null) {
                try {
                    client.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return responseString;
    }

    public static RequestConfig getRequestConfig(int requestTimeout) {
        return RequestConfig.custom().setConnectTimeout(requestTimeout).setConnectionRequestTimeout(requestTimeout).setSocketTimeout(requestTimeout).build();
    }

    public static void sendErrorEmail(String exp, String url) {
        try {
            AWSSimpleEmailServiceUtil.sendCommunicationFailureEmail(exp, url);
        }
        catch (Exception e) {
            logger.error("Exception:", e);
            e.printStackTrace();
        }
    }

    public static String executePost(String url, List<String> parameterValues, List<String> parametersName) {
        String responseString;
        block15: {
            ArrayList<BasicNameValuePair> postParameters = new ArrayList<BasicNameValuePair>();
            responseString = null;
            logger.info("Post request to........." + url);
            CloseableHttpClient client = null;
            try {
                try {
                    client = TLSHttpsRequestor.getHttpClient();
                    HttpPost httpPost = new HttpPost(url);
                    Integer requestTimeout = Integer.valueOf(FileUtil.getPropertyWithDefault("request.timeout.post", "1800000"));
                    if (requestTimeout != null) {
                        httpPost.setConfig(TLSHttpsRequestor.getRequestConfig(requestTimeout));
                    }
                    int i = 1;
                    while (i <= parameterValues.size()) {
                        postParameters.add(new BasicNameValuePair(parametersName.get(i - 1), parameterValues.get(i - 1)));
                        ++i;
                    }
                    httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(postParameters, "UTF-8"));
                    httpPost.setHeader("Content-type", "application/json");
                    CloseableHttpResponse resp = client.execute((HttpUriRequest)httpPost);
                    HttpEntity entity = resp.getEntity();
                    StatusLine status = resp.getStatusLine();
                    logger.info(" Status code ---- " + status.getStatusCode());
                    if (status.getStatusCode() >= 200 && status.getStatusCode() < 300) {
                        responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                    }
                }
                catch (Exception exp) {
                    exp.printStackTrace();
                    logger.error("Exception: ", exp);
                    if (client == null) break block15;
                    try {
                        client.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return responseString;
    }

    public static String executePost(String url, List<String> headersName, List<String> headerValues, List<String> parametersName, List<String> parameterValues) {
        String responseString;
        block18: {
            ArrayList<BasicNameValuePair> postParameters = new ArrayList<BasicNameValuePair>();
            responseString = null;
            logger.info("Post request to........." + url);
            CloseableHttpClient client = null;
            try {
                try {
                    int i;
                    client = TLSHttpsRequestor.getHttpClient();
                    HttpPost httpPost = new HttpPost(url);
                    Integer requestTimeout = Integer.valueOf(FileUtil.getPropertyWithDefault("request.timeout.post", "1800000"));
                    if (requestTimeout != null) {
                        httpPost.setConfig(TLSHttpsRequestor.getRequestConfig(requestTimeout));
                    }
                    if (headerValues != null) {
                        i = 0;
                        while (i < headerValues.size()) {
                            httpPost.setHeader(headersName.get(i), headerValues.get(i));
                            ++i;
                        }
                    }
                    if (parameterValues != null) {
                        i = 0;
                        while (i < parameterValues.size()) {
                            postParameters.add(new BasicNameValuePair(parametersName.get(i), parameterValues.get(i)));
                            ++i;
                        }
                    }
                    httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(postParameters, "UTF-8"));
                    CloseableHttpResponse resp = client.execute((HttpUriRequest)httpPost);
                    HttpEntity entity = resp.getEntity();
                    StatusLine status = resp.getStatusLine();
                    logger.info(" Status code ---- " + status.getStatusCode());
                    if (status.getStatusCode() >= 200 && status.getStatusCode() < 300) {
                        responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                    }
                }
                catch (Exception exp) {
                    exp.printStackTrace();
                    logger.error("Exception: ", exp);
                    if (client == null) break block18;
                    try {
                        client.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return responseString;
    }

    public static String executePost(String url, List<String> parameterValues, List<String> parametersName, String API_KEY) {
        String responseString;
        block15: {
            ArrayList<BasicNameValuePair> postParameters = new ArrayList<BasicNameValuePair>();
            responseString = null;
            logger.info("Post request to........." + url);
            CloseableHttpClient client = null;
            try {
                try {
                    client = TLSHttpsRequestor.getHttpClient();
                    HttpPost httpPost = new HttpPost(url);
                    Integer requestTimeout = Integer.valueOf(FileUtil.getPropertyWithDefault("request.timeout.post", "1800000"));
                    if (requestTimeout != null) {
                        httpPost.setConfig(TLSHttpsRequestor.getRequestConfig(requestTimeout));
                    }
                    int i = 1;
                    while (i <= parameterValues.size()) {
                        postParameters.add(new BasicNameValuePair(parametersName.get(i - 1), parameterValues.get(i - 1)));
                        ++i;
                    }
                    httpPost.setHeader("x-api-key", API_KEY);
                    httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(postParameters, "UTF-8"));
                    httpPost.setHeader("Content-type", "application/json");
                    CloseableHttpResponse resp = client.execute((HttpUriRequest)httpPost);
                    HttpEntity entity = resp.getEntity();
                    StatusLine status = resp.getStatusLine();
                    System.out.println(" Status code ---- " + status.getStatusCode());
                    logger.info(" Status code ---- " + status.getStatusCode());
                    if (status.getStatusCode() >= 200 && status.getStatusCode() < 300) {
                        responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                    }
                }
                catch (Exception exp) {
                    exp.printStackTrace();
                    logger.error("Exception: ", exp);
                    if (client == null) break block15;
                    try {
                        client.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return responseString;
    }

    public static int executePostAndGetStatusCode(String url, List<String> parameterValues, List<String> parametersName, String API_KEY) {
        ArrayList<BasicNameValuePair> postParameters = new ArrayList<BasicNameValuePair>();
        Object responseString = null;
        int statusCode = 400;
        logger.info("Post request to........." + url);
        CloseableHttpClient client = null;
        try {
            try {
                client = TLSHttpsRequestor.getHttpClient();
                HttpPost httpPost = new HttpPost(url);
                Integer requestTimeout = Integer.valueOf(FileUtil.getPropertyWithDefault("request.timeout.post", "1800000"));
                if (requestTimeout != null) {
                    httpPost.setConfig(TLSHttpsRequestor.getRequestConfig(requestTimeout));
                }
                int i = 1;
                while (i <= parameterValues.size()) {
                    postParameters.add(new BasicNameValuePair(parametersName.get(i - 1), parameterValues.get(i - 1)));
                    ++i;
                }
                httpPost.setHeader("x-api-key", API_KEY);
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(postParameters, "UTF-8"));
                httpPost.setHeader("Content-type", "application/json");
                CloseableHttpResponse resp = client.execute((HttpUriRequest)httpPost);
                HttpEntity entity = resp.getEntity();
                StatusLine status = resp.getStatusLine();
                System.out.println(" Status code ---- " + status.getStatusCode());
                logger.info(" Status code ---- " + status.getStatusCode());
                statusCode = status.getStatusCode();
            }
            catch (Exception exp) {
                exp.printStackTrace();
                logger.error("Exception: ", exp);
            }
        }
        catch (Throwable throwable) {}
        if (client != null) {
            try {
                client.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return statusCode;
    }

    public static String executePost(String url, String jsonString, String API_KEY, String accessKey, String secretKey, LogFormat logFormat) {
        String responseString;
        block14: {
            ArrayList postParameters = new ArrayList();
            responseString = null;
            logger.info(logFormat.getFormattedLog(), "Post request to........." + url);
            CloseableHttpClient client = null;
            try {
                try {
                    client = TLSHttpsRequestor.getHttpClient();
                    HttpPost httpPost = new HttpPost(url);
                    Integer requestTimeout = Integer.valueOf(FileUtil.getPropertyWithDefault("request.timeout.post", "1800000"));
                    if (requestTimeout != null) {
                        httpPost.setConfig(TLSHttpsRequestor.getRequestConfig(requestTimeout));
                    }
                    StringEntity params = new StringEntity(jsonString);
                    httpPost.setHeader("x-api-key", API_KEY);
                    httpPost.setHeader("access-key", accessKey);
                    httpPost.setHeader("secret-key", secretKey);
                    httpPost.setEntity((HttpEntity)params);
                    httpPost.setHeader("Content-type", "application/json");
                    CloseableHttpResponse resp = client.execute((HttpUriRequest)httpPost);
                    HttpEntity entity = resp.getEntity();
                    StatusLine status = resp.getStatusLine();
                    System.out.println(" Status code ---- " + status.getStatusCode());
                    logger.info(logFormat.getFormattedLog(), " Status code ---- " + status.getStatusCode());
                    if (status.getStatusCode() >= 200 && status.getStatusCode() < 300) {
                        responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                    }
                }
                catch (Exception exp) {
                    exp.printStackTrace();
                    logger.error(logFormat.getFormattedLog(), "Exception: ", exp);
                    if (client == null) break block14;
                    try {
                        client.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return responseString;
    }

    public static String executePost(String url, String jsonString, String API_KEY, LogFormat logFormat) {
        String responseString;
        block14: {
            ArrayList postParameters = new ArrayList();
            responseString = null;
            logger.info(logFormat == null ? "" : logFormat.getFormattedLog(), "Post request to........." + url);
            CloseableHttpClient client = null;
            try {
                try {
                    client = TLSHttpsRequestor.getHttpClient();
                    HttpPost httpPost = new HttpPost(url);
                    Integer requestTimeout = Integer.valueOf(FileUtil.getPropertyWithDefault("request.timeout.post", "1800000"));
                    if (requestTimeout != null) {
                        httpPost.setConfig(TLSHttpsRequestor.getRequestConfig(requestTimeout));
                    }
                    StringEntity params = new StringEntity(jsonString);
                    httpPost.setHeader("x-api-key", API_KEY);
                    httpPost.setHeader("Authorization", "default");
                    httpPost.setEntity((HttpEntity)params);
                    httpPost.setHeader("Content-type", "application/json");
                    CloseableHttpResponse resp = client.execute((HttpUriRequest)httpPost);
                    HttpEntity entity = resp.getEntity();
                    StatusLine status = resp.getStatusLine();
                    logger.info(logFormat == null ? "" : logFormat.getFormattedLog(), " Status code ---- " + status.getStatusCode());
                    if (status.getStatusCode() >= 200 && status.getStatusCode() < 300) {
                        responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                    }
                }
                catch (Exception exp) {
                    exp.printStackTrace();
                    logger.error(logFormat == null ? "" : logFormat.getFormattedLog(), "Exception: ", exp);
                    if (client == null) break block14;
                    try {
                        client.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return responseString;
    }

    public static String postJsonData(String url, String jsonString, String API_KEY) {
        String responseString;
        block14: {
            ArrayList postParameters = new ArrayList();
            responseString = null;
            logger.info("Post request to........." + url);
            CloseableHttpClient client = null;
            try {
                try {
                    client = TLSHttpsRequestor.getHttpClient();
                    HttpPost httpPost = new HttpPost(url);
                    Integer requestTimeout = Integer.valueOf(FileUtil.getPropertyWithDefault("request.timeout.post", "1800000"));
                    if (requestTimeout != null) {
                        httpPost.setConfig(TLSHttpsRequestor.getRequestConfig(requestTimeout));
                    }
                    StringEntity params = new StringEntity(jsonString);
                    httpPost.setHeader("x-api-key", API_KEY);
                    httpPost.setEntity((HttpEntity)params);
                    httpPost.setHeader("Content-type", "application/json");
                    CloseableHttpResponse resp = client.execute((HttpUriRequest)httpPost);
                    HttpEntity entity = resp.getEntity();
                    StatusLine status = resp.getStatusLine();
                    logger.info(" Status code ---- " + status.getStatusCode());
                    if (status.getStatusCode() >= 200 && status.getStatusCode() < 300) {
                        responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                        logger.debug(responseString);
                    }
                }
                catch (Exception exp) {
                    exp.printStackTrace();
                    logger.error("Exception: ", exp);
                    if (client == null) break block14;
                    try {
                        client.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return responseString;
    }

    public static String postJsonData(String url, String jsonString, String API_KEY, String accessKey, String secretKey) {
        String responseString;
        block14: {
            ArrayList postParameters = new ArrayList();
            responseString = null;
            logger.info("Post request to........." + url);
            CloseableHttpClient client = null;
            try {
                try {
                    client = TLSHttpsRequestor.getHttpClient();
                    HttpPost httpPost = new HttpPost(url);
                    Integer requestTimeout = Integer.valueOf(FileUtil.getPropertyWithDefault("request.timeout.post", "1800000"));
                    if (requestTimeout != null) {
                        httpPost.setConfig(TLSHttpsRequestor.getRequestConfig(requestTimeout));
                    }
                    StringEntity params = new StringEntity(jsonString);
                    httpPost.setHeader("x-api-key", API_KEY);
                    httpPost.setEntity((HttpEntity)params);
                    httpPost.setHeader("Content-type", "application/json");
                    CloseableHttpResponse resp = client.execute((HttpUriRequest)httpPost);
                    HttpEntity entity = resp.getEntity();
                    StatusLine status = resp.getStatusLine();
                    logger.info(" Status code ---- " + status.getStatusCode());
                    if (status.getStatusCode() >= 200 && status.getStatusCode() < 300) {
                        responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                        logger.debug(responseString);
                    }
                }
                catch (Exception exp) {
                    exp.printStackTrace();
                    logger.error("Exception: ", exp);
                    if (client == null) break block14;
                    try {
                        client.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return responseString;
    }

    public static String executePostScanSource(String url, String jobId, String API_KEY) {
        String responseString;
        block14: {
            ArrayList postParameters = new ArrayList();
            responseString = null;
            logger.info("Post request to........." + url);
            System.out.println("JobId: " + jobId + "\n  URL: " + url + " \n key " + API_KEY);
            CloseableHttpClient client = null;
            try {
                try {
                    client = TLSHttpsRequestor.getHttpClient();
                    HttpPost httpPost = new HttpPost(url);
                    Integer requestTimeout = Integer.valueOf(FileUtil.getPropertyWithDefault("request.timeout.post", "1800000"));
                    if (requestTimeout != null) {
                        httpPost.setConfig(TLSHttpsRequestor.getRequestConfig(requestTimeout));
                    }
                    JSONObject postPayLoad = new JSONObject();
                    postPayLoad.put((Object)"job_id", (Object)jobId);
                    StringEntity params = new StringEntity(postPayLoad.toString());
                    httpPost.setHeader("x-api-key", API_KEY);
                    httpPost.setEntity((HttpEntity)params);
                    httpPost.setHeader("Content-type", "application/json");
                    CloseableHttpResponse resp = client.execute((HttpUriRequest)httpPost);
                    HttpEntity entity = resp.getEntity();
                    StatusLine status = resp.getStatusLine();
                    logger.info(" Status code ---- " + status.getStatusCode());
                    if (status.getStatusCode() >= 200 && status.getStatusCode() < 300) {
                        responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                    }
                }
                catch (Exception exp) {
                    exp.printStackTrace();
                    logger.error("Exception: ", exp);
                    System.out.println("exception:" + exp.getMessage());
                    if (client == null) break block14;
                    try {
                        client.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return responseString;
    }

    public static String executePost(String url, String payload, Object[] headerName, Object[] headerValues) {
        String responseString;
        block16: {
            responseString = null;
            System.out.println("Post request to........." + url);
            CloseableHttpClient client = null;
            try {
                try {
                    client = TLSHttpsRequestor.getHttpClient();
                    HttpPost httpPost = new HttpPost(url);
                    Integer requestTimeout = Integer.valueOf(FileUtil.getPropertyWithDefault("request.timeout.post", "1800000"));
                    if (requestTimeout != null) {
                        httpPost.setConfig(TLSHttpsRequestor.getRequestConfig(requestTimeout));
                    }
                    if (headerValues != null) {
                        int i = 0;
                        while (i < headerValues.length) {
                            httpPost.setHeader(String.valueOf(headerName[i]), String.valueOf(headerValues[i]));
                            ++i;
                        }
                    }
                    httpPost.setEntity((HttpEntity)new StringEntity(payload, ContentType.APPLICATION_JSON));
                    CloseableHttpResponse resp = client.execute((HttpUriRequest)httpPost);
                    HttpEntity entity = resp.getEntity();
                    StatusLine status = resp.getStatusLine();
                    logger.info(" Status code ---- " + status.getStatusCode());
                    if (status.getStatusCode() >= 200 && status.getStatusCode() < 300) {
                        responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                    }
                }
                catch (Exception exp) {
                    exp.printStackTrace();
                    logger.error("Exception: ", exp);
                    if (client == null) break block16;
                    try {
                        client.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return responseString;
    }

    public static boolean isSSLValidationEnabled() {
        String enableSSLValidation = FileUtil.getPropertyWithDefault("enable.ssl.validation", "true");
        boolean enableSSLValidationBool = Boolean.parseBoolean(enableSSLValidation);
        logger.info("enable.ssl.validation = ", enableSSLValidation);
        return enableSSLValidationBool;
    }

    public static HttpResponseData executeGetWorkflow(String url, Object[] parameterValues, Object[] parametersName, Object[] headerNames, Object[] headerValues) {
        HttpResponseData response;
        block16: {
            ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
            response = null;
            CloseableHttpClient client = null;
            try {
                try {
                    client = TLSHttpsRequestor.getHttpClient();
                    HttpGet httpget = new HttpGet(url);
                    Integer requestTimeout = Integer.valueOf(FileUtil.getPropertyWithDefault("request.timeout.get", "1800000"));
                    if (requestTimeout != null) {
                        httpget.setConfig(TLSHttpsRequestor.getRequestConfig(requestTimeout));
                    }
                    logger.info("polling ........." + httpget.getURI());
                    int i = 1;
                    while (i <= parameterValues.length) {
                        parameters.add(new BasicNameValuePair(parametersName[i - 1].toString(), parameterValues[i - 1].toString()));
                        ++i;
                    }
                    URI uri = new URIBuilder(httpget.getURI()).addParameters(parameters).build();
                    httpget.setURI(uri);
                    if (headerValues != null) {
                        int i2 = 0;
                        while (i2 < headerValues.length) {
                            httpget.setHeader(String.valueOf(headerNames[i2]), String.valueOf(headerValues[i2]));
                            ++i2;
                        }
                    }
                    CloseableHttpResponse resp = client.execute((HttpUriRequest)httpget);
                    HttpEntity entity = resp.getEntity();
                    String responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                    int statusCode = resp.getStatusLine().getStatusCode();
                    logger.info(" Status code ---- " + statusCode);
                    logger.info("Request Complete .........");
                    response = new HttpResponseData(statusCode, responseString);
                }
                catch (Exception exp) {
                    TLSHttpsRequestor.sendErrorEmail(exp.getMessage(), url);
                    exp.printStackTrace();
                    logger.error("Exception: ", exp);
                    response = new HttpResponseData(500, exp.getMessage());
                    if (client == null) break block16;
                    try {
                        client.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return response;
    }

    public static HttpResponseData executePostWorkflow(String url, String payload, Object[] headerName, Object[] headerValues) {
        HttpResponseData response;
        block15: {
            response = null;
            CloseableHttpClient client = null;
            try {
                try {
                    client = TLSHttpsRequestor.getHttpClient();
                    HttpPost httpPost = new HttpPost(url);
                    Integer requestTimeout = Integer.valueOf(FileUtil.getPropertyWithDefault("request.timeout.post", "1800000"));
                    if (requestTimeout != null) {
                        httpPost.setConfig(TLSHttpsRequestor.getRequestConfig(requestTimeout));
                    }
                    if (headerValues != null) {
                        int i = 0;
                        while (i < headerValues.length) {
                            httpPost.setHeader(String.valueOf(headerName[i]), String.valueOf(headerValues[i]));
                            ++i;
                        }
                    }
                    httpPost.setEntity((HttpEntity)new StringEntity(payload, ContentType.APPLICATION_JSON));
                    CloseableHttpResponse resp = client.execute((HttpUriRequest)httpPost);
                    HttpEntity entity = resp.getEntity();
                    int statusCode = resp.getStatusLine().getStatusCode();
                    logger.info(" Status code ---- " + statusCode);
                    String responseString = null;
                    responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                    response = new HttpResponseData(statusCode, responseString);
                }
                catch (Exception exp) {
                    logger.error("Exception: ", exp);
                    response = new HttpResponseData(500, exp.getMessage());
                    exp.printStackTrace();
                    if (client == null) break block15;
                    try {
                        client.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return response;
    }

    public static CloseableHttpClient getHttpClient() throws NoSuchAlgorithmException, KeyManagementException {
        if (!TLSHttpsRequestor.isSSLValidationEnabled()) {
            return TLSHttpsRequestor.getHttpClientForAllCerts();
        }
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        sslContext.init(null, null, new SecureRandom());
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1.2"}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
        Registry registry = RegistryBuilder.create().register("https", (Object)sslConnectionSocketFactory).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry);
        connectionManager.setMaxTotal(200);
        connectionManager.setDefaultMaxPerRoute(200);
        connectionManager.setValidateAfterInactivity(10000);
        Integer requestTimeout = Integer.valueOf(FileUtil.getPropertyWithDefault("request.timeout.post", "1800000").trim());
        if (requestTimeout != null) {
            connectionManager.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(requestTimeout.intValue()).build());
        }
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).build();
        return httpClient;
    }

    public static CloseableHttpClient getHttpClientForAllCerts() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        sslContext.init(null, new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }}, new SecureRandom());
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1.2"}, null, (hostname, session) -> true);
        Registry registry = RegistryBuilder.create().register("https", (Object)sslConnectionSocketFactory).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry);
        connectionManager.setMaxTotal(200);
        connectionManager.setDefaultMaxPerRoute(200);
        connectionManager.setValidateAfterInactivity(10000);
        Integer requestTimeout = Integer.valueOf(FileUtil.getPropertyWithDefault("request.timeout.post", "1800000").trim());
        if (requestTimeout != null) {
            connectionManager.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(requestTimeout.intValue()).build());
        }
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).build();
        return httpClient;
    }

    private static void disableSSLValidation() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier((hostname, session) -> true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

