/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.util;

import com.dvsum.logger.CustomLogger;
import com.dvsum.util.GzipUtil;
import com.dvsum.util.Util;
import com.google.gson.Gson;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class JsonUtil {
    private static final CustomLogger logger = CustomLogger.getLogger(JsonUtil.class);
    private Long resultSetCounter = 0L;
    private List<String> orderedKeysList = new ArrayList<String>();
    JSONArray orderedKeysListWithTypes = new JSONArray();
    private Long maxResultToJsonLimit = 200000L;
    private Boolean keyToLowercase = true;

    public final JSONObject ResultSet2JSONObject(ResultSet rs, boolean isAnalyticsQuery) throws JSONException {
        long startTime = System.currentTimeMillis();
        JSONObject jsonObject = new JSONObject();
        JSONArray jsonObjectArray = new JSONArray();
        JSONObject map = new JSONObject();
        JSONArray errors = new JSONArray();
        this.resultSetCounter = 0L;
        int recordLimit = 200000;
        ResultSetMetaData rsmd = null;
        Object columnName = null;
        Object columnValue = null;
        try {
            try {
                rsmd = rs.getMetaData();
                if (isAnalyticsQuery) {
                    this.preserveKeysOrderWithTypes(rsmd);
                } else {
                    this.preserveKeysOrder(rsmd);
                }
                this.convertLimitedResultSetToJson(rsmd, rs, jsonObjectArray, map, isAnalyticsQuery);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.setErrorMessage(e.getMessage(), errors);
                this.convertnextRowsToJsonObject(rsmd, rs, jsonObjectArray, map, isAnalyticsQuery);
            }
            jsonObject.put((Object)"results", (Object)jsonObjectArray);
            jsonObject.put((Object)"resultCount", (Object)this.resultSetCounter);
            jsonObject.put((Object)"errors", (Object)errors);
            jsonObject.put((Object)"keysOrder", isAnalyticsQuery ? this.orderedKeysListWithTypes : this.orderedKeysList);
        }
        catch (Exception e) {
            jsonObject.put((Object)"result", (Object)"failure");
            jsonObject.put((Object)"error", (Object)e.getMessage());
            logger.error(e.getMessage());
        }
        long endTime = System.currentTimeMillis();
        return jsonObject;
    }

    public List<String> preserveKeysOrder(ResultSetMetaData rsmd) throws Exception {
        int i = 0;
        while (i < rsmd.getColumnCount()) {
            this.orderedKeysList.add(rsmd.getColumnLabel(i + 1));
            ++i;
        }
        return this.orderedKeysList;
    }

    public JSONArray preserveKeysOrderWithTypes(ResultSetMetaData rsmd) throws Exception {
        int i = 1;
        while (i <= rsmd.getColumnCount()) {
            JSONObject colObject = new JSONObject();
            colObject.put((Object)"colId", (Object)i);
            colObject.put((Object)"colName", (Object)rsmd.getColumnLabel(i));
            colObject.put((Object)"colType", (Object)rsmd.getColumnTypeName(i));
            this.orderedKeysListWithTypes.add((Object)colObject);
            ++i;
        }
        return this.orderedKeysListWithTypes;
    }

    public void setErrorMessage(String errorString, JSONArray errors) {
        try {
            JSONObject error = new JSONObject();
            int firstIndexOfat = errorString.indexOf(":");
            int secondIndexOfat = errorString.indexOf(":", firstIndexOfat + 1);
            error.put((Object)"error", (Object)errorString);
            errors.add((Object)errorString);
        }
        catch (Exception e) {
            logger.error("Exception: ", e);
            e.printStackTrace();
        }
    }

    public void convertResultSetToJason(ResultSetMetaData rsmd, ResultSet resultRow, JSONArray jsonObjectArray, boolean isAnalyticsQuery) throws Exception {
        do {
            rsmd = resultRow.getMetaData();
            jsonObjectArray.add((Object)this.convertRowToJsonObject(rsmd, resultRow, isAnalyticsQuery));
            this.resultSetCounter = this.resultSetCounter + 1L;
        } while (resultRow.next());
    }

    public static String convertToPythonFriendlyJson(String jsonString) {
        return jsonString.replaceAll("null", "None").replaceAll("true", "True").replaceAll("false", "False");
    }

    public void convertLimitedResultSetToJson(ResultSetMetaData rsmd, ResultSet resultRow, JSONArray jsonObjectArray, JSONObject map, boolean isAnalyticsQuery) throws Exception {
        do {
            if (this.resultSetCounter < this.maxResultToJsonLimit) {
                rsmd = resultRow.getMetaData();
                jsonObjectArray.add((Object)this.convertRowToJsonObject(rsmd, resultRow, isAnalyticsQuery));
            }
            this.resultSetCounter = this.resultSetCounter + 1L;
        } while (resultRow.next());
    }

    public void convertLimitedResultSetToJson(ResultSetMetaData rsmd, ResultSet resultRow, JSONArray jsonObjectArray, int maxResultToJsonLimit, boolean isAnalyticsQuery) throws Exception {
        do {
            if (this.resultSetCounter < (long)maxResultToJsonLimit) {
                rsmd = resultRow.getMetaData();
                jsonObjectArray.add((Object)this.convertRowToJsonObject(rsmd, resultRow, isAnalyticsQuery));
            }
            this.resultSetCounter = this.resultSetCounter + 1L;
        } while (resultRow.next());
    }

    public void convertnextRowsToJsonObject(ResultSetMetaData rsmd, ResultSet resultRow, JSONArray jsonObjectArray, JSONObject map, boolean isAnalyticsQuery) throws Exception {
        try {
            while (resultRow.next()) {
                if (this.resultSetCounter < this.maxResultToJsonLimit) {
                    rsmd = resultRow.getMetaData();
                    jsonObjectArray.add((Object)this.convertRowToJsonObject(rsmd, resultRow, isAnalyticsQuery));
                }
                this.resultSetCounter = this.resultSetCounter + 1L;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
    }

    public JSONObject convertRowToJsonObject(ResultSetMetaData rsmd, ResultSet resultRow, boolean isAnalyticsQuery) throws Exception {
        JSONObject orderedJson = new JSONObject();
        JSONObject jsonOrderedMap = new JSONObject();
        String columnName = null;
        String columnValue = null;
        int i = 0;
        while (i < rsmd.getColumnCount()) {
            columnName = rsmd.getColumnLabel(i + 1);
            columnValue = this.getColValueUsingColName(resultRow, columnName);
            columnName = this.keyToLowercase != false && !isAnalyticsQuery ? columnName.toLowerCase() : columnName;
            jsonOrderedMap.put((Object)columnName, (Object)(Util.isNotNullOrEmpty(columnValue) ? JSONObject.escape((String)columnValue).replace("\\/", "/") : columnValue));
            ++i;
        }
        return jsonOrderedMap;
    }

    private String getColValueUsingColName(ResultSet rs, String colName) {
        String columnValue = "";
        try {
            columnValue = rs.getString(colName);
        }
        catch (Exception e) {
            logger.info("Unable to get column value from result set.");
        }
        return columnValue;
    }

    public Long getResultSetCount() {
        return this.resultSetCounter;
    }

    public final JSONObject ResultSet2JSONString(ResultSet resultSet, boolean isAnalyticsQuery) throws JSONException, SQLException {
        return this.ResultSet2JSONObject(resultSet, isAnalyticsQuery);
    }

    public final String Object2JSONString(Object o) {
        return null;
    }

    public final String String2JSONString(String str) {
        return "{result:'success',data:" + str + "}";
    }

    public JSONArray getErrors() {
        return new JSONArray();
    }

    public final JSONArray parseStringToJsonArray(String jsonString) throws Exception {
        if (jsonString == null) {
            return null;
        }
        JSONParser parser = new JSONParser();
        return (JSONArray)parser.parse(jsonString);
    }

    public final JSONObject parseStringToJsonObject(String jsonString) throws Exception {
        if (jsonString == null) {
            return null;
        }
        JSONParser parser = new JSONParser();
        return (JSONObject)parser.parse(jsonString);
    }

    public JSONObject updateJsonWithResult(JSONObject dataSourceInfoAndQueryObject, ResultSet resultSet, boolean createResultList, ArrayList<String> resultList, boolean isAnalyticsQuery) throws Exception {
        this.updateRunResultOrRunJsonIntempDebug(dataSourceInfoAndQueryObject, resultSet, false, isAnalyticsQuery);
        return dataSourceInfoAndQueryObject;
    }

    public JSONObject updateJsonWithResult(JSONObject tempDebug, JSONArray resultsArray, boolean createResultList, ArrayList<String> resultList) throws Exception {
        int resultLimit;
        boolean isUpdateRunResult = "1".equals(String.valueOf(tempDebug.get((Object)"updateRunResult"))) && !this.isExportJsonRule(tempDebug);
        int n = resultLimit = tempDebug.get((Object)"resultLimit") != null ? Integer.parseInt(String.valueOf(tempDebug.get((Object)"resultLimit"))) : 200000;
        if (createResultList) {
            int count = 0;
            long startTime = System.currentTimeMillis();
            for (Object result : resultsArray) {
                JSONObject jsonObj = (JSONObject)result;
                String keyStr = (String)jsonObj.keySet().toArray()[0];
                if (tempDebug.get((Object)"SAWSDataType") != null && "INT".equalsIgnoreCase(tempDebug.get((Object)"SAWSDataType").toString())) {
                    resultList.add(String.valueOf(jsonObj.get((Object)keyStr)));
                } else {
                    resultList.add("'" + String.valueOf(jsonObj.get((Object)keyStr)) + "'");
                }
                ++count;
            }
            long endTime = System.currentTimeMillis();
            float executionTime = (endTime - startTime) / 1000L;
            tempDebug.put((Object)"runResult", (Object)count);
        } else if (resultsArray != null && resultsArray.size() > 0) {
            if (isUpdateRunResult) {
                JSONObject json = (JSONObject)resultsArray.get(0);
                String keyStr = (String)json.keySet().toArray()[0];
                tempDebug.put((Object)"runResult", (Object)String.valueOf(json.get((Object)keyStr)));
            } else {
                JSONObject newRunJson = new JSONObject();
                newRunJson.put((Object)"results", (Object)resultsArray);
                Long resultSize = this.resultSetCounter != 0L && this.resultSetCounter > (long)resultsArray.size() ? this.resultSetCounter : Long.valueOf(resultsArray.size());
                newRunJson.put((Object)"resultCount", (Object)resultSize);
                newRunJson.put((Object)"errors", (Object)new JSONArray());
                tempDebug.put((Object)"runJson", (Object)newRunJson.toString());
                tempDebug.put((Object)"runResult", (Object)resultsArray.size());
            }
        }
        tempDebug.put((Object)"runStatus", (Object)"0");
        return tempDebug;
    }

    public String getLimitedJSONResult(int limit, JSONArray resultsArray) {
        JSONArray limitedJSON = new JSONArray();
        int resultLength = resultsArray != null && !resultsArray.isEmpty() ? resultsArray.size() : 0;
        int i = 0;
        while (i < resultLength && i < limit) {
            limitedJSON.add(resultsArray.get(i));
            ++i;
        }
        return limitedJSON.toJSONString();
    }

    private boolean isExportJsonRule(JSONObject dataSourceInfoAndQueryObject) {
        return dataSourceInfoAndQueryObject.get((Object)"sawsExportOption") != null && "JSN".equalsIgnoreCase(String.valueOf(dataSourceInfoAndQueryObject.get((Object)"sawsExportOption")));
    }

    public JSONObject updateJsonWithResult(JSONObject dataSourceInfoAndQueryObject, int[] updatedRowCount) throws Exception {
        dataSourceInfoAndQueryObject.put((Object)"runResult", null);
        dataSourceInfoAndQueryObject.put((Object)"runStatus", (Object)"0");
        return dataSourceInfoAndQueryObject;
    }

    public JSONObject updateJsonWithResult(JSONObject dataSourceInfoAndQueryObject, int updatedRowCount) throws Exception {
        dataSourceInfoAndQueryObject.put((Object)"runResult", (Object)updatedRowCount);
        dataSourceInfoAndQueryObject.put((Object)"runStatus", (Object)"0");
        return dataSourceInfoAndQueryObject;
    }

    public void updateRunResultOrRunJsonIntempDebug(JSONObject tempDebug, ResultSet resultSet, boolean updateRunResult, boolean isAnalyticsQuery) throws Exception {
        boolean isResultSetEmpty;
        this.maxResultToJsonLimit = tempDebug.get((Object)"maxResultToJsonLimit") != null ? Long.valueOf(tempDebug.get((Object)"maxResultToJsonLimit").toString()) : this.maxResultToJsonLimit;
        boolean bl = isResultSetEmpty = !resultSet.next();
        if (resultSet != null && !isResultSetEmpty || resultSet != null && isAnalyticsQuery) {
            if (updateRunResult) {
                Long count = isResultSetEmpty ? 0L : resultSet.getLong(1);
                tempDebug.put((Object)"runResult", (Object)count);
            } else {
                tempDebug.put((Object)"runJson", (Object)this.ResultSet2JSONString(resultSet, isAnalyticsQuery));
                tempDebug.put((Object)"runResult", (Object)this.getResultSetCount());
            }
        } else {
            logger.info("No Data Found: " + tempDebug.toJSONString());
        }
        tempDebug.put((Object)"runStatus", (Object)"0");
    }

    public void updateRunResultOrRunJsonForMasterSalve(JSONObject tempDebug, ResultSet resultSet, boolean updateRunResult, ArrayList<String> resultList) throws Exception {
        this.convetResultSetToList(tempDebug, resultSet, updateRunResult, resultList);
        tempDebug.put((Object)"runStatus", (Object)"0");
    }

    public void convetResultSetToList(JSONObject tempDebug, ResultSet resultSet, boolean updateRunResult, ArrayList<String> resultList) throws Exception {
        int count = 0;
        long startTime = System.currentTimeMillis();
        while (resultSet != null && resultSet.next()) {
            if (tempDebug.get((Object)"SAWSDataType") != null && "INT".equalsIgnoreCase(tempDebug.get((Object)"SAWSDataType").toString())) {
                resultList.add(resultSet.getString(1));
            } else {
                resultList.add("'" + resultSet.getString(1) + "'");
            }
            ++count;
        }
        long endTime = System.currentTimeMillis();
        float executionTime = (endTime - startTime) / 1000L;
        tempDebug.put((Object)"runResult", (Object)count);
    }

    public void creatJsonForMasterSlave(JSONObject tempDebug, ResultSet resultSet, boolean updateRunResult, ArrayList<String> resultList) throws Exception {
        if (!updateRunResult) {
            resultSet.first();
            tempDebug.put((Object)"runJson", (Object)this.ResultSet2JSONString(resultSet, false));
            tempDebug.put((Object)"runStatus", (Object)"0");
        }
    }

    public JSONArray getAsJsonArry(String jsonString, String arrayAttr) {
        JSONArray sampleJsonArray = new JSONArray();
        try {
            JSONParser parser = new JSONParser();
            JSONObject parsedJson = (JSONObject)parser.parse(jsonString);
            sampleJsonArray = (JSONArray)parsedJson.get((Object)arrayAttr);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            e.printStackTrace();
        }
        return sampleJsonArray;
    }

    public JSONObject limitRunJsonObject(JSONObject queryResultObj, int resultLimit) {
        block6: {
            try {
                JSONObject limitJson = new JSONObject();
                String runJsonStr = String.valueOf(queryResultObj.get((Object)"runJson"));
                if (!Util.isNullOrEmpty(runJsonStr)) {
                    JSONObject runJson = this.parseStringToJsonObject(runJsonStr);
                    if (runJson != null && !runJson.isEmpty()) {
                        JSONObject newRunJson = new JSONObject();
                        JSONArray results = (JSONArray)runJson.get((Object)"results");
                        JSONArray limitedResult = new JSONArray();
                        int resultsLength = results.size();
                        Set keys = queryResultObj.keySet();
                        for (String key : keys) {
                            if ("runJson".equalsIgnoreCase(key)) continue;
                            limitJson.put((Object)key, queryResultObj.get((Object)key));
                        }
                        int i = 0;
                        while (i < resultsLength && i < resultLimit) {
                            limitedResult.add((Object)this.getOrderedObject(results.get(i)));
                            ++i;
                        }
                        newRunJson.put((Object)"results", (Object)limitedResult);
                        Long resultSize = this.resultSetCounter != 0L && this.resultSetCounter > (long)resultsLength ? this.resultSetCounter : Long.valueOf(resultsLength);
                        newRunJson.put((Object)"resultCount", (Object)resultSize);
                        newRunJson.put((Object)"errors", runJson.get((Object)"errors"));
                        limitJson.put((Object)"runJson", (Object)newRunJson.toString());
                        return limitJson;
                    }
                    break block6;
                }
                return queryResultObj;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return queryResultObj;
    }

    public static String compressJsonFile(String jsonFilePath) {
        String gzFilePath = jsonFilePath.trim().concat(".gz");
        GzipUtil.convertJsonToGz(jsonFilePath, gzFilePath);
        return gzFilePath;
    }

    private List<String> getJsonObjectKeysList(JSONObject jsonObj) {
        ArrayList<String> keys = new ArrayList<String>();
        if (jsonObj != null && !jsonObj.isEmpty()) {
            keys.addAll(jsonObj.keySet());
        }
        return keys;
    }

    private LinkedHashMap getOrderedObject(Object unOrderedJson) {
        LinkedHashMap<String, Object> orderedMap = new LinkedHashMap<String, Object>();
        JSONObject jsonObj = (JSONObject)unOrderedJson;
        List<String> orderdKeys = this.orderedKeysList != null && !this.orderedKeysList.isEmpty() ? this.orderedKeysList : this.getJsonObjectKeysList((JSONObject)unOrderedJson);
        for (String key : orderdKeys) {
            orderedMap.put(key, jsonObj.get((Object)key));
        }
        return orderedMap;
    }

    public JSONArray limitRunJson(JSONArray resultsArray) {
        JSONArray limitedRunJsonArray = new JSONArray();
        for (Object result : resultsArray) {
            boolean isRunJsonUpdated;
            JSONObject resultJson = (JSONObject)result;
            int resultLimit = resultJson.get((Object)"resultLimit") != null ? Integer.parseInt(String.valueOf(resultJson.get((Object)"resultLimit"))) : 200000;
            boolean bl = isRunJsonUpdated = resultJson.get((Object)"updateRunResult") != null && !"1".equalsIgnoreCase(String.valueOf(resultJson.get((Object)"updateRunResult")));
            if (isRunJsonUpdated) {
                limitedRunJsonArray.add((Object)this.limitRunJsonObject(resultJson, resultLimit));
                continue;
            }
            limitedRunJsonArray.add((Object)resultJson);
        }
        return limitedRunJsonArray;
    }

    public List<String> getOrderedKeysList() {
        return this.orderedKeysList;
    }

    public void setOrderedKeysList(List<String> orderedKeysList) {
        this.orderedKeysList = orderedKeysList;
    }

    public JSONObject getDVTTDQueryJson(String queryString) throws Exception {
        JSONParser parser = new JSONParser();
        JSONObject obj = (JSONObject)parser.parse(queryString);
        JSONArray geodata = (JSONArray)obj.get((Object)"rowset");
        JSONObject sapQuery = (JSONObject)geodata.get(0);
        return sapQuery;
    }

    public static JSONObject parseToJsonObject(String jsonString) throws ParseException {
        JSONObject parsedJSONObject = null;
        if (Util.isNotNullOrEmpty(jsonString)) {
            JSONParser parser = new JSONParser();
            try {
                Object parsedJson = parser.parse(jsonString);
                if (parsedJson instanceof String) {
                    parsedJSONObject = (JSONObject)parser.parse((String)parsedJson);
                } else if (parsedJson instanceof JSONObject) {
                    parsedJSONObject = (JSONObject)parsedJson;
                }
                return parsedJSONObject;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static Object parseToJson(String jsonString) throws ParseException {
        JSONObject parsedObject = null;
        try {
            parsedObject = JsonUtil.parseToJsonObject(jsonString);
            if (parsedObject == null) {
                parsedObject = JsonUtil.parseToJsonArray(jsonString);
            }
        }
        catch (Exception e) {
            logger.error("Error while parsing jsonString to Json. Error :", e.getMessage());
            e.printStackTrace();
        }
        return parsedObject;
    }

    public static Object parseToJsonOrReturn(String jsonString) throws ParseException {
        JSONObject parsedObject = null;
        try {
            parsedObject = JsonUtil.parseToJsonObject(jsonString);
            if (parsedObject == null) {
                parsedObject = JsonUtil.parseToJsonArray(jsonString);
            }
        }
        catch (Exception e) {
            logger.error("Error while parsing jsonString to Json. Error :", e.getMessage());
            e.printStackTrace();
        }
        return parsedObject == null ? jsonString : parsedObject;
    }

    public static String getJsonString(Object jsonContent) {
        String jsonString = null;
        try {
            jsonString = jsonContent instanceof JSONObject ? ((JSONObject)jsonContent).toJSONString() : (jsonContent instanceof JSONArray ? ((JSONArray)jsonContent).toJSONString() : String.valueOf(jsonContent));
        }
        catch (Exception e) {
            logger.error("Error while parsing object to string. Error :", e.getMessage());
            e.printStackTrace();
        }
        return jsonString;
    }

    public static JSONArray parseToJsonArray(String jsonString) throws ParseException {
        if (Util.isNotNullOrEmpty(jsonString)) {
            JSONParser parser = new JSONParser();
            try {
                JSONArray parsedJson = (JSONArray)parser.parse(jsonString);
                return parsedJson;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Boolean setkeyToLowercase(Boolean val) {
        this.keyToLowercase = val;
        return this.keyToLowercase;
    }

    public static String mapToJsonString(Map<String, Object> map) {
        if (map == null) {
            throw new IllegalArgumentException("Map cannot be null");
        }
        Gson gson = new Gson();
        return gson.toJson(map);
    }

    public static Object getSafe(JSONObject json, String key, Object defaultValue) {
        return json != null && json.containsKey((Object)key) ? json.get((Object)key) : defaultValue;
    }

    public static JSONObject getSafeJsonObject(JSONObject json, String key) {
        return (JSONObject)JsonUtil.getSafe(json, key, null);
    }

    public static JSONArray getSafeJsonArray(JSONObject json, String key) {
        return (JSONArray)JsonUtil.getSafe(json, key, new JSONArray());
    }
}

