/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.util;

import com.dvsum.logger.CustomLogger;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class JSONToCSVUtil {
    private static final CustomLogger logger = CustomLogger.getLogger(JSONToCSVUtil.class);

    public static String convertJsonArrayToCsv(String jsonArrayStr) {
        StringBuilder csvBuilder = new StringBuilder();
        LinkedHashSet<String> headers = new LinkedHashSet<String>();
        JSONArray jsonArray = null;
        try {
            JSONObject jsonObject;
            JSONParser parser = new JSONParser();
            jsonArray = (JSONArray)parser.parse(jsonArrayStr);
            for (Object obj : jsonArray) {
                jsonObject = (JSONObject)obj;
                JSONToCSVUtil.collectKeys("", jsonObject, headers);
            }
            for (String header : headers) {
                csvBuilder.append(header).append(",");
            }
            csvBuilder.setLength(csvBuilder.length() - 1);
            csvBuilder.append("\n");
            for (Object obj : jsonArray) {
                jsonObject = (JSONObject)obj;
                LinkedHashMap<String, String> rowValues = new LinkedHashMap<String, String>();
                JSONToCSVUtil.collectValues("", jsonObject, rowValues, headers);
                for (String header : headers) {
                    String value = rowValues.getOrDefault(header, "");
                    csvBuilder.append(value).append(",");
                }
                csvBuilder.setLength(csvBuilder.length() - 1);
                csvBuilder.append("\n");
            }
        }
        catch (Exception e) {
            System.err.println("Error while converting JSON to CSV. Error: " + e.getMessage());
            e.printStackTrace();
        }
        return csvBuilder.toString();
    }

    private static void collectKeys(String parentKey, JSONObject jsonObject, Set<String> headers) {
        if (jsonObject == null) {
            return;
        }
        for (Object keyObj : jsonObject.keySet()) {
            String fullKey;
            String key = keyObj.toString();
            Object value = jsonObject.get((Object)key);
            String string = fullKey = parentKey.isEmpty() ? key : String.valueOf(parentKey) + "." + key;
            if (value instanceof JSONObject) {
                JSONToCSVUtil.collectKeys(fullKey, (JSONObject)value, headers);
                continue;
            }
            if (value instanceof JSONArray) {
                JSONArray array = (JSONArray)value;
                int i = 0;
                while (i < array.size()) {
                    JSONToCSVUtil.collectKeys(String.valueOf(fullKey) + "[" + i + "]", (JSONObject)array.get(i), headers);
                    ++i;
                }
                continue;
            }
            headers.add(fullKey);
        }
    }

    private static void collectValues(String parentKey, JSONObject jsonObject, Map<String, String> rowValues, Set<String> headers) {
        if (jsonObject == null) {
            return;
        }
        for (Object keyObj : jsonObject.keySet()) {
            String fullKey;
            String key = keyObj.toString();
            Object value = jsonObject.get((Object)key);
            String string = fullKey = parentKey.isEmpty() ? key : String.valueOf(parentKey) + "." + key;
            if (value instanceof JSONObject) {
                JSONToCSVUtil.collectValues(fullKey, (JSONObject)value, rowValues, headers);
                continue;
            }
            if (value instanceof JSONArray) {
                JSONArray array = (JSONArray)value;
                int i = 0;
                while (i < array.size()) {
                    JSONToCSVUtil.collectValues(String.valueOf(fullKey) + "[" + i + "]", (JSONObject)array.get(i), rowValues, headers);
                    ++i;
                }
                continue;
            }
            rowValues.put(fullKey, value != null ? value.toString() : "");
        }
    }

    public static void main(String[] args) {
        String jsonArrayStr = "[{\"Sigma DPM\":{\"service_details\":{\"0\":{\"package\":\"JM_TK_IYR_LG_SIP ThreeInOne\",\"mac_address\":\"E457404B4252 [CM]   70dff7a43a3b[SIP]   \",\"device_event_view\":{\"0\":{\"device_name\":\"JamaicaDHCP\",\"role\":\"dhcp\",\"mac_address\":\"-\",\"ip_address\":\"10.159.10.140 \"},\"1\":{\"device_name\":\"H1-NMG1-CM2\",\"role\":\"DocsisCMTS\",\"mac_address\":\"-\",\"ip_address\":\"65.183.0.249 \"},\"2\":{\"device_name\":\"-\",\"role\":\"CM\",\"mac_address\":\"E457404B4252\",\"ip_address\":\"10.134.67.59 \"},\"3\":{\"device_name\":\"-\",\"role\":\"CPE\",\"mac_address\":\"70dff7a43a3c \",\"ip_address\":\"72.252.161.160\"}}}},\"customer_id\":\"33487201\",\"bu_id\":\"JAM\",\"error\":\"NA\",\"status\":\"success\",\"timestamp\":\"20240405095129\"},\"dvsum_metadata\":{\"execution_id\":\"39150329_241122163726_28519055-1a79-42ce-baaa-bc1bd2225a76:STEP_1:crm_data:G\\/o86uWZ2f\\/SjM7PyX4VBUToqmTV5XEB21+hDIdY46Q=\",\"instance\":\"CLOUD_DEV\"},\"Cerillion\":{\"mac_address\":{\"0\":\"E457404B4252\"},\"customer_id\":\"33487201\",\"bu_id\":\"JAM\",\"error\":\"NA\",\"status\":\"success\",\"timestamp\":\"20240405095129\"},\"customer_id\":\"33487201\",\"bu_id\":\"JAM\"}] ";
        System.out.println(JSONToCSVUtil.convertJsonArrayToCsv(jsonArrayStr));
    }
}

