/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.util;

import com.dvsum.logger.CustomLogger;
import com.dvsum.model.HttpResponseData;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

public class HttpRequestUtil {
    private static final CustomLogger logger = CustomLogger.getLogger(HttpRequestUtil.class);

    public static String sendPostRequest(String urlString, String jsonInputString) {
        HttpURLConnection connection = null;
        try {
            URL url = new URL(urlString);
            logger.info("Sending POST request to: ", url);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json; utf-8");
            connection.setRequestProperty("Accept", "application/json");
            connection.setDoOutput(true);
            Throwable throwable = null;
            Throwable throwable2 = null;
            try (OutputStream os = connection.getOutputStream();){
                byte[] input = jsonInputString.getBytes("utf-8");
                os.write(input, 0, input.length);
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            int responseCode = connection.getResponseCode();
            if (responseCode >= 200 && responseCode < 300) {
                String string;
                block28: {
                    throwable2 = null;
                    Object var6_11 = null;
                    BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream(), "utf-8"));
                    try {
                        String responseLine;
                        StringBuilder response = new StringBuilder();
                        while ((responseLine = br.readLine()) != null) {
                            response.append(responseLine.trim());
                        }
                        string = response.toString();
                        if (br == null) break block28;
                    }
                    catch (Throwable throwable4) {
                        try {
                            if (br != null) {
                                br.close();
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (throwable2 == null) {
                                throwable2 = throwable5;
                            } else if (throwable2 != throwable5) {
                                throwable2.addSuppressed(throwable5);
                            }
                            throw throwable2;
                        }
                    }
                    br.close();
                }
                return string;
            }
            String string = "Error: HTTP Response Code " + responseCode;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = "Error: " + e.getMessage();
            return string;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static String sendGetRequest(String urlString) {
        HttpURLConnection connection = null;
        try {
            URL url = new URL(urlString);
            logger.info("Sending GET request to: ", url);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Accept", "application/json");
            int responseCode = connection.getResponseCode();
            if (responseCode >= 200 && responseCode < 300) {
                String string;
                block18: {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream(), "utf-8"));
                    try {
                        String responseLine;
                        StringBuilder response = new StringBuilder();
                        while ((responseLine = br.readLine()) != null) {
                            response.append(responseLine.trim());
                        }
                        string = response.toString();
                        if (br == null) break block18;
                    }
                    catch (Throwable throwable2) {
                        try {
                            if (br != null) {
                                br.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    br.close();
                }
                return string;
            }
            String string = "Error: HTTP Response Code " + responseCode;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = "Error: " + e.getMessage();
            return string;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static void addHeaders(Map<String, Object> headers, HttpURLConnection connection) {
        if (headers != null) {
            for (Map.Entry<String, Object> header : headers.entrySet()) {
                connection.setRequestProperty(header.getKey(), String.valueOf(header.getValue()));
            }
        }
    }

    public static HttpResponseData sendGetRequest(String urlString, Map<String, Object> headers) {
        HttpURLConnection connection = null;
        try {
            URL url = new URL(urlString);
            logger.info("Sending GET request to: ", url);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Accept", "application/json");
            HttpRequestUtil.addHeaders(headers, connection);
            int responseCode = connection.getResponseCode();
            if (responseCode >= 200 && responseCode < 300) {
                HttpResponseData httpResponseData;
                block18: {
                    Throwable throwable = null;
                    Object var6_8 = null;
                    BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream(), "utf-8"));
                    try {
                        String responseLine;
                        StringBuilder response = new StringBuilder();
                        while ((responseLine = br.readLine()) != null) {
                            response.append(responseLine.trim());
                        }
                        httpResponseData = new HttpResponseData(responseCode, response.toString());
                        if (br == null) break block18;
                    }
                    catch (Throwable throwable2) {
                        try {
                            if (br != null) {
                                br.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    br.close();
                }
                return httpResponseData;
            }
            logger.error("Error: HTTP Response Code " + responseCode);
            HttpResponseData httpResponseData = new HttpResponseData(responseCode, null);
            return httpResponseData;
        }
        catch (Exception e) {
            logger.error("Error: " + e.getMessage());
            e.printStackTrace();
            HttpResponseData httpResponseData = new HttpResponseData(400, e.getMessage());
            return httpResponseData;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static HttpResponseData sendPostRequest(String urlString, String jsonInputString, Map<String, Object> headers) {
        HttpURLConnection connection = null;
        try {
            URL url = new URL(urlString);
            logger.info("Sending POST request to: ", url);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json; utf-8");
            connection.setRequestProperty("Accept", "application/json");
            HttpRequestUtil.addHeaders(headers, connection);
            connection.setDoOutput(true);
            Throwable throwable = null;
            Throwable throwable2 = null;
            try (OutputStream os = connection.getOutputStream();){
                byte[] input = jsonInputString.getBytes("utf-8");
                os.write(input, 0, input.length);
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            int responseCode = connection.getResponseCode();
            if (responseCode >= 200 && responseCode < 300) {
                HttpResponseData httpResponseData;
                block28: {
                    throwable2 = null;
                    Object var7_12 = null;
                    BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream(), "utf-8"));
                    try {
                        String responseLine;
                        StringBuilder response = new StringBuilder();
                        while ((responseLine = br.readLine()) != null) {
                            response.append(responseLine.trim());
                        }
                        httpResponseData = new HttpResponseData(responseCode, response.toString());
                        if (br == null) break block28;
                    }
                    catch (Throwable throwable4) {
                        try {
                            if (br != null) {
                                br.close();
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (throwable2 == null) {
                                throwable2 = throwable5;
                            } else if (throwable2 != throwable5) {
                                throwable2.addSuppressed(throwable5);
                            }
                            throw throwable2;
                        }
                    }
                    br.close();
                }
                return httpResponseData;
            }
            logger.error("Error: HTTP Response Code " + responseCode);
            HttpResponseData httpResponseData = new HttpResponseData(responseCode, null);
            return httpResponseData;
        }
        catch (Exception e) {
            logger.error("Error: " + e.getMessage());
            e.printStackTrace();
            HttpResponseData httpResponseData = new HttpResponseData(400, e.getMessage());
            return httpResponseData;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static void main(String[] args) {
        String postUrl = "http://localhost:8190/execute";
        String jsonPayload = "{\"name\":\"John\", \"age\":30}";
        String postResponse = HttpRequestUtil.sendPostRequest(postUrl, jsonPayload);
        System.out.println("POST Response: " + postResponse);
    }
}

