/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.util;

import com.dvsum.util.CryptographicUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;

public class GzipUtil {
    public static String compressString(String srcTxt) throws IOException {
        ByteArrayOutputStream rstBao = new ByteArrayOutputStream();
        GZIPOutputStream zos = new GZIPOutputStream(rstBao);
        zos.write(srcTxt.getBytes());
        IOUtils.closeQuietly((OutputStream)zos);
        byte[] bytes = rstBao.toByteArray();
        return Base64.encodeBase64String((byte[])bytes);
    }

    public static String uncompressString(String zippedBase64Str) throws IOException {
        String result = null;
        byte[] bytes = Base64.decodeBase64((String)zippedBase64Str);
        GZIPInputStream zi = null;
        try {
            zi = new GZIPInputStream(new ByteArrayInputStream(bytes));
            result = IOUtils.toString((InputStream)zi);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(zi);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)zi);
        return result;
    }

    public static void convertJsonToGz(String jsonFilePath, String gzFilePath) {
        try {
            int bytesRead;
            FileInputStream fileInputStream = new FileInputStream(jsonFilePath);
            FileOutputStream fileOutputStream = new FileOutputStream(gzFilePath);
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(fileOutputStream);
            byte[] buffer = new byte[1024];
            while ((bytesRead = fileInputStream.read(buffer)) > 0) {
                gzipOutputStream.write(buffer, 0, bytesRead);
            }
            fileInputStream.close();
            gzipOutputStream.finish();
            gzipOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void testFileZip() throws IOException {
        String source = "C:\\temp\\Encoding Time.csv";
        String zippedFile = "C:\\temp\\Encoding Time Zipped.csv";
        FileInputStream fis = new FileInputStream(source);
        String srcTxt = IOUtils.toString((InputStream)fis, (String)"UTF-8");
        IOUtils.closeQuietly((InputStream)fis);
        String str = GzipUtil.compressString(srcTxt);
        str = CryptographicUtil.encrypt(str);
        FileWriter fw = new FileWriter(zippedFile);
        IOUtils.write((String)str, (Writer)fw);
        IOUtils.closeQuietly((Writer)fw);
        fis = new FileInputStream(zippedFile);
        String zippedBase64Str = IOUtils.toString((InputStream)fis, (String)"UTF-8");
        IOUtils.closeQuietly((InputStream)fis);
        String originalStr = CryptographicUtil.decrypt(zippedBase64Str);
        originalStr = GzipUtil.uncompressString(originalStr);
        fw = new FileWriter("C:\\temp\\Encoding Time reverted.csv");
        IOUtils.write((String)originalStr, (Writer)fw);
        IOUtils.closeQuietly((Writer)fw);
        System.out.println(" done!! ");
    }

    public static void main(String ... args) throws IOException {
        GzipUtil.testFileZip();
    }
}

