/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class GsonToJsonSimpleConverter {
    public static JSONArray convertGsonArrayToSimpleArray(JsonArray gsonArray) {
        JSONArray simpleArray = new JSONArray();
        for (JsonElement element : gsonArray) {
            simpleArray.add(GsonToJsonSimpleConverter.convertGsonElementToSimpleObject(element));
        }
        return simpleArray;
    }

    private static Object convertGsonElementToSimpleObject(JsonElement element) {
        if (element.isJsonObject()) {
            return GsonToJsonSimpleConverter.convertGsonObjectToSimpleObject(element.getAsJsonObject());
        }
        if (element.isJsonArray()) {
            return GsonToJsonSimpleConverter.convertGsonArrayToSimpleArray(element.getAsJsonArray());
        }
        if (element.isJsonPrimitive()) {
            return GsonToJsonSimpleConverter.convertGsonPrimitiveToSimpleObject(element.getAsJsonPrimitive());
        }
        if (element.isJsonNull()) {
            return null;
        }
        return null;
    }

    public static JSONObject convertGsonObjectToSimpleObject(JsonObject gsonObject) {
        JSONObject simpleObject = new JSONObject();
        for (Map.Entry entry : gsonObject.entrySet()) {
            simpleObject.put(entry.getKey(), GsonToJsonSimpleConverter.convertGsonElementToSimpleObject((JsonElement)entry.getValue()));
        }
        return simpleObject;
    }

    private static Object convertGsonPrimitiveToSimpleObject(JsonPrimitive primitive) {
        if (primitive.isBoolean()) {
            return primitive.getAsBoolean();
        }
        if (primitive.isNumber()) {
            return primitive.getAsNumber();
        }
        if (primitive.isString()) {
            return primitive.getAsString();
        }
        return null;
    }

    public static void main(String[] args) {
        String jsonArrayStr = "[{\"index\":\"1\",\"parameters\":{\"frequency\":{\"value\":\"171.0\",\"type\":\"FLOAT\"},\"ifDescr\":{\"value\":\"cable-downstream 9/0/0\",\"type\":\"STRING\"},\"ifSpeed\":{\"value\":\"42.884296\",\"type\":\"FLOAT\"},\"ifType\":{\"value\":\"128\",\"type\":\"STRING\"}}},{\"index\":\"2\",\"parameters\":{\"frequency\":{\"value\":\"177.0\",\"type\":\"FLOAT\"},\"ifDescr\":{\"value\":\"cable-downstream 9/0/1\",\"type\":\"STRING\"},\"ifSpeed\":{\"value\":\"42.884296\",\"type\":\"FLOAT\"},\"ifType\":{\"value\":\"128\",\"type\":\"STRING\"}}}]";
        JsonParser parser = new JsonParser();
        JsonElement jsonElement = parser.parse(jsonArrayStr);
        JsonArray gsonArray = jsonElement.getAsJsonArray();
        JSONArray simpleArray = GsonToJsonSimpleConverter.convertGsonArrayToSimpleArray(gsonArray);
        System.out.println(simpleArray.toJSONString());
    }
}

