/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.util;

import com.dvsum.util.Util;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static Logger logger = LoggerFactory.getLogger(DateUtil.class);
    public static final String DATE_PATTERN = "MM/dd/yyyy";
    public static final String ISO_DATE_PATTERN = "yyyy-MM-dd HH:mm:ss";

    public static String getDate(String Formate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(Formate);
        Date date = new Date();
        return dateFormat.format(date);
    }

    public static String getCurrentTimeInTwentyFourHourFormate() {
        Calendar cal = Calendar.getInstance();
        Date date = cal.getTime();
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm");
        return dateFormat.format(date);
    }

    public static String getFormattedStr(Date date, String pattern) {
        if (date == null || pattern == null) {
            return "";
        }
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        return formatter.format(date);
    }

    public static Date getDate(String dateStr, String pattern) {
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        if (Util.isNullOrEmpty(dateStr)) {
            return null;
        }
        try {
            return formatter.parse(dateStr);
        }
        catch (ParseException e) {
            logger.warn(e.toString());
            return null;
        }
    }

    public static String getFormattedCurrentDateTime(String format) {
        LocalDateTime currentDateTime = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
        return currentDateTime.format(formatter);
    }

    public static Date getDateFromString(String dateStr, String pattern) {
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        if (Util.isNullOrEmpty(dateStr)) {
            return null;
        }
        try {
            return formatter.parse(dateStr);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static long getDifferenceDays(String date1, String date2) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        try {
            System.out.println(dateFormat.parse(date2).getTime());
            System.out.println(dateFormat.parse(date2).getTime());
            long diff = dateFormat.parse(date2).getTime() - dateFormat.parse(date1).getTime();
            return TimeUnit.DAYS.convert(diff, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1L;
        }
    }

    public static long getCurrentEpochTimeInSeconds() {
        return System.currentTimeMillis() / 1000L;
    }

    public static long getCurrentEpochTimeInMillis() {
        return System.currentTimeMillis();
    }

    public static void main(String[] args) {
        System.out.println(DateUtil.getCurrentEpochTimeInSeconds());
    }
}

