/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.util;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class CSVWriter {
    public static void main(String[] args) {
        CSVWriter csv = new CSVWriter();
        try {
            csv.writeToFile("xyxz", "/Users/shafaqatali/Downloads/test.csv");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void writeAsCSV(List<LinkedHashMap<String, String>> flatJson, String fileName) throws FileNotFoundException {
        Set<String> headers = this.collectHeaders(flatJson);
        String output = String.valueOf(String.valueOf(StringUtils.join((Object[])headers.toArray(), (String)","))) + "\n";
        for (LinkedHashMap<String, String> map : flatJson) {
            output = String.valueOf(String.valueOf(output)) + this.getCommaSeperatedRow(headers, map) + "\n";
        }
        this.writeToFile(output, fileName);
    }

    private void writeToFile(String output, String fileName) throws FileNotFoundException {
        block6: {
            BufferedWriter writer = null;
            try {
                try {
                    Path filePath = Paths.get(fileName, new String[0]);
                    if (!Files.exists(filePath, new LinkOption[0])) {
                        Files.createDirectories(Paths.get(fileName, new String[0]).getParent(), new FileAttribute[0]);
                        Files.createFile(Paths.get(fileName, new String[0]), new FileAttribute[0]);
                    }
                    writer = new BufferedWriter(new FileWriter(fileName, false));
                    writer.write(output);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.close(writer);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(writer);
                throw throwable;
            }
            this.close(writer);
        }
    }

    private void close(BufferedWriter writer) {
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getCommaSeperatedRow(Set<String> headers, LinkedHashMap<String, String> map) {
        ArrayList<String> items = new ArrayList<String>();
        for (String header : headers) {
            String value = map.get(header) == null ? "" : map.get(header);
            items.add("\"" + value + "\"");
        }
        return StringUtils.join((Object[])items.toArray(), (String)",");
    }

    private Set<String> collectHeaders(List<LinkedHashMap<String, String>> flatJson) {
        LinkedHashSet<String> headers = new LinkedHashSet<String>();
        for (LinkedHashMap<String, String> map : flatJson) {
            headers.addAll(map.keySet());
        }
        return headers;
    }
}

