/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.services;

import com.dvsum.logger.CustomLogger;
import com.dvsum.util.FileUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Service
@Component
public class ScriptExecutionService {
    private static final CustomLogger logger = CustomLogger.getLogger(ScriptExecutionService.class);

    public void executeScript(String filePath, String fileName, String updateProps) {
        if (FileUtil.isCsv(fileName)) {
            this.executePerlScript(filePath, FileUtil.getPropertyWithDefault("scriptPath", ""));
        } else if (FileUtil.isExcel(fileName)) {
            String excelPreProcessPython = FileUtil.getPropertyWithDefault("excelPreProcesPythonScript", "");
            filePath = filePath.replace("\\", "/");
            String cmd = String.valueOf(this.getPythonPath()) + " \"" + excelPreProcessPython + "\" \"" + filePath + "\" \"" + fileName + "\" " + updateProps;
            this.executePythonCmd(cmd);
        }
    }

    private String getPythonPath() {
        String path = System.getenv("PATH");
        String[] pathEntries = path.split(";");
        String pythonExePath = "python";
        String[] stringArray = pathEntries;
        int n = pathEntries.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            if (entry.toLowerCase().contains("python") && !entry.toLowerCase().contains("scripts")) {
                pythonExePath = "\"" + entry.replace("\\", "/") + "python\"";
            }
            ++n2;
        }
        return pythonExePath;
    }

    @Async
    public void executePerlScript(String filePath, String scriptPath) {
        Runtime runtime = Runtime.getRuntime();
        try {
            logger.debug(" =============== Executing Script =============== ");
            logger.debug("  scriptPath " + scriptPath.replace("\\", "/"));
            logger.debug("  filePath  " + filePath);
            String cmd = "cmd /c call \"" + scriptPath.replace("\\", "/") + "\"  \"" + filePath + "\"";
            Process process = runtime.exec(cmd);
            logger.info("Python Scrip Executed: " + cmd);
            InputStream inputStream = process.getInputStream();
            logger.info(this.getStringFromInputStream(inputStream));
            logger.debug(" =============== Script Execution Completed =============== ");
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
    }

    public String executePythonCmd(String script) {
        StringBuilder responseStr = new StringBuilder();
        try {
            String line;
            logger.info(" ===== Executing Python Script ====== ");
            String command = script;
            logger.debug(command);
            System.out.println(command);
            Process process = Runtime.getRuntime().exec(command);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                responseStr.append(line);
                logger.info(line);
            }
            reader.close();
            logger.info(" ==== python Script Execution Completed ===== ");
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
        return responseStr.toString();
    }

    public void executeBatchScript(String script) {
        try {
            String line;
            logger.debug(" =============== Executing Batch Script =============== ");
            String command = "cmd /c start \"dvsum bat script execution\" " + script;
            logger.info("executing: " + command);
            Process process = Runtime.getRuntime().exec(command);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                logger.info(line);
            }
            reader.close();
            logger.debug(" =============== Script Execution Completed =============== ");
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
    }

    private String getStringFromInputStream(InputStream is) {
        StringBuilder sb;
        block15: {
            BufferedReader br = null;
            sb = new StringBuilder();
            try {
                try {
                    String line;
                    br = new BufferedReader(new InputStreamReader(is));
                    while ((line = br.readLine()) != null) {
                        sb.append(line);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }
}

