/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.services;

import com.dvsum.logger.CustomLogger;
import com.dvsum.services.ScriptExecutionService;
import com.dvsum.util.FileUtil;
import com.dvsum.util.SelfSignedHttps;
import com.dvsum.util.TLSHttpsRequestor;
import com.dvsum.util.TimezoneUtil;
import com.dvsum.util.Util;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Component
@Service
public class SawsUpgradeService
implements Serializable {
    private static final CustomLogger logger = CustomLogger.getLogger(SawsUpgradeService.class);
    private static final long serialVersionUID = 7812080054505101951L;
    public static final String TEMP_SAWS_FILE = String.valueOf(System.getProperty("user.dir")) + "/webservice-temp.zip";
    private static final String BASE_DIR = System.getProperty("user.dir");
    @Autowired
    private ScriptExecutionService scriptExecutionService;
    @Value(value="${saws.env}")
    private String sawsEnvironment;
    @Value(value="${update.current.version}")
    private String updateCurrentSawsVersionURL;
    @Value(value="${schedule.saws.update}")
    private String scheduleSawsUpdateURL;
    @Value(value="${update.cdata.lib_status}")
    private String updateSAWSLibraryStatusUrl;
    @Value(value="${update.cdata.schedule_status}")
    private String scheduleCdataLibsUpdateURL;
    @Value(value="${delete.cdata.request}")
    private String deleteCdataRequestsOnServerUrl;
    @Value(value="${download.cdata.libs}")
    private String downloadNewCdataLibs;
    @Value(value="${get.latest.saws}")
    private String downloadSawsURL;
    @Value(value="${https.cert.type}")
    private String httpsHandShakeCert;
    @Value(value="${saws.version}")
    private String currentSawsVersion;
    @Value(value="${get.inmemory.props}")
    private String getInMemoryPropsUrl;

    @PostConstruct
    public void updateWebserviceVersion() throws JsonParseException, JsonMappingException, IOException {
        logger.info("webservice version: " + this.currentSawsVersion);
        System.out.println("webservice version: " + this.currentSawsVersion);
        this.updateCurrentVersionInWebappDB();
        this.getInMemoryProps();
        FileUtil.setConfigurationProperty("cdata.driver.update.planned", String.valueOf(this.updateSAWSLibraryStatus()));
    }

    public void scheduleSAWSUpdate() {
        String token = FileUtil.getAPIkey();
        if ("caSigned".equalsIgnoreCase(this.httpsHandShakeCert)) {
            TLSHttpsRequestor.executePost(this.scheduleSawsUpdateURL, Arrays.asList(token, this.currentSawsVersion), Arrays.asList("token", "sawsVersion"));
        } else {
            SelfSignedHttps.executePostRequest(this.scheduleSawsUpdateURL, Arrays.asList(token, this.currentSawsVersion), Arrays.asList("token", "sawsVersion"));
        }
    }

    public void scheduleCDataLibsUpdate(String status) {
        String token = FileUtil.getAPIkey();
        if ("caSigned".equalsIgnoreCase(this.httpsHandShakeCert)) {
            TLSHttpsRequestor.executePost(this.scheduleCdataLibsUpdateURL, Arrays.asList(token, status), Arrays.asList("token", "status"));
        } else {
            SelfSignedHttps.executePostRequest(this.scheduleCdataLibsUpdateURL, Arrays.asList(token, status), Arrays.asList("token", "status"));
        }
    }

    public void updateCurrentVersionInWebappDB() {
        String API_key = FileUtil.getAPIkey();
        logger.debug("updating version to ...." + this.currentSawsVersion);
        System.out.println("Updating SAWS Version in Web App DB...");
        logger.info("Updating SAWS Version in Web App DB...");
        String[] timezoneDetails = TimezoneUtil.getLocalTimeZone();
        TLSHttpsRequestor.executePostAndGetStatusCode(this.updateCurrentSawsVersionURL, Arrays.asList(this.currentSawsVersion, timezoneDetails[0], timezoneDetails[1]), Arrays.asList("version", "timezoneId", "timezoneOffset"), API_key);
    }

    public void upgradeSaws() {
        logger.info("upgradeSaws started");
        String result = "caSigned".equalsIgnoreCase(this.httpsHandShakeCert) ? TLSHttpsRequestor.downloadFile(this.downloadSawsURL, new Object[]{FileUtil.getAPIkey(), this.existingJarsList(), this.existingCDataJars()}, new Object[]{"token", "jars", "cdataJars"}) : SelfSignedHttps.downloadFileNew(this.downloadSawsURL, new Object[]{FileUtil.getAPIkey(), this.existingJarsList(), this.existingCDataJars()}, new Object[]{"token", "jars", "cdataJars"});
        logger.info("upgradeSaws ended restarting");
        if ("SUCCESS".equals(result)) {
            this.restartSaws();
        }
    }

    public boolean updateSAWSLibraryStatus() {
        return false;
    }

    public void getInMemoryProps() throws JsonParseException, JsonMappingException, IOException {
    }

    public void restartSaws() {
        logger.debug("restaring saws............");
        FileUtil.setSAWSMaintenaceFlagToTrue();
        SawsUpgradeService.executeCMD(SawsUpgradeService.getBatchExecCMD("saws_restart.bat"));
    }

    public void rebootSaws() {
        logger.info("executing saws reboot script ............");
        FileUtil.setSAWSMaintenaceFlagToTrue();
        this.runRebootSAWSScript();
    }

    public void runRebootSAWSScript() {
        logger.info(" executing reboot script ............ ");
        try {
            String port = FileUtil.getPropertyWithDefault("port", "8183");
            String rebootScriptPath = "\"" + BASE_DIR + "/saws_reboot.bat\" " + port;
            this.scriptExecutionService.executeBatchScript(rebootScriptPath);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
    }

    public String existingJarsList() {
        String currentWorkingDirectory = System.getProperty("user.dir");
        String libFolderName = this.sawsEnvironment.equalsIgnoreCase("Local") ? "/lib" : "/DvSum_lib";
        File folder = new File(String.valueOf(currentWorkingDirectory) + libFolderName);
        File[] listOfFiles = folder.listFiles();
        String fileNames = null;
        int i = 0;
        while (i < listOfFiles.length) {
            if (listOfFiles[i].isFile()) {
                fileNames = Util.isNullOrEmpty(fileNames) ? listOfFiles[i].getName() : String.valueOf(fileNames) + "," + listOfFiles[i].getName();
            }
            ++i;
        }
        return fileNames;
    }

    public static void check(double value) {
        String valStr = String.valueOf(value);
        String valDecimal = valStr.substring(valStr.indexOf(".") + 1, valStr.length());
        double valDouble = Double.parseDouble(valDecimal);
        if (valDouble == 0.0) {
            System.out.println(value);
        }
    }

    public static void stopProcessOn8183() {
        logger.debug("Stoping Service............");
        SawsUpgradeService.executeCMD(SawsUpgradeService.getBatchExecCMD("saws_upgrader.bat"));
    }

    public static void stopSAWSService() {
        logger.debug("unInstalling Service............");
        SawsUpgradeService.executeCMD(SawsUpgradeService.getBatchExecCMD("saws_service_uninstall.bat"));
    }

    public static void installSAWSService() {
        logger.debug("Installing Service............");
        SawsUpgradeService.executeCMD(SawsUpgradeService.getBatchExecCMD("saws_service_install.bat"));
    }

    public static void runBatchFile(String batchFileName) {
        logger.debug("Installing Service............");
        SawsUpgradeService.executeCMD(SawsUpgradeService.getBatchExecCMD(batchFileName));
    }

    public static String getBatchExecCMD(String batchScript) {
        String cmd = "cmd /c start  \"\" \"" + BASE_DIR + "\\" + batchScript + "\"";
        logger.info(cmd);
        return cmd;
    }

    public static void executeCMD(String cmd) {
        try {
            logger.info("Command: " + cmd);
            Process proc = Runtime.getRuntime().exec(cmd);
            int res = proc.waitFor();
            logger.info("process response: " + res);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error", e);
        }
    }

    public static void executeCMD(String[] cmd) {
        try {
            String error;
            logger.info("Command: " + Arrays.asList(cmd).stream().collect(Collectors.joining("")));
            Process proc = Runtime.getRuntime().exec(cmd);
            BufferedReader outputReader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String output = null;
            while ((output = outputReader.readLine()) != null) {
                System.out.println(output);
            }
            BufferedReader errorReader = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            while ((error = errorReader.readLine()) != null) {
                System.out.println(error);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isAdmin() {
        return true;
    }

    public void downloadNewCdataLibs() {
        FileUtil.setConfigurationProperty("cdata.driver.update.planned", "false");
        String result = "";
        logger.debug("downloadNewCdataLibs request");
        String string = result = "caSigned".equalsIgnoreCase(this.httpsHandShakeCert) ? TLSHttpsRequestor.downloadFile(this.downloadNewCdataLibs, new Object[]{FileUtil.getAPIkey()}, new Object[]{"token"}) : SelfSignedHttps.downloadFileNew(this.downloadNewCdataLibs, new Object[]{FileUtil.getAPIkey()}, new Object[]{"token"});
        if ("SUCCESS".equals(result)) {
            logger.debug("updated cdata libs downloaded");
            logger.debug("extracting cdata libs from zip");
            this.deleteCdataRequestsOnServer();
            logger.debug("updating server with updated status");
            this.restartSaws();
        }
    }

    public String deleteCdataRequestsOnServer() {
        String response = "caSigned".equalsIgnoreCase(this.httpsHandShakeCert) ? TLSHttpsRequestor.executePost(this.deleteCdataRequestsOnServerUrl, Arrays.asList(FileUtil.getAPIkey()), Arrays.asList("token")) : SelfSignedHttps.executePostRequest(this.deleteCdataRequestsOnServerUrl, Arrays.asList(FileUtil.getAPIkey()), Arrays.asList("token"));
        return response;
    }

    private String existingCDataJars() {
        try {
            String currentWorkingDirectory = System.getProperty("user.dir");
            String libFolderName = this.sawsEnvironment.equalsIgnoreCase("Local") ? "/lib" : "/DvSum_lib";
            File libsDir = new File(String.valueOf(currentWorkingDirectory) + libFolderName);
            File[] files = libsDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith("cdata.jdbc");
                }
            });
            if (files != null) {
                Arrays.sort(files, Comparator.comparingLong(File::lastModified).reversed());
            }
            return files != null ? Arrays.asList(files).stream().map(f -> f.getName()).collect(Collectors.joining(",")) : "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public void scheduleUpdateCDataLibs() {
        FileUtil.setConfigurationProperty("cdata.driver.update.planned", "true");
        this.scheduleCDataLibsUpdate("UPDP");
    }

    public static void executeCommandInCMD(String activeMQServiceInstallationPath) {
        String cmd = "cmd /c start  \"\" \"" + activeMQServiceInstallationPath + "\"";
        logger.info(cmd);
        SawsUpgradeService.executeCMD(cmd);
    }

    public static void executeDirectCommand(String cmd) {
        logger.info(cmd);
        SawsUpgradeService.executeCMD(cmd);
    }
}

