/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.services;

import com.dvsum.dataSource.DataSource;
import com.dvsum.dataSource.DatabricksNativeSource;
import com.dvsum.factory.DataSourceFactory;
import com.dvsum.logger.CustomLogger;
import com.dvsum.logger.LogFormat;
import com.dvsum.model.ref.RefDBType;
import com.dvsum.rule.BaseRule;
import com.dvsum.rule.CMMRule;
import com.dvsum.rule.Connector;
import com.dvsum.rule.FKRule;
import com.dvsum.rule.Node;
import com.dvsum.rule.NodeExecutionMetadata;
import com.dvsum.rule.ProfileNode;
import com.dvsum.rule.ProfileRule;
import com.dvsum.rule.Source;
import com.dvsum.services.ExecutorServiceHandler;
import com.dvsum.util.FileUtil;
import com.dvsum.util.JsonUtil;
import com.dvsum.util.SelfSignedHttps;
import com.dvsum.util.TLSHttpsRequestor;
import com.dvsum.util.Util;
import com.dvsum.websocket.ConnectionManager;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Service
@Component
public class RuleExecutionService {
    private static final CustomLogger logger = CustomLogger.getLogger(RuleExecutionService.class);
    @Value(value="${rules.details.api}")
    private String fetchRulesDetailURL;
    @Value(value="${get.ready_to_execute.jobs.ids.api}")
    private String getReadyToExecuteJobIdsURL;
    @Value(value="${execute.job.api}")
    private String executeJobURL;
    @Value(value="${check.execution.status.api}")
    private String checkExecutionStatusURL;
    @Value(value="${https.cert.type}")
    private String certType;

    @Async
    public String startExecution(JSONObject nodeExecutionMetadataJson) {
        long startTime = System.currentTimeMillis();
        logger.info("***************** Job Execution Started ********************");
        try {
            NodeExecutionMetadata nodeExecutionMetadata = new NodeExecutionMetadata(nodeExecutionMetadataJson);
            String API_KEY = FileUtil.getAPIkey();
            Integer poolSize = Integer.parseInt(FileUtil.getPropertyWithDefault("max.database.connection.allowed", "10"));
            ExecutorService executorService = Executors.newFixedThreadPool(poolSize);
            ExecutorServiceHandler.addExecutorService(nodeExecutionMetadata.getJobId(), executorService);
            for (Node node : nodeExecutionMetadata.getNodes()) {
                LogFormat logFormat = new LogFormat();
                logFormat.setLogFormat("rule", nodeExecutionMetadata.getJobId(), node.getSrcId());
                this.runSampleQueryIfDatabricksWarehouseCluster(nodeExecutionMetadata, node, logFormat);
                if (node instanceof ProfileNode) {
                    this.startProfileExecution(nodeExecutionMetadata, (ProfileNode)node, executorService, logFormat);
                    continue;
                }
                this.startRuleExecution(nodeExecutionMetadata, node, executorService, logFormat);
            }
            this.callCheckExecutionStatusApi(nodeExecutionMetadata, API_KEY, null);
            ExecutorServiceHandler.removeExecutorService(nodeExecutionMetadata.getJobId());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.info("***************** Job Execution Completed ********************");
        return "";
    }

    public void startProfileExecution(NodeExecutionMetadata nodeExecutionMetadata, ProfileNode node, ExecutorService executorService, LogFormat logFormat) {
        logger.info(logFormat.getFormattedLog(), "Execution started for table:", node.getTableName());
        ProfileRule profileRule = new ProfileRule(executorService, node, nodeExecutionMetadata.getSources(), nodeExecutionMetadata.getConnectorDetails().get(0), nodeExecutionMetadata.getExecutionId(), nodeExecutionMetadata.getS3PreSignedPostUrl(), logFormat);
        profileRule.executeQueries();
        logger.info(logFormat.getFormattedLog(), "Execution completed for table:", node.getTableName());
    }

    public void startRuleExecution(NodeExecutionMetadata nodeExecutionMetadata, Node node, ExecutorService executorService, LogFormat logFormat) {
        logger.info(logFormat.getFormattedLog(), "Execution started for Rule :", node.getRuleId());
        if (node.getIsSeqRequired().booleanValue()) {
            if (node.getRuleType().equalsIgnoreCase("CMM")) {
                logger.info("Executing CMM Rule", node.getRuleId());
                CMMRule cmmRule = new CMMRule(executorService, node, nodeExecutionMetadata.getSources(), nodeExecutionMetadata.getConnectorDetails().get(0), nodeExecutionMetadata.getExecutionId(), nodeExecutionMetadata.getS3PreSignedPostUrl(), logFormat);
                cmmRule.executeQueries();
            } else {
                logger.info("Executing FK Rule", node.getRuleId());
                FKRule fkRule = new FKRule(executorService, node, nodeExecutionMetadata.getSources(), nodeExecutionMetadata.getConnectorDetails().get(0), nodeExecutionMetadata.getExecutionId(), nodeExecutionMetadata.getS3PreSignedPostUrl(), logFormat);
                fkRule.executeQueries();
            }
        } else {
            logger.info("Executing Base Rule ", node.getRuleId());
            BaseRule baseRule = new BaseRule(executorService, node, nodeExecutionMetadata.getSources(), nodeExecutionMetadata.getConnectorDetails().get(0), nodeExecutionMetadata.getExecutionId(), nodeExecutionMetadata.getS3PreSignedPostUrl(), logFormat);
            baseRule.executeQueries();
        }
        logger.info(logFormat.getFormattedLog(), "Execution completed for Rule :", node.getRuleId());
    }

    public JSONObject getExecutionMetadataFromPayload(JSONObject websocketMessage) {
        JSONObject executionMetadata = new JSONObject();
        String contentType = String.valueOf(websocketMessage.get((Object)"type"));
        Object messageContent = websocketMessage.get((Object)"message");
        if (contentType.equalsIgnoreCase("JSON")) {
            executionMetadata = (JSONObject)messageContent;
        } else {
            String s3Url = String.valueOf(messageContent);
            String fileContent = TLSHttpsRequestor.downloadWithPresignedUrl(s3Url);
            try {
                executionMetadata = JsonUtil.parseToJsonObject(fileContent);
            }
            catch (ParseException e) {
                logger.error(e.getMessage());
                e.printStackTrace();
            }
        }
        return executionMetadata;
    }

    public JSONObject getExecutionMetadataFromS3(String url) {
        JSONObject executionMetadata = new JSONObject();
        try {
            String API_KEY = FileUtil.getAPIkey();
            String res = this.isCASignedCertConfigured(this.certType) ? TLSHttpsRequestor.executeGet(url, new Object[0], new Object[0], API_KEY) : SelfSignedHttps.executeGetRequest(url, new Object[0], new Object[0], API_KEY);
            executionMetadata = JsonUtil.parseToJsonObject(res);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            e.printStackTrace();
        }
        return executionMetadata;
    }

    public String getReadyToExecuteJobIds(String API_KEY) {
        if (Util.isNotNullOrEmpty(API_KEY)) {
            String resp = this.isCASignedCertConfigured(this.certType) ? TLSHttpsRequestor.executeGet(this.getReadyToExecuteJobIdsURL, new Object[0], new Object[0], API_KEY) : SelfSignedHttps.executeGetRequest(this.getReadyToExecuteJobIdsURL, new Object[0], new Object[0], API_KEY);
            return !Util.isNullOrEmpty(resp) && !resp.contains("error") ? resp : "";
        }
        logger.info("API Key is missing in configuration file");
        System.out.println("API Key is missing in configuration file");
        return null;
    }

    public JSONArray getJobIdsFromResponse(String jobIdsResponse) {
        JSONArray jobIds = new JSONArray();
        try {
            JSONObject jobIdsJson = JsonUtil.parseToJsonObject(jobIdsResponse);
            jobIds = jobIdsJson != null ? (JSONArray)jobIdsJson.get((Object)"job_ids") : new JSONArray();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jobIds;
    }

    private boolean isCASignedCertConfigured(String CertType) {
        return "caSigned".equalsIgnoreCase(CertType);
    }

    public JSONObject generateExecuteJobPayload(String jobId) {
        JSONObject payload = new JSONObject();
        payload.put((Object)"job_id", (Object)jobId);
        return payload;
    }

    public void executeJob(String jobId, String API_KEY) {
        logger.info("Executing job : ", jobId);
        String modifiedExecuteJobURL = this.executeJobURL.replace("{job_id}", jobId);
        String payload = this.generateExecuteJobPayload(jobId).toJSONString();
        LogFormat logFormat = new LogFormat();
        logFormat.setLogFormat("rule", "", jobId);
        TLSHttpsRequestor.executePost(modifiedExecuteJobURL, payload, API_KEY, logFormat);
    }

    public void executeAllJobs(JSONArray jobIds, String API_KEY) {
        for (Object jobId : jobIds) {
            this.executeJob(String.valueOf(jobId), API_KEY);
        }
    }

    public void callCheckExecutionStatusApi(NodeExecutionMetadata ruleExecMetadata, String API_KEY, LogFormat logFormat) {
        String modifiedCheckExecutionStatusURL = this.checkExecutionStatusURL.replace("{job_id}", ruleExecMetadata.getJobId());
        String payload = this.generateCheckExecutionStatusPayload(ruleExecMetadata, API_KEY).toJSONString();
        TLSHttpsRequestor.executePost(modifiedCheckExecutionStatusURL, payload, API_KEY, logFormat);
    }

    public JSONObject generateCheckExecutionStatusPayload(NodeExecutionMetadata ruleExecMetadata, String API_KEY) {
        JSONObject outputPayload = new JSONObject();
        outputPayload.put((Object)"job_id", (Object)ruleExecMetadata.getJobId());
        outputPayload.put((Object)"is_job_online", (Object)ruleExecMetadata.getIsJobOnline());
        outputPayload.put((Object)"x_api_key", (Object)API_KEY);
        JSONObject output = new JSONObject();
        output.put((Object)"Payload", (Object)outputPayload);
        JSONObject payload = new JSONObject();
        payload.put((Object)"taskToken", (Object)ruleExecMetadata.getTaskToken());
        payload.put((Object)"execution_id", (Object)ruleExecMetadata.getExecutionId());
        payload.put((Object)"output", (Object)output.toJSONString());
        return payload;
    }

    public void sendConnectionDetailsToWebsocket(JSONObject ruleExecutionMetadata) {
        JSONObject message = new JSONObject();
        message.put((Object)"job_id", (Object)String.valueOf(ruleExecutionMetadata.get((Object)"job_id")));
        JSONArray connectorDetailsArray = (JSONArray)ruleExecutionMetadata.get((Object)"connector_details");
        List<Connector> connectors = Connector.getConnectorsFromJson(connectorDetailsArray);
        message.put((Object)"connector_details", (Object)connectors.get(0).toJSON());
        JSONObject websocketMessage = new JSONObject();
        websocketMessage.put((Object)"context", (Object)"socketConnection");
        websocketMessage.put((Object)"source", (Object)"dvsumConnector");
        websocketMessage.put((Object)"type", (Object)"JSON");
        websocketMessage.put((Object)"message", (Object)message);
        logger.info("Sending websocket connection message: ", websocketMessage.toJSONString());
        ConnectionManager.sendWebsocketMessageWithRetry(websocketMessage);
    }

    private void runSampleQueryIfDatabricksWarehouseCluster(NodeExecutionMetadata nodeExecutionMetadata, Node node, LogFormat logFormat) {
        Source source = Source.findSourceById(node.getSrcId(), nodeExecutionMetadata.getSources());
        try {
            DataSourceFactory dataSourceFactory;
            DataSource dataSource;
            DatabricksNativeSource databricksSource;
            if (RefDBType.isNativeDatabricks(source.getSrcType()) && (databricksSource = (DatabricksNativeSource)(dataSource = (dataSourceFactory = new DataSourceFactory()).getDataSource(source.getSrcType(), source.getConnConfig(), false, logFormat))).isWarehousesExistsInHttpPath().booleanValue()) {
                databricksSource.connect();
                databricksSource.executeSampleQuery();
            }
        }
        catch (Exception e) {
            logger.error(logFormat.getFormattedLog(), "Error found while executing Sample query for SQL Warehouse to get started. Error = ", e.getMessage());
            e.printStackTrace();
        }
    }
}

