/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.services;

import com.dvsum.logger.CustomLogger;
import com.dvsum.logger.LogFormat;
import com.dvsum.services.ConfigPropertiesHelper;
import com.dvsum.util.FileUtil;
import com.dvsum.util.JsonUtil;
import com.dvsum.util.MultipartFileUploader;
import com.dvsum.util.TLSHttpsRequestor;
import com.dvsum.util.Util;
import com.dvsum.websocket.ConnectionManager;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class NetworkHealthChecker {
    private static final CustomLogger logger = CustomLogger.getLogger(NetworkHealthChecker.class);
    private static final int TOTAL_COUNT = 3;
    private String apiKey;
    private String jsonFileName = "network_health_check.json";

    public NetworkHealthChecker() {
        this.apiKey = FileUtil.getAPIkey();
    }

    public NetworkHealthChecker(String apiKey) {
        this.apiKey = apiKey;
        if (Util.isNullOrEmpty(this.apiKey)) {
            System.out.println("Getting API Key from configuration.properties...");
            this.apiKey = FileUtil.getAPIkey();
            this.apiKey = this.apiKey.trim();
        }
    }

    public boolean isApiKeyValid(String apiKey) {
        return true;
    }

    public boolean isDomainReachable(String domain) {
        try {
            int statusCode = TLSHttpsRequestor.executeGet(domain, this.apiKey);
            return this.isStatusCodeValid(statusCode);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isWebsocketReachable(String websocketUrl) {
        try {
            return ConnectionManager.checkConnection(websocketUrl, this.apiKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isS3Reachable(JSONObject s3PreSignedPostUrl) {
        try {
            String filePath = "./READ_ME.txt";
            int statusCode = MultipartFileUploader.uploadFileToS3AndGetStatus(filePath, s3PreSignedPostUrl, new LogFormat());
            logger.info("File uploader status code:", statusCode);
            return statusCode == 204;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isStatusCodeValid(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }

    public String getApiUrl() {
        return ConfigPropertiesHelper.getResolvedUrl("ping.check.api");
    }

    public String getWebsocketApiUrl() {
        return ConfigPropertiesHelper.getResolvedUrl("get.websocket.url");
    }

    public JSONObject getNetworkDetails() {
        JSONObject responseJson = new JSONObject();
        try {
            String response;
            String socketApiUrl = this.getWebsocketApiUrl();
            if (Util.isNotNullOrEmpty(socketApiUrl) && Util.isNotNullOrEmpty(response = TLSHttpsRequestor.executeGet(socketApiUrl, new Object[0], new Object[0], this.apiKey))) {
                responseJson = JsonUtil.parseToJsonObject(response);
            }
        }
        catch (Exception e) {
            logger.error("Error while getting network check info. Error:", e.getMessage());
            e.printStackTrace();
        }
        return responseJson;
    }

    public JSONObject getApiKeyResultJson(boolean isApiKeyValid) {
        JSONObject apiKeyResult = new JSONObject();
        apiKeyResult.put((Object)"type", (Object)"api_key");
        apiKeyResult.put((Object)"message", (Object)(isApiKeyValid ? "DvSum API key is valid." : "Please make sure your DvSum API key is accurate and active"));
        apiKeyResult.put((Object)"api_key", (Object)this.apiKey);
        apiKeyResult.put((Object)"is_valid", (Object)isApiKeyValid);
        return apiKeyResult;
    }

    public JSONObject checkNetworkStatus() {
        JSONArray urls = new JSONArray();
        int reachableCount = 0;
        JSONObject apiStatus = this.checkApiUrl(this.getApiUrl());
        urls.add((Object)apiStatus);
        reachableCount += this.updateReachableCount(apiStatus);
        JSONObject networkDetails = this.getNetworkDetails();
        String websocketUrl = String.valueOf(networkDetails.get((Object)"websocket_connection_url"));
        JSONObject wsStatus = this.checkWebSocketUrl(websocketUrl);
        urls.add((Object)wsStatus);
        reachableCount += this.updateReachableCount(wsStatus);
        JSONObject s3UrlInfo = (JSONObject)networkDetails.get((Object)"presigned_post_url_info");
        JSONObject s3Status = this.checkS3Url(s3UrlInfo);
        urls.add((Object)s3Status);
        boolean isApiKeyValid = Boolean.parseBoolean(String.valueOf(networkDetails.get((Object)"is_api_key_valid")));
        JSONObject apiKeyResult = this.getApiKeyResultJson(isApiKeyValid);
        urls.add((Object)apiKeyResult);
        return this.buildResponse(reachableCount += this.updateReachableCount(s3Status), urls);
    }

    private int updateReachableCount(JSONObject status) {
        return (Boolean)status.get((Object)"reachable") != false ? 1 : 0;
    }

    private JSONObject buildResponse(int reachableCount, JSONArray urls) {
        JSONObject response = new JSONObject();
        String overallMessage = this.formatOverallMessage(reachableCount);
        response.put((Object)"status", (Object)(reachableCount == 3 ? "success" : "failure"));
        response.put((Object)"timestamp", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        response.put((Object)"urls", (Object)urls);
        response.put((Object)"overall_message", (Object)overallMessage);
        return response;
    }

    private String formatOverallMessage(int reachableCount) {
        String message = String.format("%d out of %d URLs are reachable.", reachableCount, 3);
        if (reachableCount < 3) {
            message = String.valueOf(message) + " Please check the unreachable URLs.";
        }
        return message;
    }

    private JSONObject checkApiUrl(String url) {
        JSONObject apiResult = new JSONObject();
        apiResult.put((Object)"type", (Object)"api");
        apiResult.put((Object)"url", (Object)url);
        boolean reachable = this.isDomainReachable(url);
        apiResult.put((Object)"reachable", (Object)reachable);
        apiResult.put((Object)"message", (Object)(reachable ? "API URL is reachable." : "Unable to connect to the API. Please verify your network settings allow outbound access to DvSum APIs"));
        return apiResult;
    }

    private JSONObject checkS3Url(JSONObject preSignedPostUrl) {
        JSONObject s3Result = new JSONObject();
        try {
            s3Result.put((Object)"type", (Object)"s3");
            s3Result.put((Object)"url", preSignedPostUrl != null ? preSignedPostUrl.get((Object)"url") : "");
            boolean reachable = preSignedPostUrl != null ? this.isS3Reachable(preSignedPostUrl) : false;
            s3Result.put((Object)"reachable", (Object)reachable);
            s3Result.put((Object)"message", (Object)(reachable ? "S3 URL is reachable. Upload successful." : "S3 URL is not reachable. Connection timed out."));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return s3Result;
    }

    private JSONObject checkWebSocketUrl(String url) {
        JSONObject wsResult = new JSONObject();
        wsResult.put((Object)"type", (Object)"websocket");
        wsResult.put((Object)"url", (Object)url);
        boolean reachable = this.isWebsocketReachable(url);
        wsResult.put((Object)"reachable", (Object)reachable);
        wsResult.put((Object)"message", (Object)(reachable ? "WebSocket URL is reachable. Connection established successfully." : "WebSocket URL is not reachable. Connection failed."));
        return wsResult;
    }

    public String formatOutput(JSONObject json) {
        if (json == null) {
            return "Error: Input JSON is null";
        }
        StringBuilder output = new StringBuilder();
        output.append("Network Reachability Report\n");
        output.append("====================================\n\n");
        String status = this.getStringValue(json, "status", "N/A");
        String timestamp = this.getStringValue(json, "timestamp", "N/A");
        String overallMessage = this.getStringValue(json, "overall_message", "N/A");
        output.append("Status: ").append(status).append("\n");
        output.append("Timestamp: ").append(timestamp).append("\n");
        JSONArray urls = (JSONArray)json.get((Object)"urls");
        if (urls != null && !"success".equalsIgnoreCase(status)) {
            output.append("Details:\n");
            output.append("--------\n\n");
            int i = 0;
            while (i < urls.size()) {
                Object urlObj = urls.get(i);
                if (urlObj instanceof JSONObject) {
                    JSONObject url = (JSONObject)urlObj;
                    String urlType = this.getStringValue(url, "type", "Unknown").toUpperCase();
                    String urlAddress = this.getStringValue(url, "url", null);
                    boolean reachable = this.getBooleanValue(url, "reachable");
                    String message = this.getStringValue(url, "message", "N/A");
                    output.append(i + 1).append(". ").append(urlType).append(" URL");
                    if (!Util.isNullOrEmpty(urlAddress)) {
                        output.append(" (").append(urlAddress).append(")");
                    } else {
                        output.append(": Could not get the ");
                        if ("WEBSOCKET".equalsIgnoreCase(urlType)) {
                            output.append("WebSocket URL");
                        } else if ("S3".equalsIgnoreCase(urlType)) {
                            output.append("S3 URL to test connectivity");
                        } else {
                            output.append("URL");
                        }
                    }
                    output.append(":\n");
                    output.append("   ").append(reachable ? "Reachable" : "Not Reachable").append("\n");
                    output.append("   Message: ").append(message).append("\n");
                    if (!reachable) {
                        if ("WEBSOCKET".equalsIgnoreCase(urlType)) {
                            output.append("   Action: Check your network for outbound access to DvSum APIs.\n");
                        } else if ("S3".equalsIgnoreCase(urlType)) {
                            output.append("   Action: Check your network for outbound access to DvSum S3 buckets.\n");
                        }
                    }
                    output.append("\n");
                }
                ++i;
            }
        }
        if ("success".equalsIgnoreCase(status)) {
            output.append("Network check successful: DvSum connectivity confirmed.\n");
            output.append("All DvSum endpoints are reachable.\n");
        } else {
            output.append("WARNING: Some URLs are not reachable. Please review the above details.\n\n");
            output.append("Action Required:\n");
            output.append("1. Contact your network administrator.\n");
            output.append("2. Ensure outbound access is allowed for the unreachable URLs.\n");
            output.append("3. Verify DNS settings and firewall rules.\n");
            output.append("4. Once issues are resolved, run this check again.\n");
        }
        return output.toString();
    }

    private String getStringValue(JSONObject json, String key, String defaultValue) {
        Object value = json.get((Object)key);
        return value != null ? value.toString() : defaultValue;
    }

    private boolean getBooleanValue(JSONObject json, String key) {
        Object value = json.get((Object)key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        return false;
    }

    public static void main(String[] args) {
        System.out.println("Checking Network Health...");
        NetworkHealthChecker networkService = new NetworkHealthChecker();
        if (args.length > 0) {
            networkService.jsonFileName = args[0];
        }
        try {
            JSONObject networkStatus = networkService.checkNetworkStatus();
            logger.info("Network health status:", networkStatus.toJSONString());
            FileUtil.writeToFile(networkService.jsonFileName, networkService.formatOutput(networkStatus));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

