/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.services;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class ConfigPropertiesHelper {
    private static final Properties properties = new Properties();

    static {
        ConfigPropertiesHelper.loadProperties();
    }

    public static void main(String[] args) {
        System.out.println(ConfigPropertiesHelper.getResolvedUrl("get.websocket.url"));
    }

    public static void loadProperties() {
        try {
            Throwable throwable = null;
            Object var1_3 = null;
            try (InputStream input = ConfigPropertiesHelper.class.getClassLoader().getResourceAsStream("polling-urls.properties");){
                if (input == null) {
                    System.out.println("Sorry, unable to find polling-urls.properties");
                    return;
                }
                properties.load(input);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static String getProperty(String key) {
        return properties.getProperty(key);
    }

    public static String getResolvedUrl(String key) {
        String baseUrl = ConfigPropertiesHelper.getProperty("base.url");
        String propertyUrl = ConfigPropertiesHelper.getProperty(key);
        if (propertyUrl != null && baseUrl != null) {
            return propertyUrl.replace("${base.url}", baseUrl);
        }
        return null;
    }
}

