/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.services;

import com.dvsum.logger.CustomLogger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class AnalyticsService {
    private static final CustomLogger logger = CustomLogger.getLogger(AnalyticsService.class);

    public ResponseEntity getZippedFileContent(String filePath) {
        ResponseEntity response;
        logger.debug("GetFileContent called");
        logger.debug("File path = " + filePath);
        filePath = filePath.trim();
        try {
            File file = new File(filePath);
            if (!file.exists()) {
                logger.error("File doesn't exist for File Path = " + filePath);
                return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).build();
            }
            byte[] dataInBytes = FileUtils.readFileToByteArray((File)file);
            String zipFilePath = filePath;
            byte[] zippedData = this.compressAndZip(dataInBytes, zipFilePath);
            HttpHeaders headers = new HttpHeaders();
            headers.add("Content-Type", "application/zip");
            headers.add("Content-Disposition", "attachment; filename=" + zipFilePath);
            response = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)zippedData);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while getting JSON file content. Error = " + e.getLocalizedMessage());
            response = ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
        return response;
    }

    public boolean isValidJsonPath(String filePath) {
        return filePath.trim().endsWith(".json");
    }

    public String replaceExtensionWithZip(String filePath) {
        return filePath.substring(0, filePath.lastIndexOf(".")).concat(".zip");
    }

    private byte[] compressAndZip(byte[] data, String filePath) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Throwable throwable = null;
        Object var5_6 = null;
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);){
            ZipEntry zipEntry = new ZipEntry(filePath);
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(data);
            zipOutputStream.closeEntry();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return byteArrayOutputStream.toByteArray();
    }
}

