/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.schedule;

import com.dvsum.logger.CustomLogger;
import com.dvsum.util.DateUtil;
import com.dvsum.util.FileUtil;
import com.dvsum.util.LogReadResult;
import com.dvsum.util.Util;
import com.dvsum.websocket.ConnectionManager;
import java.util.List;
import org.json.simple.JSONObject;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class WebsocketSAWSLogger {
    private static final CustomLogger logger = CustomLogger.getLogger(WebsocketSAWSLogger.class);
    private final String basePath = "./logs/";
    private String logFilePath = null;
    private String metadataFilePath = null;
    private static final int WEBSOCKET_BYTES_MAX_LIMIT = 30000;

    @Scheduled(fixedDelay=15000L, initialDelay=15000L)
    public void sendLogsToWebsocket() {
        this.logFilePath = "./logs/" + String.valueOf(FileUtil.getPropertyWithDefault("logFilePath", "SAWS.log"));
        this.metadataFilePath = "./logs/" + String.valueOf(FileUtil.getPropertyWithDefault("logSyncMetadataFilePath", "log_sync_metadata.json"));
        int bytesSent = this.getBytesSentFromMetadataFile(this.metadataFilePath);
        LogReadResult logReadResult = FileUtil.readBytesFromFile(this.logFilePath, bytesSent);
        bytesSent = logReadResult.getBytesSent(bytesSent);
        this.updateLogSyncMetadataFile(bytesSent);
        List<String> logBatches = Util.splitStringIntoBatches(logReadResult.getContent(), 30000);
        int totalBatches = logBatches.size();
        if (totalBatches > 1) {
            logger.info("Websocket maximum byte limit reached. Sending logs in ", totalBatches, " batches.");
        }
        for (String batch : logBatches) {
            JSONObject websocketMessage = this.buildWebsocketPayload(batch);
            logger.info("Sending Logs To Websocket.");
            ConnectionManager.sendWebsocketMessageWithRetry(websocketMessage);
        }
    }

    private JSONObject buildWebsocketPayload(String logs) {
        JSONObject messageObject = new JSONObject();
        messageObject.put((Object)"logs", (Object)logs);
        JSONObject websocketMessage = new JSONObject();
        websocketMessage.put((Object)"action", (Object)"sendMessage");
        websocketMessage.put((Object)"source", (Object)"dvsumConnector");
        websocketMessage.put((Object)"context", (Object)"logSync");
        websocketMessage.put((Object)"message", (Object)messageObject);
        return websocketMessage;
    }

    private JSONObject getLogSyncMetadataJSONObject(int bytesSent) {
        JSONObject logSyncMetadataJSON = new JSONObject();
        logSyncMetadataJSON.put((Object)"bytes_sent", (Object)bytesSent);
        logSyncMetadataJSON.put((Object)"datetime_sent", (Object)DateUtil.getFormattedCurrentDateTime("yyyyMMddHHmmss"));
        return logSyncMetadataJSON;
    }

    private void updateLogSyncMetadataFile(int bytesSent) {
        JSONObject logSyncMetadataJSONObject = this.getLogSyncMetadataJSONObject(bytesSent);
        FileUtil.writeJsonToFile(this.metadataFilePath, logSyncMetadataJSONObject);
    }

    private int getBytesSentFromMetadataFile(String filePath) {
        int bytesSent = 0;
        try {
            if (FileUtil.fileExists(this.metadataFilePath)) {
                JSONObject logSyncMetadata = FileUtil.readFileAsJsonObject(this.metadataFilePath);
                if (!logSyncMetadata.isEmpty()) {
                    bytesSent = Integer.valueOf(String.valueOf(logSyncMetadata.get((Object)"bytes_sent")));
                }
            } else {
                logger.info("log_sync_metadata.json file doesn't exist. Creating...");
            }
        }
        catch (Exception e) {
            logger.error("Error while getting 'bytes_sent' from log metadata file.", e.getMessage());
            e.printStackTrace();
        }
        return bytesSent;
    }
}

