/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.schedule;

import com.dvsum.logger.CustomLogger;
import com.dvsum.schedule.S3BucketLogTask;
import com.dvsum.util.FileUtil;
import com.dvsum.util.Util;
import java.io.File;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class S3SAWSLogger {
    private S3BucketLogTask s3BucketLogTask;
    private static final CustomLogger logger = CustomLogger.getLogger(S3SAWSLogger.class);

    public S3SAWSLogger(S3BucketLogTask s3BucketLogTask) {
        this.s3BucketLogTask = s3BucketLogTask;
    }

    @Async(value="jobExecutor")
    @Scheduled(fixedDelay=60000L, initialDelay=60000L)
    public void schedule() {
    }

    public void runExternal(File file) {
        try {
            this.s3BucketLogTask.run(file);
        }
        catch (Exception e) {
            logger.error("AWS Log sync error:", e);
        }
    }

    public boolean isAWSLogSyncEnabled() {
        String logSyncEnabled = FileUtil.getPropertyWithDefault("enable.log.sync", "false");
        return !Util.isNotNullOrEmpty(logSyncEnabled) || !"false".equalsIgnoreCase(logSyncEnabled.trim()) && !"no".equalsIgnoreCase(logSyncEnabled.trim());
    }
}

