/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.schedule;

import com.dvsum.initializer.EmbeddedJetty;
import com.dvsum.logger.CustomLogger;
import com.dvsum.util.DateUtil;
import com.dvsum.util.FileUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class RebootScheduler {
    private static final CustomLogger logger = CustomLogger.getLogger(RebootScheduler.class);

    @Scheduled(fixedDelay=30000L, initialDelay=120000L)
    public void schedule() {
        this.scheduleReboot();
    }

    private void scheduleReboot() {
        try {
            if (this.isRebootTime()) {
                EmbeddedJetty.SCHEDULE_REBOOT = true;
            }
        }
        catch (Exception e) {
            logger.error("Exception", e);
        }
    }

    private boolean isRebootTime() throws Exception {
        String rebootTimeStr = FileUtil.getPropertyWithDefault("reboot.time", "01:00");
        SimpleDateFormat parser = new SimpleDateFormat("HH:mm");
        Date rebootTime = parser.parse(rebootTimeStr);
        Date currentTim = parser.parse(DateUtil.getCurrentTimeInTwentyFourHourFormate());
        return currentTim.equals(rebootTime);
    }
}

