/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.schedule;

import com.dvsum.initializer.EmbeddedJetty;
import com.dvsum.logger.CustomLogger;
import com.dvsum.services.ExecutorServiceHandler;
import com.dvsum.services.RuleExecutionService;
import com.dvsum.services.SawsUpgradeService;
import com.dvsum.services.ScanSourceService;
import com.dvsum.util.FileUtil;
import com.dvsum.util.SelfSignedHttps;
import com.dvsum.util.StatusUtil;
import com.dvsum.util.TLSHttpsRequestor;
import com.dvsum.util.Util;
import java.util.concurrent.ExecutorService;
import org.json.simple.JSONArray;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class JobExecutorService {
    private static final CustomLogger logger = CustomLogger.getLogger(JobExecutorService.class);
    @Autowired
    private SawsUpgradeService sawsUpgradeService;
    @Autowired
    private ScanSourceService scanExecutionService;
    @Autowired
    private RuleExecutionService ruleExecutionService;
    @Value(value="${get.job.ids.api}")
    private String URL;
    @Value(value="${https.cert.type}")
    private String httpsCertType;
    @Value(value="${api.key}")
    private String API_KEY;

    @Async(value="jobExecutor")
    @Scheduled(fixedDelay=60000L)
    public void getScheduledJobs() {
        try {
            logger.info(" Running job poller ... ");
            String API_KEY = FileUtil.getAPIkey();
            String isCloudSAWS = FileUtil.getPropertyWithDefault("is.cloud.saws", "false");
            if (Util.isNullOrEmpty(isCloudSAWS) || !"true".equalsIgnoreCase(isCloudSAWS)) {
                String jobIds = this.scanExecutionService.getScanJobs(API_KEY);
                logger.info("JobIds: " + jobIds);
                this.excuteJobs(jobIds);
            } else {
                String jobId = System.getenv("JOB_ID");
                logger.info("Job Id passed is : " + jobId);
                logger.info("Executing job for cloud saws.");
                String isJobRunning = System.getProperty("IsJobRunning");
                logger.info("Is job running :" + isJobRunning);
                if (Util.isNullOrEmpty(isJobRunning) && Util.isNotNullOrEmpty(jobId)) {
                    this.excuteJobs(jobId);
                    System.setProperty("IsJobRunning", "true");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Async(value="jobExecutor")
    @Scheduled(fixedDelay=60000L)
    public void getScheduledJobsNew() {
        try {
            logger.info(" Running job poller new... ");
            String API_KEY = FileUtil.getAPIkey();
            String isCloudSAWS = FileUtil.getPropertyWithDefault("is.cloud.saws", "false");
            if (Util.isNullOrEmpty(isCloudSAWS) || !"true".equalsIgnoreCase(isCloudSAWS)) {
                String jobIdsResp = this.ruleExecutionService.getReadyToExecuteJobIds(API_KEY);
                JSONArray jobIds = this.ruleExecutionService.getJobIdsFromResponse(jobIdsResp);
                logger.info("JobIds: " + jobIds.toJSONString());
                this.ruleExecutionService.executeAllJobs(jobIds, API_KEY);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void excuteJobs(String jobIds) {
        try {
            logger.info("Executing Jobs: " + jobIds);
            if (Util.isNotNullOrEmpty(jobIds) && !"\"\"".equals(jobIds)) {
                String[] jobIds_array;
                String[] stringArray = jobIds_array = jobIds.split(",");
                int n = jobIds_array.length;
                int n2 = 0;
                while (n2 < n) {
                    String jobId = stringArray[n2];
                    if (Util.isNotNullOrEmpty(jobId)) {
                        this.API_KEY = FileUtil.getAPIkey();
                        jobId = jobId.replace("\"", "");
                        ExecutorService executorService = ExecutorServiceHandler.createExecutorService(jobId);
                        this.scanExecutionService.executeScanJob(jobId, this.API_KEY, executorService);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getScanJobs(String API_KEY) {
        return this.isCASignedCertConfigured(this.httpsCertType) ? TLSHttpsRequestor.executeGet(this.URL, new Object[]{API_KEY, "default"}, new Object[]{"API_KEY", "Authorization"}, API_KEY) : SelfSignedHttps.executeGetRequest(this.URL, new Object[]{API_KEY}, new Object[]{"API_KEY"}, API_KEY);
    }

    private boolean isCASignedCertConfigured(String CertType) {
        return "caSigned".equalsIgnoreCase(CertType);
    }

    private boolean isValidJob(String jobIds) {
        return Util.isNotNullOrEmpty(jobIds) && !this.isErrorResp(jobIds);
    }

    private boolean sawsCdataUpdateScheduledAndItisIdle() {
        return this.isCdataUpdateScheduled() && !StatusUtil.isSawsBusy();
    }

    private boolean sawsUpdateScheduledAndItisIdle() {
        return this.isUpdateScheduled() && !StatusUtil.isSawsBusy();
    }

    private boolean sawsRebootScheduledAndItisIdle() {
        return this.isRebootScheduled() && !StatusUtil.isSawsBusy();
    }

    private boolean isCdataUpdateScheduled() {
        return Boolean.valueOf(FileUtil.getPropertyWithDefault("cdata.driver.update.planned", "false"));
    }

    private boolean isUpdateScheduled() {
        return EmbeddedJetty.SCHEDULE_UPDATE;
    }

    private boolean isRebootScheduled() {
        return EmbeddedJetty.SCHEDULE_REBOOT;
    }

    private boolean isErrorResp(String resp) {
        return Util.isNotNullOrEmpty(resp) && resp.contains("error");
    }
}

