/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.schedule;

import com.dvsum.logger.CustomLogger;
import com.dvsum.services.DataRetentionManagerService;
import com.dvsum.util.FileUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class DataRetentionPolicyExecutor {
    private static final CustomLogger logger = CustomLogger.getLogger(DataRetentionPolicyExecutor.class);
    @Autowired
    DataRetentionManagerService dataRetentionManagerService;
    String[] directoriesToClean = new String[]{"./scan_output", "./data_analysis"};

    @Scheduled(cron="0 0 0 * * *")
    public void schedule() {
        if (this.isDataRetentionEnabled()) {
            logger.info("data retention policy is enabled");
            String[] stringArray = this.directoriesToClean;
            int n = this.directoriesToClean.length;
            int n2 = 0;
            while (n2 < n) {
                String rootDirectoryPath = stringArray[n2];
                int retentionPeriodInDays = this.readDataRetentionPeriodInDays();
                this.dataRetentionManagerService.deleteImmediateSubdirectoriesOlderThan(rootDirectoryPath, retentionPeriodInDays);
                ++n2;
            }
        }
    }

    public int readDataRetentionPeriodInDays() {
        try {
            String retentionPeriodStr = FileUtil.getProperty("dataRetentionPeriodInDays");
            if (retentionPeriodStr != null) {
                return Integer.parseInt(retentionPeriodStr);
            }
        }
        catch (Exception e) {
            logger.error("Invalid value for dataRetentionPeriodInDays. Using default value (30).");
        }
        return 30;
    }

    public boolean isDataRetentionEnabled() {
        try {
            String retentionEnabledStr = FileUtil.getProperty("dataRetentionPolicyEnabled");
            if (retentionEnabledStr != null) {
                return Boolean.parseBoolean(retentionEnabledStr);
            }
        }
        catch (Exception e) {
            logger.error("Invalid value for dataRetentionEnabled. Using default value (false).", e);
        }
        return false;
    }
}

