/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.rule;

import com.dvsum.logger.CustomLogger;
import com.dvsum.model.ref.RefQueryType;
import com.dvsum.rule.ColumnDetail;
import com.dvsum.rule.ProfileQueries;
import com.dvsum.util.DateUtil;
import com.dvsum.util.Util;
import java.util.List;
import net.snowflake.client.jdbc.internal.amazonaws.util.CollectionUtils;
import org.json.simple.JSONObject;

public class TemplateQueries {
    private ProfileQueries profileQueries;
    private String sampleQuery;
    private String baseTableProfile;
    private static final CustomLogger logger = CustomLogger.getLogger(TemplateQueries.class);

    public TemplateQueries(ProfileQueries profileQueries, String sampleQuery, String baseTableProfile) {
        this.profileQueries = profileQueries;
        this.sampleQuery = sampleQuery;
        this.baseTableProfile = baseTableProfile;
    }

    public TemplateQueries(JSONObject templateQueries) {
        JSONObject profileJson = (JSONObject)templateQueries.get((Object)"profile");
        this.profileQueries = new ProfileQueries(profileJson);
        this.sampleQuery = String.valueOf(templateQueries.get((Object)"sample_query"));
        this.baseTableProfile = String.valueOf(templateQueries.get((Object)"base_table_profile"));
    }

    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put((Object)"profile", (Object)this.profileQueries.toJSON());
        json.put((Object)"sample_query", (Object)this.sampleQuery);
        json.put((Object)"base_table_profile", (Object)this.baseTableProfile);
        return json;
    }

    public static String getUpdatedQuery(String query, String tableName, String colName, List<ColumnDetail> columns) {
        if (colName != null) {
            if (colName.equals("*") && !CollectionUtils.isNullOrEmpty(columns)) {
                StringBuilder columnNames = new StringBuilder();
                for (ColumnDetail column : columns) {
                    if (column.getIsColumnMasked().booleanValue()) {
                        columnNames.append("'XXX' as " + column.getColName() + ",");
                        continue;
                    }
                    columnNames.append(String.valueOf(column.getColName()) + ",");
                }
                columnNames.deleteCharAt(columnNames.length() - 1);
                query = query.replace("$COLNAMES$", columnNames.toString());
                query = query.replace("$CHANGEME$", colName);
            } else {
                query = query.replace("$CHANGEME$", colName);
                query = query.replace("$COLNAMES$", colName);
            }
        }
        if (tableName != null) {
            query = query.replace("$CHANGEMETABLE$", tableName);
        }
        return query;
    }

    public static String getUpdatedHistogramQuery(Object query, String queryType, String tableName, String colName, String minValue, String maxValue) {
        String updatedQuery = String.valueOf(query);
        if (Util.isNullOrEmpty(updatedQuery)) {
            return "";
        }
        if (RefQueryType.isDateProfileQuery(queryType) && Util.isNotNullOrEmpty(maxValue) && Util.isNotNullOrEmpty(minValue)) {
            updatedQuery = TemplateQueries.getHistogramDateColumnQuery(query, minValue, maxValue, colName, tableName);
        } else if (Util.isNotNullOrEmpty(maxValue) && Util.isNotNullOrEmpty(minValue) && !minValue.equalsIgnoreCase(maxValue)) {
            Double vInterval = 1.0;
            vInterval = Double.valueOf(maxValue) - Double.valueOf(minValue);
            double vRoundFactor = Math.pow(10.0, Math.floor(Math.log10(vInterval)) - 1.0);
            double vRoundInterval = Math.ceil(vInterval / 20.0 / vRoundFactor) * vRoundFactor;
            double vRoundMinValue = Math.floor(Double.valueOf(minValue) / vRoundInterval) * vRoundInterval;
            updatedQuery = updatedQuery.replaceAll("\\$CHANGEME\\$", colName).replaceAll("\\$CHANGEMETABLE\\$", tableName);
            updatedQuery = updatedQuery.replaceAll("\\$CHANGEMEMINVAL\\$", minValue).replaceAll("\\$CHANGEMEMAXVAL\\$", maxValue);
            updatedQuery = updatedQuery.replaceAll("\\$CHANGEMEINTERVAL\\$", String.valueOf(vInterval));
            updatedQuery = updatedQuery.replaceAll("\\$CHANGEMEBUCKETS\\$", "10");
            updatedQuery = updatedQuery.replaceAll("\\$CHANGEMEROUNDMINVAL\\$", String.valueOf(vRoundMinValue));
            updatedQuery = updatedQuery.replaceAll("\\$CHANGEMEROUNDINTERVAL\\$", String.valueOf(vRoundInterval));
        } else {
            updatedQuery = "";
        }
        return updatedQuery;
    }

    public static String getHistogramDateColumnQuery(Object histoGramQuery, String min_value, String max_value, String colName, String tableName) {
        long diffInDays = DateUtil.getDifferenceDays(min_value, max_value);
        String updatedHistogramQuery = String.valueOf(histoGramQuery);
        if (histoGramQuery instanceof JSONObject) {
            JSONObject histogramQueryJson = (JSONObject)histoGramQuery;
            if (min_value.equalsIgnoreCase(max_value)) {
                updatedHistogramQuery = String.valueOf(histogramQueryJson.get((Object)"HLY"));
            }
            if (1L <= diffInDays && diffInDays <= 30L) {
                updatedHistogramQuery = String.valueOf(histogramQueryJson.get((Object)"DLY"));
            }
            if (30L < diffInDays && diffInDays <= 60L) {
                updatedHistogramQuery = String.valueOf(histogramQueryJson.get((Object)"WLY"));
            }
            if (60L < diffInDays && diffInDays <= 730L) {
                updatedHistogramQuery = String.valueOf(histogramQueryJson.get((Object)"MLY"));
            }
            if (730L < diffInDays && diffInDays <= 1460L) {
                updatedHistogramQuery = String.valueOf(histogramQueryJson.get((Object)"QLY"));
            }
            if (1460L < diffInDays) {
                updatedHistogramQuery = String.valueOf(histogramQueryJson.get((Object)"YLY"));
            }
            updatedHistogramQuery = updatedHistogramQuery.replaceAll("\\$CHANGEME\\$", colName).replaceAll("\\$CHANGEMETABLE\\$", tableName);
        } else if (!min_value.equalsIgnoreCase(max_value)) {
            long CHANGEMEINTERVAL = 1L;
            CHANGEMEINTERVAL = diffInDays / 10L;
            updatedHistogramQuery = updatedHistogramQuery.replaceAll("\\$CHANGEME\\$", colName).replaceAll("\\$CHANGEMETABLE\\$", tableName);
            updatedHistogramQuery = updatedHistogramQuery.replaceAll("\\$CHANGEMEMINVAL\\$", min_value).replaceAll("\\$CHANGEMEMAXVAL\\$", max_value);
            updatedHistogramQuery = updatedHistogramQuery.replaceAll("\\$CHANGEMEINTERVAL\\$", String.valueOf(CHANGEMEINTERVAL));
            updatedHistogramQuery = updatedHistogramQuery.replaceAll("\\$CHANGEMEBUCKETS\\$", "10");
        }
        return updatedHistogramQuery;
    }

    public ProfileQueries getProfileQueries() {
        return this.profileQueries;
    }

    public void setProfileQueries(ProfileQueries profileQueries) {
        this.profileQueries = profileQueries;
    }

    public String getSampleQuery() {
        return this.sampleQuery;
    }

    public void setSampleQuery(String sampleQuery) {
        this.sampleQuery = sampleQuery;
    }

    public String getBaseTableProfile() {
        return this.baseTableProfile;
    }

    public void setBaseTableProfile(String baseTableProfile) {
        this.baseTableProfile = baseTableProfile;
    }
}

