/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.rule;

import com.dvsum.logger.CustomLogger;
import com.dvsum.model.ref.RefDBType;
import com.dvsum.util.Util;
import java.util.ArrayList;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class Source {
    private static final CustomLogger logger = CustomLogger.getLogger(Source.class);
    private String srcId;
    private String srcType;
    private JSONObject connConfig;
    private String connectorId;
    private Boolean isCdataSrc;

    public Source(String srcId, String srcType, JSONObject connConfig, String connectorId, Boolean isCdataSrc) {
        this.srcId = srcId;
        this.srcType = srcType;
        this.connConfig = connConfig;
        this.connectorId = connectorId;
        this.isCdataSrc = isCdataSrc;
        if (RefDBType.isDatabricks(srcType) && (!"AzureServicePrincipal".equalsIgnoreCase(String.valueOf(connConfig.get((Object)"AuthScheme"))) || connConfig.containsKey((Object)"OAuthSecret") && Util.isNotNullOrEmpty(String.valueOf(connConfig.get((Object)"OAuthSecret"))))) {
            this.srcType = "DBN";
        }
    }

    public JSONObject getConnConfig() {
        return this.connConfig;
    }

    public void setConnConfig(JSONObject connConfig) {
        this.connConfig = connConfig;
    }

    public String getSrcId() {
        return this.srcId;
    }

    public void setSrcId(String srcId) {
        this.srcId = srcId;
    }

    public String getSrcType() {
        return this.srcType;
    }

    public void setSrcType(String srcType) {
        this.srcType = srcType;
    }

    public String getConnectorId() {
        return this.connectorId;
    }

    public void setConnectorId(String connectorId) {
        this.connectorId = connectorId;
    }

    public Boolean getIsCdataSrc() {
        return this.isCdataSrc;
    }

    public void setIsCdataSrc(Boolean isCdataSrc) {
        this.isCdataSrc = isCdataSrc;
    }

    public static List<Source> getSourcesFromJson(JSONArray sourcesJson) {
        ArrayList<Source> sources = new ArrayList<Source>();
        for (Object sourceObj : sourcesJson) {
            JSONObject sourceDetails = (JSONObject)sourceObj;
            long srcId = (Long)sourceDetails.get((Object)"src_id");
            String srcType = (String)sourceDetails.get((Object)"src_type");
            JSONObject connConfig = (JSONObject)sourceDetails.get((Object)"conn_config");
            int connectorId = ((Long)sourceDetails.get((Object)"connector_id")).intValue();
            Boolean isCdataSrc = sourceDetails.get((Object)"is_cdata_src") != null ? Boolean.valueOf(String.valueOf(sourceDetails.get((Object)"is_cdata_src"))) : null;
            Source source = new Source(String.valueOf(srcId), srcType, connConfig, String.valueOf(connectorId), isCdataSrc);
            sources.add(source);
        }
        return sources;
    }

    public static Source findSourceById(String srcId, List<Source> sources) {
        for (Source source : sources) {
            if (!source.getSrcId().equals(srcId)) continue;
            return source;
        }
        logger.info("Source Id doesn't exist in list of sources.");
        return null;
    }

    public JSONObject getConnConfigForQueryExecutor(String queryId, String queryType, String query) {
        JSONObject modifiedConnConfig = (JSONObject)this.connConfig.clone();
        modifiedConnConfig.put((Object)"source_type", (Object)this.srcType);
        modifiedConnConfig.put((Object)"runQuery", (Object)query);
        modifiedConnConfig.put((Object)"queryType", (Object)queryType);
        modifiedConnConfig.put((Object)"is_cdata_src", (Object)this.isCdataSrc);
        modifiedConnConfig.put((Object)"queryId", (Object)queryId);
        return modifiedConnConfig;
    }

    public JSONObject getConnConfigForQueryExecutor(String name, String queryId, String queryType, String query) {
        JSONObject modifiedConnConfig = (JSONObject)this.connConfig.clone();
        modifiedConnConfig.put((Object)"source_type", (Object)this.srcType);
        modifiedConnConfig.put((Object)"runQuery", (Object)query);
        modifiedConnConfig.put((Object)"queryType", (Object)queryType);
        modifiedConnConfig.put((Object)"is_cdata_src", (Object)this.isCdataSrc);
        modifiedConnConfig.put((Object)"queryId", (Object)queryId);
        modifiedConnConfig.put((Object)"name", (Object)name);
        return modifiedConnConfig;
    }

    public JSONObject toJSON() {
        JSONObject sourceJson = new JSONObject();
        sourceJson.put((Object)"src_id", (Object)this.srcId);
        sourceJson.put((Object)"src_type", (Object)this.srcType);
        sourceJson.put((Object)"conn_config", (Object)this.connConfig);
        sourceJson.put((Object)"connector_id", (Object)this.connectorId);
        sourceJson.put((Object)"is_cdata_src", (Object)this.isCdataSrc);
        return sourceJson;
    }
}

