/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.rule;

import com.dvsum.model.ref.RefNodeType;
import com.dvsum.model.ref.RefQueryType;
import com.dvsum.rule.ProfileNode;
import com.dvsum.rule.SqlQuery;
import java.util.ArrayList;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class Node {
    protected String srcId;
    protected Long nodeId;
    protected String ruleId;
    protected String nodeType;
    protected String operation;
    protected String ruleType;
    protected List<SqlQuery> sqlQueries;
    protected Boolean isSeqRequired;
    protected String jobId;
    protected Boolean isJobOnline;
    protected String uiWebsocketId;
    protected String compareType;
    protected String variancePercent;
    protected Integer totalCount = 0;
    protected Integer exceptionCount = 0;

    public Node(String srcId, Long nodeId, String ruleId, String nodeType, String operation, String ruleType, List<SqlQuery> sqlQueries, Boolean isSeqRequired, String jobId, Boolean isJobOnline, String uiWebsocketId) {
        this.srcId = srcId;
        this.nodeId = nodeId;
        this.ruleId = ruleId;
        this.nodeType = nodeType;
        this.operation = operation;
        this.ruleType = ruleType;
        this.sqlQueries = sqlQueries;
        this.isSeqRequired = isSeqRequired;
        this.jobId = jobId;
        this.isJobOnline = isJobOnline;
        this.uiWebsocketId = uiWebsocketId;
    }

    public Node(JSONObject nodeJson) {
        this.srcId = String.valueOf(nodeJson.get((Object)"src_id"));
        this.nodeId = (Long)nodeJson.get((Object)"node_id");
        this.ruleId = String.valueOf(nodeJson.get((Object)"rule_id"));
        this.nodeType = (String)nodeJson.get((Object)"node_type");
        Object operationValue = nodeJson.get((Object)"operation");
        this.operation = operationValue != null ? operationValue.toString() : null;
        this.ruleType = (String)nodeJson.get((Object)"rule_type");
        Object isSeqRequiredValue = nodeJson.get((Object)"is_seq_required");
        this.isSeqRequired = isSeqRequiredValue != null ? (Boolean)isSeqRequiredValue : null;
        JSONArray sqlQueriesJsonArray = nodeJson.get((Object)"sql_queries") != null ? (JSONArray)nodeJson.get((Object)"sql_queries") : new JSONArray();
        this.sqlQueries = SqlQuery.getSqlQueriesFromJsonArray(sqlQueriesJsonArray);
        this.jobId = String.valueOf(nodeJson.get((Object)"job_id"));
        this.isJobOnline = (Boolean)nodeJson.get((Object)"is_job_online");
        this.uiWebsocketId = (String)nodeJson.get((Object)"ui_websocket_id");
        this.compareType = (String)nodeJson.get((Object)"cmp_type");
        this.variancePercent = (String)nodeJson.get((Object)"variance_pct");
    }

    public JSONObject toJSON() {
        JSONObject nodeJson = new JSONObject();
        nodeJson.put((Object)"src_id", (Object)this.srcId);
        nodeJson.put((Object)"node_id", (Object)this.nodeId);
        nodeJson.put((Object)"rule_id", (Object)this.ruleId);
        nodeJson.put((Object)"node_type", (Object)this.nodeType);
        nodeJson.put((Object)"operation", (Object)this.operation);
        nodeJson.put((Object)"rule_type", (Object)this.ruleType);
        nodeJson.put((Object)"is_seq_required", (Object)this.isSeqRequired);
        nodeJson.put((Object)"job_id", (Object)this.jobId);
        nodeJson.put((Object)"is_job_online", (Object)this.isJobOnline);
        nodeJson.put((Object)"ui_websocket_id", (Object)this.uiWebsocketId);
        nodeJson.put((Object)"cmp_type", (Object)this.compareType);
        nodeJson.put((Object)"variance_pct", (Object)this.variancePercent);
        JSONArray sqlQueriesJsonArray = new JSONArray();
        for (SqlQuery sqlQuery : this.sqlQueries) {
            sqlQueriesJsonArray.add((Object)sqlQuery.toJSON());
        }
        nodeJson.put((Object)"sql_queries", (Object)sqlQueriesJsonArray);
        return nodeJson;
    }

    public static List<Node> getNodesFromJsonArray(JSONArray nodesJsonArray) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodesJsonArray.forEach(nodeObj -> {
            JSONObject nodeJson = (JSONObject)nodeObj;
            Node node = null;
            node = RefNodeType.isTable(String.valueOf(nodeJson.get((Object)"node_type"))) ? new ProfileNode(nodeJson) : new Node((JSONObject)nodeObj);
            nodes.add(node);
        });
        return nodes;
    }

    public static Node getNodeByNodeId(String nodeId, List<Node> nodes) {
        Node requiredNode = null;
        for (Node node : nodes) {
            if (!node.getNodeId().equals(nodeId)) continue;
            requiredNode = node;
        }
        return requiredNode;
    }

    public SqlQuery getQueryFromQryType(String queryType) {
        SqlQuery requiredQuery = null;
        for (SqlQuery query : this.getSqlQueries()) {
            if (!query.getQryType().equalsIgnoreCase(queryType)) continue;
            requiredQuery = query;
            break;
        }
        return requiredQuery;
    }

    public SqlQuery getOtherQuery(String queryType, boolean isCountQuery) {
        for (SqlQuery query : this.getSqlQueries()) {
            boolean isOtherQuery = RefQueryType.isOtherQuery(queryType);
            boolean hasDeltaList = query.getSqlText().contains("$DELTALIST$");
            if (!query.getQryType().equalsIgnoreCase(queryType)) continue;
            if (isOtherQuery && !isCountQuery && hasDeltaList) {
                return query;
            }
            if (!isCountQuery || hasDeltaList) continue;
            return query;
        }
        return null;
    }

    public String getSrcId() {
        return this.srcId;
    }

    public void setSrcId(String srcId) {
        this.srcId = srcId;
    }

    public Long getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(Long nodeId) {
        this.nodeId = nodeId;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getRuleType() {
        return this.ruleType;
    }

    public void setRuleType(String ruleType) {
        this.ruleType = ruleType;
    }

    public List<SqlQuery> getSqlQueries() {
        return this.sqlQueries;
    }

    public void setSqlQueries(List<SqlQuery> sqlQueries) {
        this.sqlQueries = sqlQueries;
    }

    public Boolean getIsSeqRequired() {
        return this.isSeqRequired;
    }

    public void setIsSeqRequired(Boolean isSeqRequired) {
        this.isSeqRequired = isSeqRequired;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public Boolean getIsJobOnline() {
        return this.isJobOnline;
    }

    public void setIsJobOnline(Boolean isJobOnline) {
        this.isJobOnline = isJobOnline;
    }

    public String getUiWebsocketId() {
        return this.uiWebsocketId;
    }

    public void setUiWebsocketId(String uiWebsocketId) {
        this.uiWebsocketId = uiWebsocketId;
    }

    public String getCompareType() {
        return this.compareType;
    }

    public void setCompareType(String compareType) {
        this.compareType = compareType;
    }

    public String getVariancePercent() {
        return this.variancePercent;
    }

    public void setVariancePercent(String variancePercent) {
        this.variancePercent = variancePercent;
    }

    public Integer getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    public Integer getExceptionCount() {
        return this.exceptionCount;
    }

    public void setExceptionCount(Integer exceptionCount) {
        this.exceptionCount = exceptionCount;
    }
}

