/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.rule;

import com.dvsum.logger.CustomLogger;
import com.dvsum.logger.LogFormat;
import com.dvsum.model.QueryExecutor;
import com.dvsum.rule.BaseRule;
import com.dvsum.rule.Connector;
import com.dvsum.rule.Node;
import com.dvsum.rule.Source;
import com.dvsum.rule.SqlQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class FKRule
extends BaseRule {
    private static final CustomLogger logger = CustomLogger.getLogger(FKRule.class);
    protected List<String> deltaListBatches = new ArrayList<String>();
    protected JSONArray resQueryResults = new JSONArray();

    public FKRule(ExecutorService executorService, Node rule, List<Source> sources, Connector connector, String executionId, JSONObject s3PreSignedURLInfo, LogFormat logFormat) {
        super(executorService, rule, sources, connector, executionId, s3PreSignedURLInfo, logFormat);
    }

    @Override
    public void executeQueries() {
        this.executeQueries(this.getQueriesToExecuteInParallel());
        this.getDeltaList();
        logger.info(this.logFormat.getFormattedLog(), "Formatted Missing Records batches= ", this.deltaListBatches.size());
        this.executeResultsQuery();
        this.getQueryResults();
        this.mergeQueryResults();
        this.postBackResultsHandler(this.resQueryResults, this.node.getQueryFromQryType("RES"));
        this.dumpWebsocketMessageToS3(this.node.toJSON(), String.valueOf(this.node.getRuleId()) + "_output_metadata.json");
        this.sendMessageToWebsocket();
    }

    public JSONArray getQueriesToExecuteInParallel() {
        SqlQuery masterQuery = this.node.getQueryFromQryType("MST");
        SqlQuery slaveQuery = this.node.getQueryFromQryType("REF");
        JSONArray queriesToExecuteInParallel = new JSONArray();
        queriesToExecuteInParallel.add((Object)masterQuery);
        queriesToExecuteInParallel.add((Object)slaveQuery);
        return queriesToExecuteInParallel;
    }

    public void executeQueries(JSONArray queries) {
        for (Object queryObj : queries) {
            SqlQuery query = (SqlQuery)queryObj;
            Future<JSONObject> queryResultFuture = this.submitQueryToExecute(query);
            this.futureResults.add(queryResultFuture);
        }
        this.getQueryResults();
    }

    public JSONArray executeSingleQuery(SqlQuery ruleQuery) {
        Future<JSONObject> queryFuture = this.submitQueryToExecute(ruleQuery);
        JSONObject queryResults = this.getQueryResultsFromFuture(queryFuture);
        return QueryExecutor.getRunJson(queryResults);
    }

    public void executeResultsQuery() {
        this.clearExecutionData();
        SqlQuery resultsQuery = this.node.getQueryFromQryType("RES");
        int batch = 1;
        for (String deltaList : this.deltaListBatches) {
            logger.info(this.logFormat.getFormattedLog(), "Executing results query batch ", batch, " for Query id : ", resultsQuery.getQryId());
            SqlQuery queryToExecute = resultsQuery.clone();
            this.updateResultsQuerySql(deltaList, queryToExecute);
            Future<JSONObject> queryResultFuture = this.submitQueryToExecute(queryToExecute);
            this.futureResults.add(queryResultFuture);
            ++batch;
        }
    }

    public void clearExecutionData() {
        this.futureResults = new ArrayList();
        this.queryResultsJsonArray = new JSONArray();
    }

    public void mergeQueryResults() {
        logger.info(this.logFormat.getFormattedLog(), "Res Query List size = ", this.resQueryResults.size());
        SqlQuery resultsQuery = this.node.getQueryFromQryType("RES");
        for (Object queryResultsObj : this.queryResultsJsonArray) {
            JSONObject queryResultsJson = (JSONObject)queryResultsObj;
            if (QueryExecutor.getRunStatus(queryResultsJson).equalsIgnoreCase("-1")) {
                logger.error(this.logFormat.getFormattedLog(), "Failed to load query results.");
                resultsQuery.setQryErrorMsg(QueryExecutor.getRunError(queryResultsJson));
                resultsQuery.setQryExecStatus("-1");
                break;
            }
            JSONArray queryResultsJsonArray = QueryExecutor.getRunJson(queryResultsJson);
            logger.info(this.logFormat.getFormattedLog(), "query results json array size = ", queryResultsJsonArray.size());
            this.resQueryResults = FKRule.mergeArrays(this.resQueryResults, queryResultsJsonArray);
            logger.info(this.logFormat.getFormattedLog(), "After merging, res query list size = ", this.resQueryResults.size());
            resultsQuery.setQryResultCnt(this.resQueryResults.size());
            resultsQuery.setQryExecStatus("0");
        }
    }

    public static JSONArray mergeArrays(JSONArray array1, JSONArray array2) {
        JSONArray mergedArray = new JSONArray();
        mergedArray.addAll((Collection)array1);
        mergedArray.addAll((Collection)array2);
        return mergedArray;
    }

    public SqlQuery updateResultsQuerySql(String deltaList, SqlQuery resultsQuery) {
        String sqlText = resultsQuery.getSqlText();
        sqlText = sqlText.replace("$DELTALIST$", deltaList);
        resultsQuery.setSqlText(sqlText);
        return resultsQuery;
    }

    public void updateQueryMetadata(JSONObject queryResultsJson, SqlQuery query) {
        JSONArray queryRunJson = QueryExecutor.getRunJson(queryResultsJson);
        query.setQryResultCnt(queryRunJson.size());
        String queryRunStatus = QueryExecutor.getRunStatus(queryResultsJson);
        query.setQryExecStatus(queryRunStatus);
        if (queryRunStatus.equalsIgnoreCase("-1")) {
            query.setQryErrorMsg(QueryExecutor.getRunError(queryResultsJson));
        }
    }

    public void getDeltaList() {
        JSONObject masterQueryResultsJson = this.getQueryResultsFromQueryType("MST");
        JSONObject refQueryResultsJson = this.getQueryResultsFromQueryType("REF");
        this.updateQueryMetadata(masterQueryResultsJson, this.node.getQueryFromQryType("MST"));
        this.updateQueryMetadata(refQueryResultsJson, this.node.getQueryFromQryType("REF"));
        if (!this.checkMasterRefQueriesRunStatus(masterQueryResultsJson, refQueryResultsJson).booleanValue()) {
            logger.error(this.logFormat.getFormattedLog(), "Master or Ref query failed.");
            return;
        }
        List<String> masterResultsArray = FKRule.extractValuesFromResults(QueryExecutor.getRunJson(masterQueryResultsJson), "mvalues");
        List<String> refResultsArray = FKRule.extractValuesFromResults(QueryExecutor.getRunJson(refQueryResultsJson), "svalues");
        List<String> missingValues = FKRule.findUniqueValues(masterResultsArray, refResultsArray);
        this.convertRecordsToStringifiedBatches(missingValues, 1000);
    }

    public static List<String> findUniqueValues(List<String> firstArray, List<String> secondArray) {
        ArrayList<String> uniqueValues = new ArrayList<String>();
        for (String value : firstArray) {
            if (secondArray.contains(value) || uniqueValues.contains(value)) continue;
            uniqueValues.add(value);
        }
        return uniqueValues;
    }

    public void convertRecordsToStringifiedBatches(List<String> values, int batchSize) {
        StringBuilder stringBuilder = new StringBuilder();
        int count = 0;
        for (String value : values) {
            if (count == batchSize) {
                this.updateDeltaListBatches(stringBuilder);
                stringBuilder.setLength(0);
                count = 0;
            }
            value = value.contains("'") ? value.replace("'", "''") : value;
            stringBuilder.append("'").append(value).append("'").append(",");
            ++count;
        }
        this.updateDeltaListBatches(stringBuilder);
    }

    public void updateDeltaListBatches(StringBuilder stringBuilder) {
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            this.deltaListBatches.add(stringBuilder.toString());
        }
    }

    public Boolean checkMasterRefQueriesRunStatus(JSONObject masterQueryResultsJson, JSONObject refQueryResultsJson) {
        String masterStatus = QueryExecutor.getRunStatus(masterQueryResultsJson);
        String refStatus = QueryExecutor.getRunStatus(refQueryResultsJson);
        if (!masterStatus.equalsIgnoreCase("-1") && !refStatus.equalsIgnoreCase("-1")) {
            return true;
        }
        return false;
    }

    public JSONObject getQueryResultsFromQueryType(String queryType) {
        JSONObject requiredResultsJson = new JSONObject();
        for (Object resultsObj : this.queryResultsJsonArray) {
            JSONObject resultsJson = (JSONObject)resultsObj;
            String resultsQueryType = String.valueOf(resultsJson.get((Object)"queryType"));
            if (!queryType.equalsIgnoreCase(resultsQueryType)) continue;
            requiredResultsJson = resultsJson;
            break;
        }
        return requiredResultsJson;
    }

    public static List<String> extractValuesFromResults(JSONArray results, String key) {
        ArrayList<String> valuesList = new ArrayList<String>();
        try {
            for (Object obj : results) {
                JSONObject jsonObject = (JSONObject)obj;
                String value = (String)jsonObject.get((Object)key);
                valuesList.add(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return valuesList;
    }

    protected JSONObject getQueryResultsFromFuture(Future<JSONObject> queryResults) {
        JSONObject queryResultsJson = new JSONObject();
        try {
            if (queryResults.get() != null && !queryResults.get().isEmpty()) {
                queryResultsJson = queryResults.get();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return queryResultsJson;
    }
}

