/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.rule;

import com.dvsum.logger.CustomLogger;
import com.dvsum.logger.LogFormat;
import com.dvsum.model.QueryExecutor;
import com.dvsum.rule.BaseRule;
import com.dvsum.rule.Connector;
import com.dvsum.rule.Node;
import com.dvsum.rule.Source;
import com.dvsum.rule.SqlQuery;
import com.dvsum.util.Util;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class CMMRule
extends BaseRule {
    private static final CustomLogger logger = CustomLogger.getLogger(CMMRule.class);
    protected JSONArray resQueryResults = new JSONArray();

    public CMMRule(ExecutorService executorService, Node rule, List<Source> sources, Connector connector, String executionId, JSONObject s3PreSignedURLInfo, LogFormat logFormat) {
        super(executorService, rule, sources, connector, executionId, s3PreSignedURLInfo, logFormat);
    }

    @Override
    public void executeQueries() {
        this.executeQueries(this.getQueriesToExecuteInParallel());
        this.getCompareMetricResults();
        this.postBackResultsHandler(this.resQueryResults, this.node.getQueryFromQryType("RES"));
        this.dumpWebsocketMessageToS3(this.node.toJSON(), String.valueOf(this.node.getRuleId()) + "_output_metadata.json");
        this.sendMessageToWebsocket();
    }

    public JSONArray getQueriesToExecuteInParallel() {
        SqlQuery masterQuery = this.node.getQueryFromQryType("MST");
        SqlQuery slaveQuery = this.node.getQueryFromQryType("REF");
        JSONArray queriesToExecuteInParallel = new JSONArray();
        queriesToExecuteInParallel.add((Object)masterQuery);
        queriesToExecuteInParallel.add((Object)slaveQuery);
        return queriesToExecuteInParallel;
    }

    public void executeQueries(JSONArray queries) {
        for (Object queryObj : queries) {
            SqlQuery query = (SqlQuery)queryObj;
            Future<JSONObject> queryResultFuture = this.submitQueryToExecute(query);
            this.futureResults.add(queryResultFuture);
        }
        this.getQueryResults();
    }

    public void clearExecutionData() {
        this.futureResults = new ArrayList();
        this.queryResultsJsonArray = new JSONArray();
    }

    public void updateQueryMetadata(JSONObject queryResultsJson, SqlQuery query) {
        JSONArray queryRunJson = QueryExecutor.getRunJson(queryResultsJson);
        query.setQryResultCnt(queryRunJson.size());
        String queryRunStatus = QueryExecutor.getRunStatus(queryResultsJson);
        query.setQryExecStatus(queryRunStatus);
        if (queryRunStatus.equalsIgnoreCase("-1")) {
            query.setQryErrorMsg(QueryExecutor.getRunError(queryResultsJson));
        }
    }

    public void getCompareMetricResults() {
        JSONObject masterQueryResultsJson = this.getQueryResultsFromQueryType("MST");
        JSONObject refQueryResultsJson = this.getQueryResultsFromQueryType("REF");
        SqlQuery masterQuery = this.node.getQueryFromQryType("MST");
        SqlQuery referenceQuery = this.node.getQueryFromQryType("REF");
        this.updateQueryMetadata(masterQueryResultsJson, masterQuery);
        this.updateQueryMetadata(refQueryResultsJson, referenceQuery);
        if (!this.checkMasterRefQueriesRunStatus(masterQueryResultsJson, refQueryResultsJson).booleanValue()) {
            logger.error(this.logFormat.getFormattedLog(), "Master or Ref query failed.");
            return;
        }
        JSONArray masterResultsArray = QueryExecutor.getRunJson(masterQueryResultsJson);
        JSONArray refResultsArray = QueryExecutor.getRunJson(refQueryResultsJson);
        List<String> masterKeysList = this.extractKeysFromResults(masterResultsArray, masterQuery);
        List<String> refKeyList = this.extractKeysFromResults(refResultsArray, referenceQuery);
        this.resQueryResults = masterKeysList.size() == 0 && Util.isNotNullOrEmpty(masterQuery.getMetricColumns()) ? this.compareAndConcatenateData(masterResultsArray, refResultsArray) : this.compareAndConcatenateData(masterKeysList, refKeyList, masterResultsArray, refResultsArray);
        SqlQuery resultQuery = this.node.getQueryFromQryType("RES");
        resultQuery.setQryResultCnt(this.node.getExceptionCount());
        resultQuery.setTotalCnt(this.node.getTotalCount());
    }

    public JSONArray compareAndConcatenateData(List<String> masterKeysList, List<String> refKeyList, JSONArray masterArray, JSONArray refArray) {
        JSONArray resultArray = new JSONArray();
        ArrayList<String> matchedList = new ArrayList<String>();
        this.node.totalCount = 0;
        logger.info(this.logFormat.getFormattedLog(), "Going to start comparison of Master and reference attributes");
        int index = 0;
        while (index < masterKeysList.size()) {
            if (refKeyList.contains(masterKeysList.get(index))) {
                JSONObject refElement;
                int refIndex = refKeyList.indexOf(masterKeysList.get(index));
                JSONObject masterElement = (JSONObject)masterArray.get(index);
                boolean isException = this.checkExceptionsWithVariance(masterElement, refElement = (JSONObject)refArray.get(refIndex));
                if (isException) {
                    this.addExceptionRecord(masterElement, refElement, resultArray, "EQL");
                }
                this.node.totalCount = this.node.totalCount + 1;
                matchedList.add(masterKeysList.get(index));
            }
            ++index;
        }
        if (this.node.compareType.equals("FUL") || this.node.compareType.equals("LFT")) {
            index = 0;
            while (index < masterKeysList.size()) {
                if (!matchedList.contains(masterKeysList.get(index))) {
                    JSONObject masterElement = (JSONObject)masterArray.get(index);
                    this.addExceptionRecord(masterElement, null, resultArray, "LFT");
                    this.node.totalCount = this.node.totalCount + 1;
                }
                ++index;
            }
        }
        if (this.node.compareType.equals("FUL") || this.node.compareType.equals("RGT")) {
            index = 0;
            while (index < refKeyList.size()) {
                if (!matchedList.contains(refKeyList.get(index))) {
                    JSONObject refElement = (JSONObject)refArray.get(index);
                    this.addExceptionRecord(null, refElement, resultArray, "RGT");
                    this.node.totalCount = this.node.totalCount + 1;
                }
                ++index;
            }
        }
        this.node.setExceptionCount(resultArray.size());
        return resultArray;
    }

    public JSONArray compareAndConcatenateData(JSONArray masterArray, JSONArray refArray) {
        JSONObject refElement;
        JSONArray resultArray = new JSONArray();
        JSONObject masterElement = (JSONObject)masterArray.get(0);
        boolean isException = this.checkExceptionsWithVariance(masterElement, refElement = (JSONObject)refArray.get(0));
        if (isException) {
            this.addExceptionRecord(masterElement, refElement, resultArray, "EQL");
        }
        this.node.setExceptionCount(resultArray.size());
        this.node.setTotalCount(1);
        return resultArray;
    }

    public Boolean checkExceptionsWithVariance(JSONObject masterElement, JSONObject refElement) {
        String baseMetricColumns = this.node.getQueryFromQryType("MST").getMetricColumns();
        String refMetricColumns = this.node.getQueryFromQryType("REF").getMetricColumns();
        if (Util.isNotNullOrEmpty(baseMetricColumns) && Util.isNotNullOrEmpty(refMetricColumns) && Util.isNotNullOrEmpty(this.node.getVariancePercent())) {
            String[] baseColumns = baseMetricColumns.split(",");
            String[] refColumns = refMetricColumns.split(",");
            try {
                int index2 = 0;
                while (index2 < baseColumns.length) {
                    Double refValue = this.convertStringToDouble(String.valueOf(refElement.get((Object)this.getModifiedKey(refColumns[index2]))));
                    Double baseValue = this.convertStringToDouble(String.valueOf(masterElement.get((Object)this.getModifiedKey(baseColumns[index2]))));
                    Double varianceValue = Double.valueOf(this.node.getVariancePercent());
                    if (refValue == null || baseValue == null) {
                        return true;
                    }
                    varianceValue = baseValue * (varianceValue / 100.0);
                    if (refValue < baseValue - varianceValue || refValue > baseValue + varianceValue) {
                        return true;
                    }
                    ++index2;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public Double convertStringToDouble(String strValue) {
        if (!Util.isNullOrEmpty(strValue) && !strValue.equalsIgnoreCase("null")) {
            return Double.parseDouble(strValue);
        }
        return null;
    }

    public void addExceptionRecord(JSONObject masterElement, JSONObject refElement, JSONArray resultArray, String isOnlyLeftOrRight) {
        SqlQuery baseQuery = this.node.getQueryFromQryType("MST");
        SqlQuery refQuery = this.node.getQueryFromQryType("REF");
        String[] baseAttributeColumns = baseQuery.getAttributeColumns().split(",");
        String[] baseMetricColumns = baseQuery.getMetricColumns().split(",");
        String[] refAttributeColumns = refQuery.getAttributeColumns().split(",");
        String[] refMetricColumns = refQuery.getMetricColumns().split(",");
        LinkedHashMap<String, String> exceptionRecord = new LinkedHashMap<String, String>();
        if (Util.isNotNullOrEmpty(baseQuery.getAttributeColumns())) {
            String key;
            String[] stringArray = baseAttributeColumns;
            int n = baseAttributeColumns.length;
            int n2 = 0;
            while (n2 < n) {
                key = stringArray[n2];
                exceptionRecord.put("base_" + key, isOnlyLeftOrRight.equals("RGT") ? null : String.valueOf(masterElement.get((Object)this.getModifiedKey(key))));
                ++n2;
            }
            stringArray = refAttributeColumns;
            n = refAttributeColumns.length;
            n2 = 0;
            while (n2 < n) {
                key = stringArray[n2];
                exceptionRecord.put("ref_" + key, isOnlyLeftOrRight.equals("LFT") ? null : String.valueOf(refElement.get((Object)this.getModifiedKey(key))));
                ++n2;
            }
        }
        int index2 = 0;
        while (index2 < baseMetricColumns.length) {
            exceptionRecord.put("base_" + baseMetricColumns[index2], isOnlyLeftOrRight.equals("RGT") ? null : String.valueOf(masterElement.get((Object)this.getModifiedKey(baseMetricColumns[index2]))));
            exceptionRecord.put("ref_" + refMetricColumns[index2], isOnlyLeftOrRight.equals("LFT") ? null : String.valueOf(refElement.get((Object)this.getModifiedKey(refMetricColumns[index2]))));
            ++index2;
        }
        resultArray.add(exceptionRecord);
    }

    public Boolean checkMasterRefQueriesRunStatus(JSONObject masterQueryResultsJson, JSONObject refQueryResultsJson) {
        String masterStatus = QueryExecutor.getRunStatus(masterQueryResultsJson);
        String refStatus = QueryExecutor.getRunStatus(refQueryResultsJson);
        if (!masterStatus.equalsIgnoreCase("-1") && !refStatus.equalsIgnoreCase("-1")) {
            return true;
        }
        return false;
    }

    public JSONObject getQueryResultsFromQueryType(String queryType) {
        JSONObject requiredResultsJson = new JSONObject();
        for (Object resultsObj : this.queryResultsJsonArray) {
            JSONObject resultsJson = (JSONObject)resultsObj;
            String resultsQueryType = String.valueOf(resultsJson.get((Object)"queryType"));
            if (!queryType.equalsIgnoreCase(resultsQueryType)) continue;
            requiredResultsJson = resultsJson;
            break;
        }
        return requiredResultsJson;
    }

    public List<String> extractKeysFromResults(JSONArray results, SqlQuery query) {
        ArrayList<String> keyList = new ArrayList<String>();
        if (Util.isNotNullOrEmpty(query.getAttributeColumns())) {
            String[] columns = query.getAttributeColumns().split(",");
            try {
                for (Object obj : results) {
                    JSONObject jsonObject = (JSONObject)obj;
                    StringBuilder builderStr = new StringBuilder();
                    String[] stringArray = columns;
                    int n = columns.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String key = stringArray[n2];
                        builderStr.append((String)jsonObject.get((Object)this.getModifiedKey(key)));
                        ++n2;
                    }
                    keyList.add(builderStr.toString());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return keyList;
    }
}

