/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.model.scan;

import com.dvsum.factory.DataSourceFactory;
import com.dvsum.logger.CustomLogger;
import com.dvsum.logger.LogFormat;
import com.dvsum.model.QueryExecutor;
import com.dvsum.rule.TemplateQueries;
import com.dvsum.util.CryptographicUtil;
import com.dvsum.util.FileUtil;
import com.dvsum.util.GzipUtil;
import com.dvsum.util.MultipartFileUploader;
import com.dvsum.util.TLSHttpsRequestor;
import com.dvsum.util.Util;
import java.io.FileWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class ProfileTable
implements Runnable {
    private static final CustomLogger logger = CustomLogger.getLogger(ProfileTable.class);
    private DataSourceFactory dataSourceFactory;
    private String updateSerializationLibURL;
    JSONObject scanSourceMeataData = new JSONObject();
    JSONObject connectionInfo;
    ExecutorService executorService;
    JSONObject catalogQueries;
    JSONObject profileQueries;
    JSONObject queriesTempalte;
    JSONObject columnsMetaData;
    JSONObject constraintsMetaData;
    JSONObject tablesMetaData;
    JSONArray catalogResultsJsonArray;
    JSONObject profileJson;
    String tableName;
    JSONObject columns;
    JSONObject columnDataTypes;
    String escapeChar;
    JSONArray queryResultsJsonArray;
    List<Future<JSONObject>> futureResults;
    JSONObject numberTypeColProfileQueries;
    JSONObject dateTypeColProfileQueries;
    JSONObject stringTypeColumnProfileQueries;
    JSONObject boolTypeColumnProfileQueries;
    String executionId;
    JSONObject S3PreSignedURLInfo;
    String baseFilePath;
    String schemaName;
    String tableNameWithSchema;
    String modifiedTableNameWithSchema;
    Integer categoryUniqueCount;
    Integer patternCount;
    String sourceType;
    String sampleDataOutputFile;
    JSONObject sampleDatajJson;
    JSONObject connectorDetails;
    LogFormat logFormat;
    AtomicInteger remainingTableCount;
    int totalTableCount;

    public ProfileTable(JSONObject scanSourceMeataData, DataSourceFactory dataSourceFactory, JSONObject profileJson, ExecutorService executorService, int totalTableCount, AtomicInteger remainingTableCount, String updateSerializationLibURL, LogFormat logFormat) {
        this.scanSourceMeataData.putAll((Map)scanSourceMeataData);
        this.dataSourceFactory = new DataSourceFactory();
        this.connectionInfo = (JSONObject)this.scanSourceMeataData.get((Object)"connection_config");
        this.profileJson = profileJson;
        this.connectionInfo = (JSONObject)this.scanSourceMeataData.get((Object)"connection_config");
        this.escapeChar = String.valueOf(this.scanSourceMeataData.get((Object)"escape_char"));
        this.schemaName = String.valueOf(this.profileJson.get((Object)"table_schem"));
        this.queriesTempalte = (JSONObject)this.scanSourceMeataData.get((Object)"queries_template");
        this.catalogQueries = (JSONObject)this.queriesTempalte.get((Object)"catalog");
        this.profileQueries = (JSONObject)this.queriesTempalte.get((Object)"profile");
        this.columnDataTypes = (JSONObject)this.scanSourceMeataData.get((Object)"datatype_map");
        this.connectorDetails = (JSONObject)this.scanSourceMeataData.get((Object)"connector_details");
        this.tableName = String.valueOf(this.profileJson.get((Object)"table_name"));
        this.tableNameWithSchema = Util.isNotNullOrEmpty(this.schemaName) && !this.tableName.startsWith(String.valueOf(this.schemaName) + ".") ? String.valueOf(this.schemaName) + "." + this.tableName : this.tableName;
        this.modifiedTableNameWithSchema = ProfileTable.modifyTableName(this.schemaName, this.tableName, this.escapeChar);
        this.columns = (JSONObject)this.profileJson.get((Object)"cols");
        this.queryResultsJsonArray = new JSONArray();
        this.futureResults = new ArrayList<Future<JSONObject>>();
        this.sourceType = (String)this.scanSourceMeataData.get((Object)"source_type");
        this.numberTypeColProfileQueries = (JSONObject)this.profileQueries.get((Object)"NUM");
        this.stringTypeColumnProfileQueries = (JSONObject)this.profileQueries.get((Object)"STR");
        this.dateTypeColProfileQueries = (JSONObject)this.profileQueries.get((Object)"DTE");
        this.boolTypeColumnProfileQueries = (JSONObject)this.profileQueries.get((Object)"BOL");
        this.executionId = String.valueOf(this.scanSourceMeataData.get((Object)"execution_id"));
        this.S3PreSignedURLInfo = (JSONObject)this.scanSourceMeataData.get((Object)"s3_pre_signed_post_url");
        this.baseFilePath = "./scan_output/" + this.executionId + "/";
        this.categoryUniqueCount = Integer.valueOf(this.scanSourceMeataData.get((Object)"category_count").toString());
        this.patternCount = Integer.valueOf(this.scanSourceMeataData.get((Object)"pattern_count").toString());
        this.executorService = executorService;
        this.remainingTableCount = remainingTableCount;
        this.totalTableCount = totalTableCount;
        this.updateSerializationLibURL = updateSerializationLibURL;
        this.logFormat = logFormat;
        this.createColumsProfilingSubObjects();
    }

    @Override
    public void run() {
        logger.debug(this.logFormat.getFormattedLog(), "Profiling started for : " + this.tableName);
        if (this.sourceType.equals("AS3")) {
            String db_name = (String)this.connectionInfo.get((Object)"database");
            String s3_staging = (String)this.connectionInfo.get((Object)"stagingBucket");
            String region = (String)this.connectionInfo.get((Object)"region");
            String accessKey = (String)this.connectionInfo.get((Object)"accessKey");
            String secretKey = (String)this.connectionInfo.get((Object)"secretKey");
            String API_key = FileUtil.getAPIkey();
            JSONObject json_obj = new JSONObject();
            json_obj.put((Object)"region", (Object)region);
            json_obj.put((Object)"db_name", (Object)db_name);
            json_obj.put((Object)"s3_staging", (Object)("s3://" + s3_staging + "/"));
            json_obj.put((Object)"table_name", (Object)this.tableName);
            String string = TLSHttpsRequestor.executePost(this.updateSerializationLibURL, json_obj.toJSONString(), API_key, accessKey, secretKey, this.logFormat);
        }
        this.executeBaseProfileQueries();
        this.executeProfilingSecondRound();
        this.uploadSampleDataToS3();
        this.uploadTableJsonToS3();
        logger.info(this.logFormat.getFormattedLog(), "Profiling completed for : " + this.tableName);
        this.remainingTableCount.set(this.remainingTableCount.intValue() - 1);
        int profiledTableCount = this.totalTableCount - this.remainingTableCount.intValue();
        logger.info(this.logFormat.getFormattedLog(), "Profiled tables : ", profiledTableCount, "/", this.totalTableCount);
    }

    private void uploadSampleDataToS3() {
        try {
            Boolean isOnPremSAWS = Boolean.valueOf(this.connectorDetails.get((Object)"is_on_prem_saws").toString());
            if (isOnPremSAWS.booleanValue()) {
                this.sampleDataOutputFile = String.valueOf(this.baseFilePath) + FileUtil.cleanFileNameForScan(this.tableNameWithSchema) + "_sample_data.json";
                JSONArray resultsArray = (JSONArray)this.sampleDatajJson.get((Object)"results");
                String encryptedDataString = CryptographicUtil.encrypt(resultsArray.toJSONString());
                FileUtil.writeToFileIfNotExists(this.sampleDataOutputFile, encryptedDataString);
                logger.info(this.logFormat.getFormattedLog(), "Sample data file created. File path :", this.sampleDataOutputFile);
            } else {
                this.sampleDataOutputFile = String.valueOf(this.baseFilePath) + FileUtil.cleanFileNameForScan(this.tableNameWithSchema) + "_sample_data.json";
                JSONArray resultsArray = (JSONArray)this.sampleDatajJson.get((Object)"results");
                FileUtil.writeToFileIfNotExists(this.sampleDataOutputFile, resultsArray.toJSONString());
                String gzFilePath = this.sampleDataOutputFile.trim().concat(".gz");
                GzipUtil.convertJsonToGz(this.sampleDataOutputFile, gzFilePath);
                MultipartFileUploader.uploadFileToS3(gzFilePath, this.S3PreSignedURLInfo, this.logFormat);
                logger.info(this.logFormat.getFormattedLog(), "Sample data file uploaded to S3. File name :", ProfileTable.getFileName(gzFilePath));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(this.logFormat.getFormattedLog(), "Error found while processing sample data. ", e.getMessage());
        }
    }

    public static String getFileName(String filePath) {
        String fileName = "";
        if (filePath != null) {
            Path path = Paths.get(filePath, new String[0]);
            fileName = path.getFileName().toString();
        }
        return fileName;
    }

    private static String modifyTableName(String schemaName, String tableName, String escapeChar) {
        try {
            boolean isSchemaNull = Util.isNullOrEmpty(schemaName);
            if ((isSchemaNull || tableName.startsWith(String.valueOf(schemaName) + ".")) && tableName.contains(".")) {
                String[] splittedTableName = tableName.split("\\.");
                schemaName = splittedTableName[0];
                tableName = splittedTableName[1];
                isSchemaNull = false;
            }
            if (escapeChar.equalsIgnoreCase("squarebrackets")) {
                schemaName = String.valueOf('[') + schemaName + ']';
                tableName = String.valueOf('[') + tableName + ']';
            } else if (escapeChar.equalsIgnoreCase("backtick")) {
                schemaName = String.valueOf('`') + schemaName + '`';
                tableName = String.valueOf('`') + tableName + '`';
            } else if (escapeChar.equalsIgnoreCase("doublequotes")) {
                schemaName = String.valueOf('\"') + schemaName + '\"';
                tableName = String.valueOf('\"') + tableName + '\"';
            } else if (escapeChar.equalsIgnoreCase("singlequotes")) {
                schemaName = "'" + schemaName + "'";
                tableName = "'" + tableName + "'";
            }
            return isSchemaNull ? tableName : String.valueOf(schemaName) + "." + tableName;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private static String modifyColName(String colName, String escapeChar) {
        try {
            if (escapeChar.equalsIgnoreCase("squarebrackets")) {
                colName = String.valueOf('[') + colName + ']';
            } else if (escapeChar.equalsIgnoreCase("backtick")) {
                colName = String.valueOf('`') + colName + '`';
            } else if (escapeChar.equalsIgnoreCase("doublequotes")) {
                colName = String.valueOf('\"') + colName + '\"';
            } else if (escapeChar.equalsIgnoreCase("singlequotes")) {
                colName = "'" + colName + "'";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return colName;
    }

    private static boolean checkIfSpecialCharExists(String text) {
        Pattern p = Pattern.compile("[^a-z_0-9]", 2);
        Matcher m = p.matcher(text);
        boolean b = m.find();
        return b;
    }

    private void uploadTableJsonToS3() {
        String jsonFilePath = String.valueOf(this.baseFilePath) + FileUtil.cleanFileNameForScan(this.tableNameWithSchema) + "_input.json";
        FileUtil.writeJsonToFile(jsonFilePath, this.profileJson);
        MultipartFileUploader.uploadFileToS3(jsonFilePath, this.S3PreSignedURLInfo, this.logFormat);
        Boolean isOnPremSAWS = Boolean.valueOf(this.connectorDetails.get((Object)"is_on_prem_saws").toString());
        logger.info(this.logFormat.getFormattedLog(), "Metadata file uploaded to S3.", isOnPremSAWS != false ? "File path :" + jsonFilePath : "");
    }

    private void executeBaseProfileQueries() {
        logger.info(this.logFormat.getFormattedLog(), "Profiling first round started for table: " + this.tableName);
        this.executeSamplesQuery();
        this.executeTableBaseProfilingQuery();
        this.executeColumsBaseProfileQuery();
        this.getQueryResults();
        this.processBaseProfileQueryResults();
        logger.info(this.logFormat.getFormattedLog(), "Profiling first round completed for table: " + this.tableName);
    }

    private void executeProfilingSecondRound() {
        logger.info(this.logFormat.getFormattedLog(), "Profiling second round started for table: " + this.tableName);
        this.futureResults = new ArrayList<Future<JSONObject>>();
        this.queryResultsJsonArray = new JSONArray();
        this.executeAllColumnsDetailedProfiling();
        this.getQueryResults();
        this.processDetailedProfilingQueryResults();
        logger.info(this.logFormat.getFormattedLog(), "Profiling second round completed for table: " + this.tableName);
    }

    private void processBaseProfileQueryResults() {
        this.queryResultsJsonArray.stream().forEach(result -> {
            JSONObject queryResult = (JSONObject)result;
            try {
                String queryType = String.valueOf(queryResult.get((Object)"queryType"));
                if (queryResult.containsKey((Object)"runJson") && !queryType.contains("sample_query")) {
                    JSONArray resultsArray = (JSONArray)((JSONObject)queryResult.get((Object)"runJson")).get((Object)"results");
                    if (queryType.contains("base_table_profile_")) {
                        resultsArray.forEach(profileResult -> {
                            JSONObject table = (JSONObject)profileResult;
                            table.keySet().forEach(key -> {
                                if (key.equals("table_name")) {
                                    table.remove((Object)"key");
                                    table.put(key, (Object)this.tableNameWithSchema);
                                }
                                this.profileJson.put(key, table.get(key));
                            });
                        });
                    } else if (queryType.contains("base_column_profile_")) {
                        String column_name = queryType.replace("base_column_profile_", "");
                        JSONObject columnJson = (JSONObject)this.columns.get((Object)column_name);
                        String columnName = String.valueOf(queryResult.get((Object)"columnName"));
                        JSONObject dataProfile = (JSONObject)columnJson.get((Object)"data_profile");
                        JSONObject cat_stats = (JSONObject)dataProfile.get((Object)"cat_stats");
                        JSONObject length_stats = (JSONObject)dataProfile.get((Object)"length_stats");
                        JSONObject general_stats = (JSONObject)dataProfile.get((Object)"general_stats");
                        JSONObject num_stats = (JSONObject)dataProfile.get((Object)"num_stats");
                        resultsArray.forEach(columnProfileResult -> {
                            JSONObject columnProfile = (JSONObject)columnProfileResult;
                            this.processColumnBaseProfile(columnProfile, columnJson, general_stats, cat_stats, length_stats, num_stats);
                        });
                        this.columns.put((Object)column_name, (Object)columnJson);
                    }
                } else if (queryType.contains("sample_query")) {
                    this.sampleDatajJson = null;
                    if (queryResult.containsKey((Object)"runJson")) {
                        this.sampleDatajJson = (JSONObject)queryResult.get((Object)"runJson");
                    } else {
                        logger.info(this.logFormat.getFormattedLog(), "Empty table: " + this.tableName);
                        this.sampleDatajJson = new JSONObject();
                        JSONArray resultsArray = new JSONArray();
                        JSONObject emptyJSonCsv = new JSONObject();
                        for (Object key : this.columns.keySet()) {
                            emptyJSonCsv.put((Object)String.valueOf(key), (Object)"");
                        }
                        resultsArray.add((Object)emptyJSonCsv);
                        this.sampleDatajJson.put((Object)"results", (Object)resultsArray);
                    }
                } else {
                    logger.info(this.logFormat.getFormattedLog(), "For table : " + this.tableName + ", no runjson obj found: \n" + queryResult.toJSONString());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(this.logFormat.getFormattedLog(), "For table : " + this.tableName + ", Base profiling query failed for table : Error: ", e);
            }
        });
    }

    private void processColumnBaseProfile(JSONObject columnProfile, JSONObject columnJson, JSONObject general_stats, JSONObject cat_stats, JSONObject length_stats, JSONObject num_stats) {
        columnProfile.keySet().forEach(key -> {
            try {
                String keyStr = (String)key;
                String columnProfileValue = String.valueOf(columnProfile.get(key));
                columnJson.put(key, (Object)columnProfileValue);
                if ("count_all".equalsIgnoreCase(keyStr)) {
                    general_stats.put((Object)"n_count", (Object)(Util.isNotNullOrEmpty(columnProfileValue) ? Integer.valueOf(columnProfileValue) : null));
                } else if ("count_blanks".equalsIgnoreCase(keyStr)) {
                    general_stats.put((Object)"n_missing", (Object)(Util.isNotNullOrEmpty(columnProfileValue) ? Integer.valueOf(columnProfileValue) : null));
                } else if ("count_empty".equalsIgnoreCase(keyStr)) {
                    general_stats.put((Object)"n_empty", (Object)(Util.isNotNullOrEmpty(columnProfileValue) ? Integer.valueOf(columnProfileValue) : null));
                } else if ("count_distinct".equalsIgnoreCase(keyStr)) {
                    cat_stats.put((Object)"n_distinct", (Object)(Util.isNotNullOrEmpty(columnProfileValue) ? Integer.valueOf(columnProfileValue) : null));
                } else if ("min_length".equalsIgnoreCase(keyStr)) {
                    length_stats.put((Object)"min", (Object)(Util.isNotNullOrEmpty(columnProfileValue) ? Integer.valueOf(columnProfileValue) : null));
                } else if ("max_length".equalsIgnoreCase(keyStr)) {
                    length_stats.put((Object)"max", (Object)(Util.isNotNullOrEmpty(columnProfileValue) ? Integer.valueOf(columnProfileValue) : null));
                } else if ("min_value".equalsIgnoreCase(keyStr)) {
                    num_stats.put((Object)"min", (Object)columnProfileValue);
                } else if ("max_value".equalsIgnoreCase(keyStr)) {
                    num_stats.put((Object)"max", (Object)columnProfileValue);
                } else if ("ordinal_position".equalsIgnoreCase(keyStr)) {
                    columnJson.put((Object)"col_seq", (Object)columnProfileValue);
                } else if ("remarks".equalsIgnoreCase(keyStr)) {
                    columnJson.put((Object)"col_desc", (Object)columnProfileValue);
                } else if ("type_name".equalsIgnoreCase(keyStr)) {
                    columnJson.put((Object)"raw_data_type", (Object)columnProfileValue);
                } else if ("column_size".equalsIgnoreCase(keyStr)) {
                    columnJson.put((Object)"col_length", (Object)(Util.isNotNullOrEmpty(columnProfileValue) ? Integer.valueOf(columnProfileValue) : null));
                } else if ("decimal_digits".equalsIgnoreCase(keyStr)) {
                    columnJson.put((Object)"col_precision", (Object)columnProfileValue);
                } else if ("is_nullable".equalsIgnoreCase(keyStr)) {
                    columnJson.put((Object)"col_is_nullable", (Object)columnProfileValue);
                } else if ("col_name".equalsIgnoreCase(keyStr)) {
                    columnJson.put((Object)"col_name", (Object)columnProfileValue);
                }
                if (columnJson.get((Object)"count_all") != null && !"null".equals(columnJson.get((Object)"count_all"))) {
                    Double count_all;
                    if (columnJson.get((Object)"count_blanks") != null && !"null".equals(columnJson.get((Object)"count_blanks"))) {
                        count_all = Double.valueOf(String.valueOf(columnJson.get((Object)"count_all")));
                        Double count_blank = Double.valueOf(String.valueOf(columnJson.get((Object)"count_blanks")));
                        general_stats.put((Object)"p_missing", (Object)(count_blank / count_all * 100.0));
                    }
                    if (columnJson.get((Object)"count_empty") != null && !"null".equals(columnJson.get((Object)"count_empty"))) {
                        count_all = Double.valueOf(String.valueOf(columnJson.get((Object)"count_all")));
                        Double count_empty = Double.valueOf(String.valueOf(columnJson.get((Object)"count_empty")));
                        general_stats.put((Object)"p_empty", (Object)(count_empty / count_all * 100.0));
                    }
                    if (columnJson.get((Object)"count_distinct") != null && !"null".equals(columnJson.get((Object)"count_distinct"))) {
                        count_all = Double.valueOf(String.valueOf(columnJson.get((Object)"count_all")));
                        Double count_distinct = Double.valueOf(String.valueOf(columnJson.get((Object)"count_distinct")));
                        cat_stats.put((Object)"p_distinct", (Object)(count_distinct / count_all * 100.0));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(this.logFormat.getFormattedLog(), "For table : " + this.tableName + ", column base profile processing: Error", e);
            }
        });
    }

    private void sampleDataKeysOrder() {
    }

    private void processDetailedProfilingQueryResults() {
        this.queryResultsJsonArray.stream().forEach(result -> {
            try {
                JSONObject queryResult = (JSONObject)result;
                if (queryResult.containsKey((Object)"runJson")) {
                    JSONArray resultsArray = (JSONArray)((JSONObject)queryResult.get((Object)"runJson")).get((Object)"results");
                    String queryType = String.valueOf(queryResult.get((Object)"queryType"));
                    String columnName = String.valueOf(queryResult.get((Object)"columnName"));
                    JSONObject columnJson = (JSONObject)this.columns.get((Object)columnName);
                    JSONObject dataProfile = (JSONObject)columnJson.get((Object)"data_profile");
                    if (queryType.contains("data_profile.cat_stats.categories")) {
                        JSONObject cat_stats = (JSONObject)dataProfile.get((Object)"cat_stats");
                        JSONObject categories = (JSONObject)cat_stats.get((Object)"categories");
                        resultsArray.forEach(profileResult -> {
                            JSONObject colResult = (JSONObject)profileResult;
                            if (colResult.get((Object)"cnt") != null) {
                                categories.put((Object)String.valueOf(colResult.get((Object)columnName.toLowerCase())), (Object)Integer.valueOf(String.valueOf(colResult.get((Object)"cnt"))));
                            }
                        });
                    } else if (queryType.contains("data_profile.pattern_stats.patterns")) {
                        JSONObject patterns_stats = (JSONObject)dataProfile.get((Object)"pattern_stats");
                        JSONObject patterns = (JSONObject)patterns_stats.get((Object)"patterns");
                        resultsArray.forEach(profileResult -> {
                            JSONObject colResult = (JSONObject)profileResult;
                            if (colResult.get((Object)"cnt") != null) {
                                patterns.put((Object)String.valueOf(colResult.get((Object)columnName.toLowerCase())), (Object)Integer.valueOf(String.valueOf(colResult.get((Object)"cnt"))));
                            }
                        });
                    } else if (queryType.contains("data_profile.num_stats.histograms")) {
                        JSONObject num_stats = (JSONObject)dataProfile.get((Object)"num_stats");
                        JSONObject histograms = (JSONObject)num_stats.get((Object)"histograms");
                        resultsArray.forEach(profileResult -> {
                            JSONObject colResult = (JSONObject)profileResult;
                            if (colResult.get((Object)"cnt") != null) {
                                histograms.put((Object)String.valueOf(colResult.get((Object)columnName.toLowerCase())), (Object)Integer.valueOf(String.valueOf(colResult.get((Object)"cnt"))));
                            }
                        });
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(this.logFormat.getFormattedLog(), "For table : " + this.tableName + ", error processing detailed profiling results: Error: ", e);
            }
        });
    }

    private void executeSamplesQuery() {
        try {
            String samplesQuery = String.valueOf(this.queriesTempalte.get((Object)"sample_query"));
            if (samplesQuery != null) {
                samplesQuery = samplesQuery.replace("$COLNAMES$", "*");
                samplesQuery = samplesQuery.replace("$CHANGEMETABLE$", this.modifiedTableNameWithSchema);
            }
            this.executeQuery(samplesQuery, "sample_query", "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getQueryResults() {
        if (this.futureResults == null || this.futureResults.size() <= 0) {
            return;
        }
        for (Future<JSONObject> queryResults : this.futureResults) {
            try {
                if (queryResults.get() == null || queryResults.get().isEmpty()) continue;
                this.queryResultsJsonArray.add((Object)queryResults.get());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void executeTableBaseProfilingQuery() {
        try {
            String base_profile_query = String.valueOf(this.queriesTempalte.get((Object)"base_table_profile"));
            if (base_profile_query != null) {
                base_profile_query = base_profile_query.replace("$CHANGEMETABLE$", this.modifiedTableNameWithSchema);
                this.executeQuery(base_profile_query, "base_table_profile_" + this.tableName, "");
            }
        }
        catch (Exception e) {
            logger.error(this.logFormat.getFormattedLog(), "For table : " + this.tableName + ", table base profile error: " + this.tableName, e);
        }
    }

    private void executeColumsBaseProfileQuery() {
        if (this.columns != null) {
            this.columns.keySet().forEach(colName -> {
                try {
                    JSONObject columnMeata = (JSONObject)this.columns.get(colName);
                    String columnType = String.valueOf(columnMeata.get((Object)"type_name")).toUpperCase();
                    String table_name = String.valueOf(columnMeata.get((Object)"table_name"));
                    String column_name = String.valueOf(columnMeata.get((Object)"col_name"));
                    String modified_column_name = ProfileTable.modifyColName(column_name, this.escapeChar);
                    if (String.valueOf(this.columnDataTypes.get((Object)columnType)).equalsIgnoreCase("NUM")) {
                        String query = String.valueOf(this.numberTypeColProfileQueries.get((Object)"BASE_PRF"));
                        this.executeColumnBaseProfile(query, modified_column_name, table_name, column_name);
                    } else if (String.valueOf(this.columnDataTypes.get((Object)columnType)).equalsIgnoreCase("DTE")) {
                        String query = String.valueOf(this.dateTypeColProfileQueries.get((Object)"BASE_PRF"));
                        this.executeColumnBaseProfile(query, modified_column_name, table_name, column_name);
                    } else if (String.valueOf(this.columnDataTypes.get((Object)columnType)).equalsIgnoreCase("BOL")) {
                        String query = String.valueOf(this.boolTypeColumnProfileQueries.get((Object)"BASE_PRF"));
                        this.executeColumnBaseProfile(query, modified_column_name, table_name, column_name);
                    } else {
                        String query = String.valueOf(this.stringTypeColumnProfileQueries.get((Object)"BASE_PRF"));
                        this.executeColumnBaseProfile(query, modified_column_name, table_name, column_name);
                    }
                }
                catch (Exception e) {
                    logger.error(this.logFormat.getFormattedLog(), "For table : " + this.tableName + ", column base profile Error: [" + this.tableName + "][" + colName + "]", e);
                }
            });
        }
    }

    private void executeAllColumnsDetailedProfiling() {
        if (this.columns != null) {
            this.columns.keySet().forEach(colName -> {
                try {
                    JSONObject columnMeata = (JSONObject)this.columns.get(colName);
                    String columnType = String.valueOf(columnMeata.get((Object)"type_name")).toUpperCase();
                    String table_name = String.valueOf(columnMeata.get((Object)"table_name"));
                    String column_name = String.valueOf(columnMeata.get((Object)"col_name"));
                    String modified_column_name = ProfileTable.modifyColName(column_name, this.escapeChar);
                    Integer count_distinct = columnMeata.get((Object)"count_distinct") != null && Util.isNotNullOrEmpty(String.valueOf(columnMeata.get((Object)"count_distinct"))) ? Integer.valueOf(String.valueOf(columnMeata.get((Object)"count_distinct"))) : 0;
                    if ("NUM".equalsIgnoreCase(String.valueOf(this.columnDataTypes.get((Object)columnType)))) {
                        if (count_distinct <= this.categoryUniqueCount) {
                            String categoriesQuery = String.valueOf(this.numberTypeColProfileQueries.get((Object)"data_profile.cat_stats.categories"));
                            categoriesQuery = categoriesQuery.replaceAll("\\$CHANGEME\\$", modified_column_name).replaceAll("\\$CHANGEMETABLE\\$", this.modifiedTableNameWithSchema);
                            this.executeCataegoriesQuery(categoriesQuery, "data_profile.cat_stats.categories_" + column_name, column_name);
                        }
                        String histoGramQuery = String.valueOf(this.numberTypeColProfileQueries.get((Object)"data_profile.num_stats.histograms"));
                        JSONObject columnBaseProfile = (JSONObject)this.columns.get((Object)column_name);
                        String min_value = String.valueOf(columnBaseProfile.get((Object)"min_value"));
                        String max_value = String.valueOf(columnBaseProfile.get((Object)"max_value"));
                        Double vInterval = 1.0;
                        if (Util.isNotNullOrEmpty(max_value) && Util.isNotNullOrEmpty(min_value) && Util.isNotNullOrEmpty(histoGramQuery) && !min_value.equalsIgnoreCase(max_value)) {
                            min_value = !Util.isNullOrEmpty(min_value) ? min_value : "0";
                            vInterval = Double.valueOf(max_value) - Double.valueOf(min_value);
                            double vRoundFactor = Math.pow(10.0, Math.floor(Math.log10(vInterval)) - 1.0);
                            double vRoundInterval = Math.ceil(vInterval / 20.0 / vRoundFactor) * vRoundFactor;
                            double vRoundMinValue = Math.floor(Double.valueOf(min_value) / vRoundInterval) * vRoundInterval;
                            histoGramQuery = histoGramQuery.replaceAll("\\$CHANGEME\\$", modified_column_name).replaceAll("\\$CHANGEMETABLE\\$", this.modifiedTableNameWithSchema);
                            histoGramQuery = histoGramQuery.replaceAll("\\$CHANGEMEMINVAL\\$", min_value).replaceAll("\\$CHANGEMEMAXVAL\\$", max_value);
                            histoGramQuery = histoGramQuery.replaceAll("\\$CHANGEMEINTERVAL\\$", String.valueOf(vInterval));
                            histoGramQuery = histoGramQuery.replaceAll("\\$CHANGEMEBUCKETS\\$", "10");
                            histoGramQuery = histoGramQuery.replaceAll("\\$CHANGEMEROUNDMINVAL\\$", String.valueOf(vRoundMinValue));
                            histoGramQuery = histoGramQuery.replaceAll("\\$CHANGEMEROUNDINTERVAL\\$", String.valueOf(vRoundInterval));
                            this.executeHistoGramQuery(histoGramQuery, "data_profile.num_stats.histograms_" + column_name, column_name);
                        }
                        if (count_distinct < this.patternCount) {
                            String patternQuery = String.valueOf(this.numberTypeColProfileQueries.get((Object)"data_profile.pattern_stats.patterns"));
                            patternQuery = patternQuery.replaceAll("\\$CHANGEME\\$", modified_column_name).replaceAll("\\$CHANGEMETABLE\\$", this.modifiedTableNameWithSchema);
                            this.executePatternQuery(patternQuery, "data_profile.pattern_stats.patterns_" + column_name, column_name);
                        }
                    } else if ("DTE".equalsIgnoreCase(String.valueOf(this.columnDataTypes.get((Object)columnType)))) {
                        if (count_distinct <= this.categoryUniqueCount) {
                            String categoriesQuery = String.valueOf(this.dateTypeColProfileQueries.get((Object)"data_profile.cat_stats.categories"));
                            categoriesQuery = categoriesQuery.replaceAll("\\$CHANGEME\\$", modified_column_name).replaceAll("\\$CHANGEMETABLE\\$", this.modifiedTableNameWithSchema);
                            this.executeCataegoriesQuery(categoriesQuery, "data_profile.cat_stats.categories_" + column_name, column_name);
                        }
                        JSONObject columnBaseProfile = (JSONObject)this.columns.get((Object)column_name);
                        String min_value = String.valueOf(columnBaseProfile.get((Object)"min_value"));
                        String max_value = String.valueOf(columnBaseProfile.get((Object)"max_value"));
                        String histoGramQuery = String.valueOf(this.dateTypeColProfileQueries.get((Object)"data_profile.num_stats.histograms"));
                        if (Util.isNotNullOrEmpty(max_value) && Util.isNotNullOrEmpty(min_value) && Util.isNotNullOrEmpty(histoGramQuery)) {
                            histoGramQuery = TemplateQueries.getHistogramDateColumnQuery(this.dateTypeColProfileQueries.get((Object)"data_profile.num_stats.histograms"), min_value, max_value, modified_column_name, this.modifiedTableNameWithSchema);
                            this.executeHistoGramQuery(histoGramQuery, "data_profile.num_stats.histograms_" + column_name, column_name);
                        }
                    } else if ("BOL".equalsIgnoreCase(String.valueOf(this.columnDataTypes.get((Object)columnType)))) {
                        if (count_distinct <= this.categoryUniqueCount) {
                            String categoriesQuery = String.valueOf(this.boolTypeColumnProfileQueries.get((Object)"data_profile.cat_stats.categories"));
                            categoriesQuery = categoriesQuery.replaceAll("\\$CHANGEME\\$", modified_column_name).replaceAll("\\$CHANGEMETABLE\\$", this.modifiedTableNameWithSchema);
                            this.executeCataegoriesQuery(categoriesQuery, "data_profile.cat_stats.categories_" + column_name, column_name);
                        }
                    } else {
                        if (count_distinct <= this.categoryUniqueCount) {
                            String categoriesQuery = String.valueOf(this.stringTypeColumnProfileQueries.get((Object)"data_profile.cat_stats.categories"));
                            categoriesQuery = categoriesQuery.replaceAll("\\$CHANGEME\\$", modified_column_name).replaceAll("\\$CHANGEMETABLE\\$", this.modifiedTableNameWithSchema);
                            this.executeCataegoriesQuery(categoriesQuery, "data_profile.cat_stats.categories_" + column_name, column_name);
                        }
                        if (count_distinct < this.patternCount) {
                            String patternQuery = String.valueOf(this.stringTypeColumnProfileQueries.get((Object)"data_profile.pattern_stats.patterns"));
                            patternQuery = patternQuery.replaceAll("\\$CHANGEME\\$", modified_column_name).replaceAll("\\$CHANGEMETABLE\\$", this.modifiedTableNameWithSchema);
                            this.executePatternQuery(patternQuery, "data_profile.pattern_stats.patterns_" + column_name, column_name);
                        }
                    }
                }
                catch (Exception e) {
                    logger.error(this.logFormat.getFormattedLog(), "For table : " + this.tableName + ", column Details profile Error: [" + this.tableName + "][" + colName + "]", e);
                }
            });
        }
    }

    private void executeCataegoriesQuery(String query, String queryType, String columnName) {
        this.executeQuery(query, queryType, columnName);
    }

    private void executeHistoGramQuery(String query, String queryType, String columnName) {
        this.executeQuery(query, queryType, columnName);
    }

    private void executePatternQuery(String query, String queryType, String columnName) {
        this.executeQuery(query, queryType, columnName);
    }

    private void executeColumnBaseProfile(String query, String column_name, String table_name, String original_column_name) {
        query = query.replaceAll("\\$CHANGEME\\$", column_name);
        query = query.replaceAll("\\$CHANGEMETABLE\\$", this.modifiedTableNameWithSchema);
        this.executeQuery(query, "base_column_profile_" + original_column_name, original_column_name);
    }

    private String getQuery(String tempalteQuery) {
        String query = tempalteQuery.replaceAll("\r\n", "");
        query = query.replace("$SCHEMA_NAMES$", this.connectionInfo.get((Object)"schema_names").toString());
        query = query.replace("$DATABASE_NAME$", this.connectionInfo.get((Object)"db_name").toString());
        return query;
    }

    private void executeQuery(String query, String queryType, String columnName) {
        try {
            JSONObject newConnection = new JSONObject();
            newConnection.putAll((Map)this.connectionInfo);
            newConnection.put((Object)"runQuery", (Object)query);
            newConnection.put((Object)"queryType", (Object)queryType);
            newConnection.put((Object)"columnName", (Object)columnName);
            newConnection.put((Object)"source_type", (Object)String.valueOf(this.scanSourceMeataData.get((Object)"source_type")));
            if (Util.isNotNullOrEmpty(query)) {
                QueryExecutor queryExecutor = new QueryExecutor(this.dataSourceFactory, newConnection, true, this.logFormat);
                Future future = this.executorService.submit(queryExecutor);
                this.futureResults.add(future);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(this.logFormat.getFormattedLog(), "For table : " + this.tableName + ", while executing query :" + query + ", this Error occurred : ", e);
        }
    }

    private void waitForExecutorServiceToTerminate(ExecutorService executorService) {
        while (!executorService.isTerminated()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void createColumsProfilingSubObjects() {
        if (this.columns != null) {
            this.columns.keySet().forEach(colName -> {
                try {
                    JSONObject columnMeata = (JSONObject)this.columns.get(colName);
                    JSONObject data_profile_json = new JSONObject();
                    JSONObject cat_stats = new JSONObject();
                    cat_stats.put((Object)"categories", (Object)new JSONObject());
                    JSONObject num_stats = new JSONObject();
                    num_stats.put((Object)"histograms", (Object)new JSONObject());
                    JSONObject pattern_stats = new JSONObject();
                    pattern_stats.put((Object)"patterns", (Object)new JSONObject());
                    data_profile_json.put((Object)"cat_stats", (Object)cat_stats);
                    data_profile_json.put((Object)"num_stats", (Object)num_stats);
                    data_profile_json.put((Object)"pattern_stats", (Object)pattern_stats);
                    data_profile_json.put((Object)"general_stats", (Object)new JSONObject());
                    data_profile_json.put((Object)"length_stats", (Object)new JSONObject());
                    columnMeata.put((Object)"data_profile", (Object)data_profile_json);
                }
                catch (Exception e) {
                    logger.error(this.logFormat.getFormattedLog(), "For table : " + this.tableName + e);
                }
            });
        }
    }

    private void writeJsonToFile(String filepath) {
        logger.info(this.logFormat.getFormattedLog(), "dumping output json for " + this.tableName + "  to local file at: " + filepath);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileWriter file = new FileWriter(filepath);){
                file.write(this.profileJson.toJSONString());
                file.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

