/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.model.scan;

import com.dvsum.factory.DataSourceFactory;
import com.dvsum.logger.CustomLogger;
import com.dvsum.logger.LogFormat;
import com.dvsum.model.QueryExecutor;
import com.dvsum.model.scan.Catalog;
import com.dvsum.util.FileUtil;
import com.dvsum.util.JsonUtil;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class Profile {
    private static final CustomLogger logger = CustomLogger.getLogger(Catalog.class);
    private DataSourceFactory dataSourceFactory;
    JSONObject scanSourceMeataData;
    JSONObject connectionInfo;
    ExecutorService executorService;
    JSONObject catalogQueries;
    JSONObject profileQueries;
    JSONObject queriesTempalte;
    JSONObject columnsMetaData;
    JSONObject constraintsMetaData;
    JSONObject tablesMetaData;
    JSONArray catalogResultsJsonArray;
    LogFormat logFormat;

    public Profile(ExecutorService executorService, JSONObject scanSourceMeataData, DataSourceFactory dataSourceFactory, LogFormat logFormat) {
        this.scanSourceMeataData = scanSourceMeataData;
        this.dataSourceFactory = dataSourceFactory;
        this.connectionInfo = (JSONObject)this.scanSourceMeataData.get((Object)"connection_config");
        this.connectionInfo = (JSONObject)this.scanSourceMeataData.get((Object)"connection_config");
        this.queriesTempalte = (JSONObject)this.scanSourceMeataData.get((Object)"queries_template");
        this.profileQueries = (JSONObject)this.queriesTempalte.get((Object)"profile");
        this.logFormat = logFormat;
    }

    public JSONArray executeProfileQueries() {
        long startTime = System.currentTimeMillis();
        String dvttdRecords = null;
        logger.debug("***************** Profie Execution Started ********************");
        try {
            JsonUtil jsonUtil = new JsonUtil();
            Integer poolSize = Integer.parseInt(FileUtil.getPropertyWithDefault("max.database.connection.allowed", "10"));
            ExecutorService executorService = Executors.newFixedThreadPool(poolSize);
            ArrayList catalogResults = new ArrayList();
            this.catalogResultsJsonArray = new JSONArray();
            Set keys = this.catalogQueries.keySet();
            for (String string : keys) {
                this.connectionInfo.put((Object)"runQuery", (Object)this.getQuery(this.catalogQueries.get((Object)string).toString()));
                this.connectionInfo.put((Object)"queryType", (Object)string);
                this.connectionInfo.put((Object)"columName", (Object)string);
                QueryExecutor queryExecutor = new QueryExecutor(this.dataSourceFactory, this.connectionInfo, true, this.logFormat);
                Future future = executorService.submit(queryExecutor);
                catalogResults.add(future);
            }
            for (Future future : catalogResults) {
                System.out.println("iteration over future");
                if (future.get() == null || ((JSONObject)future.get()).isEmpty()) continue;
                this.catalogResultsJsonArray.add(future.get());
            }
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"catalog", (Object)this.catalogResultsJsonArray.toString());
            return this.catalogResultsJsonArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info("dvttdrecords: " + dvttdRecords);
            logger.error("Error ", e);
            long endTime = System.currentTimeMillis();
            float executionTime = (endTime - startTime) / 1000L;
            logger.debug("Execution  Time (sec) ****** " + executionTime);
            logger.debug("***************** Profile Execution Completed ********************");
            return null;
        }
    }

    private String getQuery(String tempalteQuery) {
        String query = tempalteQuery.replaceAll("\r\n", "").replaceAll("$SCHEMA_NAMES$", this.connectionInfo.get((Object)"schema_names").toString());
        query = query.replace("$SCHEMA_NAMES$", this.connectionInfo.get((Object)"schema_names").toString());
        query = query.replace("$DATABASE_NAME$", this.connectionInfo.get((Object)"db_name").toString());
        System.out.println(this.connectionInfo.get((Object)"schema_names").toString());
        System.out.println(this.connectionInfo.get((Object)"db_name").toString());
        System.out.println("----" + query);
        return query;
    }
}

