/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.model.scan;

import com.dvsum.factory.DataSourceFactory;
import com.dvsum.logger.CustomLogger;
import com.dvsum.logger.LogFormat;
import com.dvsum.model.QueryExecutor;
import com.dvsum.util.FileUtil;
import com.dvsum.util.JsonUtil;
import com.dvsum.util.Util;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.json.simple.JSONObject;

public class LogQueryService {
    private static final CustomLogger logger = CustomLogger.getLogger(LogQueryService.class);
    private DataSourceFactory dataSourceFactory;
    JSONObject scanSourceMeataData;
    JSONObject connectionInfo;
    ExecutorService executorService;
    JSONObject catalogQueries;
    String querySQL;
    JSONObject queriesTempalte;
    JSONObject queryLogResultsJson;
    LogFormat logFormat;

    public LogQueryService(JSONObject scanSourceMeataData, DataSourceFactory dataSourceFactory, String querySQL, LogFormat logFormat) {
        this.scanSourceMeataData = scanSourceMeataData;
        this.dataSourceFactory = new DataSourceFactory();
        this.connectionInfo = (JSONObject)this.scanSourceMeataData.get((Object)"connection_config");
        this.queriesTempalte = (JSONObject)this.scanSourceMeataData.get((Object)"queries_template");
        this.querySQL = querySQL;
        this.logFormat = logFormat;
    }

    public JSONObject executeQuery() {
        long startTime = System.currentTimeMillis();
        this.queryLogResultsJson = new JSONObject();
        ArrayList queryLogResults = new ArrayList();
        try {
            if (Util.isNullOrEmpty(this.querySQL)) {
                logger.debug(this.logFormat.getFormattedLog(), "Log query is Null or Empty");
                return this.queryLogResultsJson;
            }
            JsonUtil jsonUtil = new JsonUtil();
            Integer poolSize = Integer.parseInt(FileUtil.getPropertyWithDefault("max.database.connection.allowed", "10"));
            ExecutorService executorService = Executors.newFixedThreadPool(poolSize);
            String query = this.getQuery(this.querySQL);
            String key = "QRY_LOG";
            String isCdataSrc = String.valueOf(this.scanSourceMeataData.get((Object)"is_cdata_src"));
            String sourceType = String.valueOf(this.scanSourceMeataData.get((Object)"source_type"));
            JSONObject newConnection = new JSONObject();
            newConnection.putAll((Map)this.connectionInfo);
            newConnection.put((Object)"runQuery", (Object)query);
            newConnection.put((Object)"queryType", (Object)key);
            newConnection.put((Object)"source_type", (Object)sourceType);
            newConnection.put((Object)"is_cdata_src", (Object)isCdataSrc);
            QueryExecutor queryExecutor = new QueryExecutor(this.dataSourceFactory, newConnection, false, this.logFormat);
            Future queryLogResultFuture = executorService.submit(queryExecutor);
            if (queryLogResultFuture.get() != null && !((JSONObject)queryLogResultFuture.get()).isEmpty()) {
                this.queryLogResultsJson = (JSONObject)queryLogResultFuture.get();
            }
            return this.queryLogResultsJson;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(this.logFormat.getFormattedLog(), "Error ", e);
            long endTime = System.currentTimeMillis();
            float executionTime = (endTime - startTime) / 1000L;
            return this.queryLogResultsJson;
        }
    }

    public String getQuery(String tempalteQuery) {
        int IS_ALL_SCHEMAS_INCLUDED = 0;
        try {
            if (this.connectionInfo.get((Object)"is_schemas_specified") != null) {
                boolean isSchemasSpecified = (Boolean)this.connectionInfo.get((Object)"is_schemas_specified");
                IS_ALL_SCHEMAS_INCLUDED = isSchemasSpecified ? 1 : 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(this.logFormat.getFormattedLog(), "Error Trace : ", e);
        }
        String query = Util.isNotNullOrEmpty(tempalteQuery) ? tempalteQuery.replaceAll("\r\n", "") : "";
        this.querySQL = Util.isNotNullOrEmpty(query) ? query.replace("$SCHEMA_NAMES$", this.connectionInfo.get((Object)"schema_names").toString()) : "";
        String string = this.querySQL = Util.isNotNullOrEmpty(query) ? query.replace("$IS_ALL_SCHEMAS_INCLUDED$", String.valueOf(IS_ALL_SCHEMAS_INCLUDED)) : "";
        if (Util.isNotNullOrEmpty(query) && query.contains("$DATABASE_NAME$")) {
            this.querySQL = query.replace("$DATABASE_NAME$", this.connectionInfo.get((Object)"db_name").toString());
        }
        return this.querySQL;
    }
}

