/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.model.scan;

import com.dvsum.factory.DataSourceFactory;
import com.dvsum.logger.CustomLogger;
import com.dvsum.logger.LogFormat;
import com.dvsum.model.QueryExecutor;
import com.dvsum.model.scan.LogQueryService;
import com.dvsum.util.FileUtil;
import com.dvsum.util.JsonUtil;
import com.dvsum.util.MultipartFileUploader;
import com.dvsum.util.Util;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class Catalog {
    private static final CustomLogger logger = CustomLogger.getLogger(Catalog.class);
    private DataSourceFactory dataSourceFactory;
    JSONObject scanSourceMeataData;
    JSONObject connectionInfo;
    ExecutorService executorService;
    JSONObject catalogQueries;
    JSONObject profileQueries;
    JSONObject queriesTempalte;
    JSONObject columnsMetaData;
    JSONObject constraintsMetaData;
    JSONObject tablesMetaData;
    JSONArray catalogResultsJsonArray;
    LogFormat logFormat;

    public Catalog(JSONObject scanSourceMeataData, DataSourceFactory dataSourceFactory, LogFormat logFormat) {
        this.scanSourceMeataData = scanSourceMeataData;
        this.dataSourceFactory = new DataSourceFactory();
        this.connectionInfo = (JSONObject)this.scanSourceMeataData.get((Object)"connection_config");
        this.connectionInfo = (JSONObject)this.scanSourceMeataData.get((Object)"connection_config");
        this.queriesTempalte = (JSONObject)this.scanSourceMeataData.get((Object)"queries_template");
        this.catalogQueries = (JSONObject)this.queriesTempalte.get((Object)"catalog");
        this.profileQueries = (JSONObject)this.queriesTempalte.get((Object)"profile");
        this.logFormat = logFormat;
    }

    public Object[] executeCatalogQueries() {
        long startTime = System.currentTimeMillis();
        Object dvttdRecords = null;
        this.catalogResultsJsonArray = new JSONArray();
        try {
            JsonUtil jsonUtil = new JsonUtil();
            Integer poolSize = Integer.parseInt(FileUtil.getPropertyWithDefault("max.database.connection.allowed", "10"));
            ExecutorService executorService = Executors.newFixedThreadPool(poolSize);
            ArrayList catalogResults = new ArrayList();
            Set keys = this.catalogQueries.keySet();
            for (String string : keys) {
                if (string.equalsIgnoreCase("QRY_LOG")) {
                    try {
                        try {
                            String querySQL = (String)this.catalogQueries.get((Object)"QRY_LOG");
                            LogQueryService queryLog = new LogQueryService(this.scanSourceMeataData, this.dataSourceFactory, querySQL, this.logFormat);
                            JSONObject queryLogResultsJson = queryLog.executeQuery();
                            String executionId = String.valueOf(this.scanSourceMeataData.get((Object)"execution_id"));
                            JSONObject s3PreSignedURLInfo = (JSONObject)this.scanSourceMeataData.get((Object)"s3_pre_signed_post_url");
                            int sourceId = ((Long)((JSONObject)this.scanSourceMeataData.get((Object)"connection_config")).get((Object)"source_id")).intValue();
                            String baseFilePath = "./scan_output/" + executionId + "/";
                            String jsonFilePath = String.valueOf(baseFilePath) + sourceId + "_queries.json";
                            FileUtil.writeJsonToFile(jsonFilePath, queryLogResultsJson);
                            MultipartFileUploader.uploadFileToS3(jsonFilePath, s3PreSignedURLInfo, this.logFormat);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            logger.error("Error = ", e);
                        }
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                JSONObject newConnection = new JSONObject();
                newConnection.putAll((Map)this.connectionInfo);
                newConnection.put((Object)"runQuery", (Object)this.getQuery(this.catalogQueries.get((Object)string).toString()));
                newConnection.put((Object)"queryType", (Object)string);
                newConnection.put((Object)"source_type", (Object)String.valueOf(this.scanSourceMeataData.get((Object)"source_type")));
                newConnection.put((Object)"is_cdata_src", (Object)String.valueOf(this.scanSourceMeataData.get((Object)"is_cdata_src")));
                String query = this.getQuery(this.catalogQueries.get((Object)string).toString());
                if ("CONS_META".equalsIgnoreCase(string) && "true".equalsIgnoreCase(String.valueOf(this.scanSourceMeataData.get((Object)"is_cdata_src")))) {
                    JSONObject foreignKeyConstraint = new JSONObject();
                    foreignKeyConstraint.putAll((Map)newConnection);
                    foreignKeyConstraint.put((Object)"queryType", (Object)"CONS_META_FOREIGN");
                    QueryExecutor foreignkeyExecutor = new QueryExecutor(this.dataSourceFactory, foreignKeyConstraint, true, this.logFormat);
                    Future future = executorService.submit(foreignkeyExecutor);
                    catalogResults.add(future);
                }
                QueryExecutor queryExecutor = new QueryExecutor(this.dataSourceFactory, newConnection, true, this.logFormat);
                Future future = executorService.submit(queryExecutor);
                catalogResults.add(future);
            }
            for (Future future : catalogResults) {
                if (future.get() == null || ((JSONObject)future.get()).isEmpty()) continue;
                this.catalogResultsJsonArray.add(future.get());
            }
            return new Object[]{this.catalogResultsJsonArray, executorService};
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error ", e);
            long endTime = System.currentTimeMillis();
            float executionTime = (endTime - startTime) / 1000L;
            logger.debug("Execution  Time (sec) ****** " + executionTime);
            logger.debug("***************** Catalog Execution Completed ********************");
            return new Object[]{this.catalogResultsJsonArray, this.executorService};
        }
    }

    private String getQuery(String tempalteQuery) {
        int IS_ALL_SCHEMAS_INCLUDED = 0;
        try {
            if (this.connectionInfo.get((Object)"is_schemas_specified") != null) {
                boolean isSchemasSpecified = (Boolean)this.connectionInfo.get((Object)"is_schemas_specified");
                IS_ALL_SCHEMAS_INCLUDED = isSchemasSpecified ? 1 : 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error Trace : ", e);
        }
        String query = Util.isNotNullOrEmpty(tempalteQuery) ? tempalteQuery.replaceAll("\r\n", "") : "";
        query = Util.isNotNullOrEmpty(query) ? query.replace("$SCHEMA_NAMES$", this.connectionInfo.get((Object)"schema_names").toString()) : "";
        String string = query = Util.isNotNullOrEmpty(query) ? query.replace("$IS_ALL_SCHEMAS_INCLUDED$", String.valueOf(IS_ALL_SCHEMAS_INCLUDED)) : "";
        if (Util.isNotNullOrEmpty(query) && query.contains("$DATABASE_NAME$")) {
            query = query.replace("$DATABASE_NAME$", this.connectionInfo.get((Object)"db_name").toString());
        }
        return query;
    }
}

