/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.model;

import com.dvsum.dataSource.DataSource;
import com.dvsum.factory.DataSourceFactory;
import com.dvsum.logger.CustomLogger;
import com.dvsum.logger.LogFormat;
import com.dvsum.model.ref.RefDBType;
import com.dvsum.util.FileUtil;
import com.dvsum.util.JsonUtil;
import com.dvsum.util.Util;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Callable;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class QueryExecutor
implements Callable {
    private static final CustomLogger logger = CustomLogger.getLogger(QueryExecutor.class);
    private static final Long Default_Result_To_JSON_Limit = 70000L;
    private DataSourceFactory dataSourceFactory;
    private JSONObject dataSourceConnectionInfo;
    private JSONObject queryResult;
    private JSONArray queryResultArray;
    private JSONObject responseObject;
    private ArrayList<String> resultList;
    private int threadId;
    private boolean convertResultToList = false;
    private JsonUtil jsonUtil;
    private boolean resultToMap;
    private String certType;
    private String postQueryResultURL;
    private JSONObject exportJSONOption;
    private DataSource dataSource;
    private String queryType;
    private String sourceType;
    private String runQuery;
    private Boolean isCdataSrc;
    private Boolean isCatalogQuery;
    private Boolean isAnalyticsQuery = false;
    private LogFormat logFormat;
    private String queryId;

    public QueryExecutor(DataSourceFactory dataSourceFactory, JSONObject connectionInfo, boolean isCataloging, LogFormat logFormat) {
        this.dataSourceFactory = dataSourceFactory;
        this.dataSourceConnectionInfo = connectionInfo;
        this.resultList = this.resultList;
        this.convertResultToList = this.convertResultToList;
        this.jsonUtil = new JsonUtil();
        this.resultToMap = false;
        if (connectionInfo.get((Object)"is_analytics_query") != null) {
            this.isAnalyticsQuery = connectionInfo.get((Object)"is_analytics_query") == "true";
        }
        this.queryId = connectionInfo.containsKey((Object)"query_id") ? String.valueOf(connectionInfo.get((Object)"query_id")) : "";
        this.queryResult = new JSONObject();
        this.queryResult.put((Object)"queryType", (Object)connectionInfo.get((Object)"queryType").toString());
        this.queryResult.put((Object)"queryId", connectionInfo.containsKey((Object)"queryId") ? connectionInfo.get((Object)"queryId") : null);
        this.queryResult.put((Object)"name", connectionInfo.containsKey((Object)"name") ? connectionInfo.get((Object)"name") : null);
        this.queryResult.put((Object)"runQuery", (Object)connectionInfo.get((Object)"runQuery").toString());
        if (connectionInfo.get((Object)"columnName") != null) {
            this.queryResult.put((Object)"columnName", (Object)connectionInfo.get((Object)"columnName").toString());
        }
        if (connectionInfo.get((Object)"query_metadata") != null) {
            this.queryResult.put((Object)"query_metadata", (Object)connectionInfo.get((Object)"query_metadata").toString());
        }
        this.queryResultArray = new JSONArray();
        this.certType = this.certType;
        this.postQueryResultURL = this.postQueryResultURL;
        this.queryType = String.valueOf(connectionInfo.get((Object)"queryType"));
        if ("sample_query".equalsIgnoreCase(this.queryType)) {
            this.jsonUtil.setkeyToLowercase(false);
        }
        this.logFormat = logFormat;
        this.dataSource = dataSourceFactory.getDataSource(String.valueOf(this.dataSourceConnectionInfo.get((Object)"source_type")), this.dataSourceConnectionInfo, isCataloging, logFormat);
        this.runQuery = String.valueOf(this.dataSourceConnectionInfo.get((Object)"runQuery"));
        this.sourceType = String.valueOf(this.dataSourceConnectionInfo.get((Object)"source_type"));
        this.isCdataSrc = "true".equalsIgnoreCase(String.valueOf(this.dataSourceConnectionInfo.get((Object)"is_cdata_src")));
        this.isCatalogQuery = "COLS_META".equalsIgnoreCase(this.queryType) || "TBLS_META".equalsIgnoreCase(this.queryType) || "CONS_META".equalsIgnoreCase(this.queryType) || "CONS_META_FOREIGN".equalsIgnoreCase(this.queryType);
    }

    public JSONObject call() throws Exception {
        String dbType = this.dataSourceConnectionInfo != null ? this.dataSourceConnectionInfo.get((Object)"source_type").toString() : null;
        long startTime = System.currentTimeMillis();
        this.executeQuery(dbType);
        long endTime = System.currentTimeMillis();
        long totalTime = (endTime - startTime) / 1000L;
        if (Util.isNotNullOrEmpty(this.runQuery) && totalTime >= 180L) {
            logger.debug(this.logFormat.getFormattedLog(), "Query Execution Time : " + totalTime + ", for Query Type : " + this.queryType);
        }
        this.cleanUp();
        return this.queryResult;
    }

    public JSONObject executeQuery(String dbType) throws Exception {
        block15: {
            try {
                try {
                    if (this.isCdataSrc.booleanValue() && this.isCatalogQuery.booleanValue()) {
                        this.dataSource.connect();
                        ResultSet resultSet = this.dataSource.executeCatalog(this.queryType);
                        this.jsonUtil.updateJsonWithResult(this.queryResult, resultSet, this.convertResultToList, this.resultList, this.isAnalyticsQuery);
                        break block15;
                    }
                    try {
                        this.executeSelectQueryOrProc(dbType);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        String exceptionMessage = e.getMessage().toLowerCase();
                        if (exceptionMessage.contains("timeout") && RefDBType.isAmazonS3(dbType)) {
                            logger.info(this.logFormat.getFormattedLog(), "Timeout exception, applying query limit");
                            String limitOnTimeout = FileUtil.getPropertyWithDefault("athena.datalimit.on.timeout", "10000000");
                            logger.info(this.logFormat.getFormattedLog(), this.runQuery);
                            String query = String.valueOf(this.runQuery) + " limit " + limitOnTimeout;
                            logger.info(this.logFormat.getFormattedLog(), query);
                            ResultSet resultSet = this.dataSource.executeSelectQuery(query);
                            break block15;
                        }
                        throw e;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error(this.logFormat.getFormattedLog(), " runError : " + e.getMessage());
                    logger.error(this.logFormat.getFormattedLog(), " Error Trace : ", e);
                    if (!this.isCdataSrc.booleanValue() || !this.isCatalogQuery.booleanValue()) {
                        logger.debug(this.logFormat.getFormattedLog(), " Errored query : " + this.runQuery);
                    } else {
                        logger.error(this.logFormat.getFormattedLog(), "There are no queries running to get the cataloging data by CDATA");
                    }
                    if (this.isAnalyticsQuery.booleanValue()) {
                        logger.error("Errored query id : ", this.queryId);
                    }
                    this.queryResult.put((Object)"runStatus", (Object)"-1");
                    this.queryResult.put((Object)"runError", (Object)e.getMessage());
                    if (this.isAnalyticsQuery.booleanValue()) {
                        throw e;
                    }
                    if (this.dataSource != null) {
                        this.dataSource.disconnect();
                    }
                }
            }
            finally {
                if (this.dataSource != null) {
                    this.dataSource.disconnect();
                }
            }
        }
        return this.queryResult;
    }

    private void mergeCDataConstraintResults(JSONObject forignKeyConstraints) {
        try {
            JSONArray primraykeyConstraints = (JSONArray)((JSONObject)this.queryResult.get((Object)"runJson")).get((Object)"results");
            JSONArray forignkeyConstraintsArr = (JSONArray)((JSONObject)forignKeyConstraints.get((Object)"runJson")).get((Object)"results");
            primraykeyConstraints.addAll((Collection)forignkeyConstraintsArr);
            logger.debug(this.logFormat.getFormattedLog(), primraykeyConstraints.toJSONString());
        }
        catch (Exception e) {
            logger.error(this.logFormat.getFormattedLog(), "cdata constraist merge", e);
        }
    }

    private void executeSelectQueryOrProc(String dbType) throws Exception {
        long startTime = System.currentTimeMillis();
        this.dataSource.connect();
        if (Util.isNotNullOrEmpty(this.runQuery)) {
            this.dataSource.prepareStatment(this.runQuery, this.convertResultToList, this.sourceType);
            ResultSet resultSet = this.dataSource.executeStatment(this.runQuery);
            if (!RefDBType.isExcel(dbType)) {
                resultSet.setFetchSize(10000);
            }
            this.jsonUtil.updateJsonWithResult(this.queryResult, resultSet, this.convertResultToList, this.resultList, this.isAnalyticsQuery);
        }
    }

    private JSONObject limitRunJsonObject(JSONObject queryResultObj) {
        block6: {
            try {
                int resultLimit = this.dataSourceConnectionInfo.get((Object)"resultLimit") != null ? Integer.parseInt(String.valueOf(this.dataSourceConnectionInfo.get((Object)"resultLimit"))) : 50000;
                JSONObject limitJson = new JSONObject();
                String runJsonStr = String.valueOf(queryResultObj.get((Object)"runJson"));
                if (!Util.isNotNullOrEmpty(runJsonStr)) {
                    JSONObject runJson = this.jsonUtil.parseStringToJsonObject(runJsonStr);
                    if (runJson != null && !runJson.isEmpty()) {
                        JSONObject newRunJson = new JSONObject();
                        JSONArray results = (JSONArray)runJson.get((Object)"results");
                        JSONArray limitedResult = new JSONArray();
                        int resultsLength = results.size();
                        Set keys = queryResultObj.keySet();
                        for (String key : keys) {
                            if ("runJson".equalsIgnoreCase(key)) continue;
                            limitJson.put((Object)key, queryResultObj.get((Object)key));
                        }
                        int i = 0;
                        while (i < resultsLength && i < resultLimit) {
                            limitedResult.add(results.get(i));
                            ++i;
                        }
                        newRunJson.put((Object)"results", (Object)limitedResult);
                        newRunJson.put((Object)"resultCount", runJson.get((Object)"resultCount"));
                        newRunJson.put((Object)"errors", (Object)String.valueOf(runJson.get((Object)"errors")));
                        limitJson.put((Object)"runJson", (Object)newRunJson.toString());
                        return limitJson;
                    }
                    break block6;
                }
                return queryResultObj;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return queryResultObj;
    }

    private void cleanUp() {
        System.gc();
    }

    public JSONObject getResponseObject() {
        return this.responseObject;
    }

    public ArrayList<String> getResultList() {
        return this.resultList;
    }

    public String getProperty(JSONObject obj, String prop) {
        return obj.get((Object)prop) != null ? String.valueOf(obj.get((Object)prop)) : null;
    }

    public DataSourceFactory getDataSourceFactory() {
        return this.dataSourceFactory;
    }

    public JSONObject getDataSourceConnectionInfo() {
        return this.dataSourceConnectionInfo;
    }

    public JSONObject getQueryResults() {
        return this.queryResult;
    }

    public boolean getconvertResultToList() {
        return this.convertResultToList;
    }

    public Long maxResultToJsonLimit(JSONObject metaData) {
        Long maxResultLimit = 70000L;
        try {
            JsonUtil jsonUtil = new JsonUtil();
            JSONObject exportJSONOption = jsonUtil.parseStringToJsonObject(String.valueOf(metaData.get((Object)"exportConfigs")));
            Long exportLimit = exportJSONOption != null && exportJSONOption.get((Object)"EXPORT_LIMIT") != null ? Long.valueOf(exportJSONOption.get((Object)"EXPORT_LIMIT").toString()) : Long.valueOf(this.getProperty(metaData, "resultLimit"));
            Long resultLimit = metaData != null && metaData.get((Object)"resultLimit") != null ? Long.valueOf(this.getProperty(metaData, "resultLimit")) : 300L;
            maxResultLimit = exportLimit != null && exportLimit > resultLimit ? exportLimit : resultLimit;
            return maxResultLimit;
        }
        catch (Exception e) {
            logger.error(this.logFormat.getFormattedLog(), "Exception: ", e);
            return maxResultLimit;
        }
    }

    public static JSONArray getRunJson(JSONObject jsonObject) {
        try {
            String runStatus = QueryExecutor.getRunStatus(jsonObject);
            if (runStatus.equalsIgnoreCase("0") && jsonObject.get((Object)"runJson") != null) {
                JSONObject runJson = (JSONObject)jsonObject.get((Object)"runJson");
                return (JSONArray)runJson.get((Object)"results");
            }
            return new JSONArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new JSONArray();
        }
    }

    public static String getRunStatus(JSONObject jsonObject) {
        return String.valueOf(jsonObject.get((Object)"runStatus"));
    }

    public static String getKeyOrders(JSONObject jsonObject) {
        JSONObject runJson = (JSONObject)jsonObject.get((Object)"runJson");
        return String.valueOf(runJson.get((Object)"keysOrder"));
    }

    public static String getRunError(JSONObject jsonObject) {
        return String.valueOf(jsonObject.get((Object)"runError"));
    }

    public static boolean checkRunStatus(JSONObject jsonObject) {
        return !QueryExecutor.getRunStatus(jsonObject).equalsIgnoreCase("-1");
    }
}

