/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.model;

import com.dvsum.factory.DataSourceFactory;
import com.dvsum.logger.CustomLogger;
import com.dvsum.logger.LogFormat;
import com.dvsum.model.Executable;
import com.dvsum.model.QueryExecutor;
import com.dvsum.model.ref.RefDBType;
import com.dvsum.util.CryptographicUtil;
import com.dvsum.util.FileUtil;
import com.dvsum.util.GzipUtil;
import com.dvsum.util.JsonUtil;
import com.dvsum.util.SelfSignedHttps;
import com.dvsum.util.TLSHttpsRequestor;
import com.dvsum.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class MSRRule
extends Executable {
    private static final CustomLogger logger = CustomLogger.getLogger(MSRRule.class);
    private JSONObject masterRule;
    private JSONObject slaveRule;
    private ArrayList<String> masterResultList = new ArrayList();
    private ArrayList<String> slaveResultList = new ArrayList();
    private ArrayList<String> mMinusSResultList = new ArrayList();
    private boolean convertResultToList;

    public MSRRule(ExecutorService executorService, DataSourceFactory dataSourceFactory, String certType, String postURL, LogFormat logFormat) {
        super(executorService, dataSourceFactory, certType, postURL, logFormat);
    }

    @Override
    public void execute() {
        this.excuteMasterRule();
        this.executeSlaveRule();
    }

    public void replaceDeltaListStringWithValue(JSONObject tempDebug) {
        String queryParamList;
        String sawsOperation = String.valueOf(tempDebug.get((Object)"SAWSOperation"));
        String sourceType = String.valueOf(tempDebug.get((Object)"sourceType"));
        if (Util.isNotNullOrEmpty(sawsOperation) && "INTE".equalsIgnoreCase(sawsOperation)) {
            logger.debug("Delta List intersection ");
            queryParamList = this.masterListIntersectSlaveList().toString().replace("[", "(").replace("]", ")");
        } else {
            logger.debug("Delta List Difference ");
            queryParamList = this.masterListMinusSlaveList().toString().replace("[", "(").replace("]", ")");
        }
        if (RefDBType.isExcelInMemorySource(sourceType)) {
            logger.debug("DeltaList " + queryParamList);
            tempDebug.put((Object)"queryParamList", (Object)queryParamList);
            if (tempDebug.get((Object)"queryJSON") != null && tempDebug.get((Object)"queryJSON").toString().contains("(DELTALIST)")) {
                tempDebug.put((Object)"queryJSON", (Object)tempDebug.get((Object)"queryJSON").toString().replace("(DELTALIST)", queryParamList));
            } else if (tempDebug.get((Object)"queryJSON") != null && tempDebug.get((Object)"queryJSON").toString().contains("('DELTALIST')")) {
                tempDebug.put((Object)"queryJSON", (Object)tempDebug.get((Object)"queryJSON").toString().replace("('DELTALIST')", queryParamList));
            }
        } else {
            logger.debug("DeltaList " + queryParamList);
            tempDebug.put((Object)"queryParamList", (Object)queryParamList);
            if (tempDebug.get((Object)"runQuery") != null && tempDebug.get((Object)"runQuery").toString().contains("(DELTALIST)")) {
                tempDebug.put((Object)"runQuery", (Object)tempDebug.get((Object)"runQuery").toString().replace("(DELTALIST)", queryParamList));
            } else if (tempDebug.get((Object)"runQuery") != null && tempDebug.get((Object)"runQuery").toString().contains("('DELTALIST')")) {
                tempDebug.put((Object)"runQuery", (Object)tempDebug.get((Object)"runQuery").toString().replace("('DELTALIST')", queryParamList));
            }
        }
    }

    public void excuteMasterRule() {
        logger.debug("Executing Master");
        if (this.masterRule != null && this.getExecutor() != null) {
            QueryExecutor queryExecutor = new QueryExecutor(this.getDataSourceFactory(), this.masterRule, false, this.logFormat);
            this.getExecutor().submit(queryExecutor);
        }
    }

    public void executeSlaveRule() {
        if (this.slaveRule != null && this.getExecutor() != null) {
            QueryExecutor queryExecutor = new QueryExecutor(this.getDataSourceFactory(), this.slaveRule, false, this.logFormat);
        }
    }

    @Override
    public void executeDependents() {
        this.convertResultToList = false;
        int i = 0;
        while (i < this.getDbInfoAndQueryList().size()) {
            this.replaceDeltaListStringWithValue((JSONObject)this.getDbInfoAndQueryList().get(i));
            if (this.getExecutor() != null && this.mMinusSResultList.size() > 0) {
                QueryExecutor queryExecutor = new QueryExecutor(this.getDataSourceFactory(), (JSONObject)this.getDbInfoAndQueryList().get(i), false, this.logFormat);
                this.getExecutor().submit(queryExecutor);
            } else {
                JSONObject rQueryRecord = (JSONObject)this.getDbInfoAndQueryList().get(i);
                rQueryRecord.put((Object)"runStatus", (Object)"0");
                this.getDbInfoAndQueryList().set(i, (Object)rQueryRecord);
                this.postQueryResults(rQueryRecord);
            }
            ++i;
        }
    }

    public ArrayList<String> masterListMinusSlaveList() {
        logger.debug("# of Elements in Master list " + this.masterResultList.size());
        this.masterResultList.removeAll(this.slaveResultList);
        this.mMinusSResultList = this.masterResultList;
        logger.debug("# of Elements in Slave List " + this.slaveResultList.size());
        logger.debug("M minus S " + Arrays.asList(this.mMinusSResultList));
        if (this.masterResultList.size() > 1000) {
            logger.warn(" M_Minus_S List  size is " + this.masterResultList.size() + " which is greater then 1000, this can result into SQL error ");
        }
        return this.masterResultList;
    }

    public ArrayList<String> masterListIntersectSlaveList() {
        this.masterResultList.retainAll(this.slaveResultList);
        this.mMinusSResultList = this.masterResultList;
        logger.debug("M_Intersect_S List  size " + this.masterResultList.size());
        return this.masterResultList;
    }

    public void addDbRRule(JSONObject Rule) {
        super.getDbInfoAndQueryList().add((Object)Rule);
    }

    public void addDbMRule(JSONObject Rule) {
        this.masterRule = Rule;
    }

    public void addDbSRule(JSONObject Rule) {
        this.slaveRule = Rule;
    }

    public void addRule(String type, JSONObject Rule) {
        switch (type) {
            case "M": {
                this.addDbMRule(Rule);
                break;
            }
            case "S": {
                this.addDbSRule(Rule);
                break;
            }
            case "R": {
                this.addDbRRule(Rule);
                break;
            }
        }
    }

    @Override
    public JSONArray getList() {
        if (this.masterRule != null) {
            this.getDbInfoAndQueryList().add((Object)this.masterRule);
        }
        if (this.slaveRule != null) {
            this.getDbInfoAndQueryList().add((Object)this.slaveRule);
        }
        return this.getDbInfoAndQueryList();
    }

    private void postQueryResults(JSONObject result) {
        try {
            boolean isRunJsonUpdated;
            logger.info("post dbmsr....... ");
            JsonUtil jsonUtil = new JsonUtil();
            JSONArray queryResultArray = new JSONArray();
            int resultLimit = result.get((Object)"resultLimit") != null ? Integer.parseInt(String.valueOf(result.get((Object)"resultLimit"))) : 70000;
            boolean bl = isRunJsonUpdated = result.get((Object)"updateRunResult") != null && !"1".equalsIgnoreCase(String.valueOf(result.get((Object)"updateRunResult")));
            if (isRunJsonUpdated) {
                queryResultArray.add((Object)jsonUtil.limitRunJsonObject(result, resultLimit));
            } else {
                queryResultArray.add((Object)result);
            }
            String resp = "caSigned".equalsIgnoreCase(this.getCertType()) ? TLSHttpsRequestor.executePost(this.getPostURL(), Arrays.asList(GzipUtil.compressString(CryptographicUtil.encrypt(queryResultArray.toJSONString())), FileUtil.getAPIkey()), Arrays.asList("queryResultsEncrypted", "token")) : SelfSignedHttps.executePostRequest(this.getPostURL(), Arrays.asList(GzipUtil.compressString(CryptographicUtil.encrypt(queryResultArray.toJSONString())), FileUtil.getAPIkey()), Arrays.asList("queryResultsEncrypted", "token"));
            logger.debug("Posted DVTTD Record [" + result.get((Object)"id") + "] ");
        }
        catch (Exception e) {
            logger.error("Eception: ", e);
        }
    }
}

