/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.model;

import com.dvsum.factory.DataSourceFactory;
import com.dvsum.logger.LogFormat;
import com.dvsum.model.QueryExecutor;
import java.util.concurrent.ExecutorService;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public abstract class Executable {
    private DataSourceFactory dataSourceFactory;
    protected ExecutorService executorService;
    private JSONArray dbInfoAndQueryList;
    protected String certType;
    protected String postURL;
    protected LogFormat logFormat;

    public Executable(ExecutorService executorService, DataSourceFactory dataSourceFactory, String certType, String postURL, LogFormat logFormat) {
        this.executorService = executorService;
        this.dbInfoAndQueryList = new JSONArray();
        this.dataSourceFactory = dataSourceFactory;
        this.certType = certType;
        this.postURL = postURL;
        this.logFormat = logFormat;
    }

    public void execute() {
        int i = 0;
        while (i < this.dbInfoAndQueryList.size()) {
            if (this.executorService != null) {
                QueryExecutor queryExecutor = new QueryExecutor(this.dataSourceFactory, (JSONObject)this.dbInfoAndQueryList.get(i), false, this.logFormat);
                this.executorService.submit(queryExecutor);
            }
            ++i;
        }
    }

    public void executeCatalog(JSONObject dvttd) {
        if (this.executorService != null) {
            QueryExecutor queryExecutor = new QueryExecutor(this.dataSourceFactory, dvttd, false, this.logFormat);
            this.executorService.submit(queryExecutor);
        }
    }

    public DataSourceFactory getDataSourceFactory() {
        return this.dataSourceFactory;
    }

    public DataSourceFactory setDataSourceFactory(DataSourceFactory dataSourceFactory) {
        this.dataSourceFactory = dataSourceFactory;
        return this.dataSourceFactory;
    }

    public ExecutorService getExecutor() {
        return this.executorService;
    }

    public void setExecutor(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public JSONArray getDbInfoAndQueryList() {
        return this.dbInfoAndQueryList;
    }

    public JSONArray getList() {
        return this.dbInfoAndQueryList;
    }

    public String getCertType() {
        return this.certType;
    }

    public void setCertType(String certType) {
        this.certType = certType;
    }

    public String getPostURL() {
        return this.postURL;
    }

    public void setPostURL(String postURL) {
        this.postURL = postURL;
    }

    public void postResults() {
    }

    public abstract void executeDependents();
}

