/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.model;

import com.dvsum.dataSource.CatalogCallable;
import com.dvsum.dataSource.DataSource;
import com.dvsum.factory.DataSourceFactory;
import com.dvsum.logger.CustomLogger;
import com.dvsum.logger.LogFormat;
import com.dvsum.model.Executable;
import com.dvsum.model.ref.RefDBType;
import com.dvsum.util.CryptographicUtil;
import com.dvsum.util.FileUtil;
import com.dvsum.util.GzipUtil;
import com.dvsum.util.JsonUtil;
import com.dvsum.util.PropsWithPlaceholderUtil;
import com.dvsum.util.SelfSignedHttps;
import com.dvsum.util.TLSHttpsRequestor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;

public class CatalogingRule
extends Executable {
    private static final CustomLogger logger = CustomLogger.getLogger(CatalogingRule.class);
    private DataSourceFactory dataSourceFactory;

    public CatalogingRule(ExecutorService executorService, DataSourceFactory dataSourceFactory, String certType, String postURL, LogFormat logFormat) {
        super(executorService, dataSourceFactory, certType, postURL, logFormat);
        this.certType = certType;
        this.dataSourceFactory = dataSourceFactory;
        this.logFormat = logFormat;
    }

    public void addRule(JSONObject test) {
        if (test.get((Object)"resultLimit") == null) {
            test.put((Object)"resultLimit", (Object)"1000000");
        }
        super.getDbInfoAndQueryList().add((Object)test);
    }

    @Override
    public void executeDependents() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void execute() {
        void var7_8;
        logger.info("Starting cataloging");
        boolean cDataCacheCleared = false;
        DataSource dataSource = null;
        HashSet<Long> s3SourceCrawlerCompleted = new HashSet<Long>();
        JsonUtil jsonUtil = new JsonUtil();
        JSONArray arr = super.getDbInfoAndQueryList();
        HashSet<Future<CatalogData>> resultSetFutures = new HashSet<Future<CatalogData>>();
        boolean bl = false;
        while (var7_8 < arr.size()) {
            block13: {
                JSONObject dvttd = (JSONObject)arr.get((int)var7_8);
                Long operation = Long.valueOf(String.valueOf(dvttd.get((Object)"isRef")));
                String sourceType = String.valueOf(dvttd.get((Object)"sourceType"));
                Long sourceId = Long.parseLong(String.valueOf(dvttd.get((Object)"sourceId")));
                Boolean isCdata = Boolean.valueOf(String.valueOf(dvttd.get((Object)"isCdata")));
                try {
                    boolean isCataloging;
                    boolean bl2 = isCataloging = operation == 11L || operation == 12L || operation == 15L || operation == 16L;
                    if (isCdata != null && isCdata.booleanValue() && isCataloging) {
                        dataSource = this.dataSourceFactory.getDataSource(String.valueOf(dvttd.get((Object)"sourceType")), dvttd, true, this.logFormat);
                        dataSource.connect();
                        if (!cDataCacheCleared) {
                            cDataCacheCleared = true;
                            logger.info("Clearing CData Cache");
                            dataSource.cleanCDataCache();
                        }
                        if (RefDBType.isAmazonS3(sourceType)) {
                            String crawlerStatus = "STARTING";
                            boolean crawlerCompleted = "READY".equals(crawlerStatus) || s3SourceCrawlerCompleted.contains(sourceId);
                            logger.info("Is crawler already executed: " + crawlerCompleted);
                            boolean crawlerStarted = false;
                            if (!crawlerCompleted) {
                                String response = this.initiateCrawlerExecution(dvttd, operation.intValue());
                                if (!response.equalsIgnoreCase("SUCCESS")) break block13;
                                crawlerStarted = true;
                                logger.info("Crawler Started");
                            }
                            if (crawlerStarted) {
                                this.checkCrawlerStatus(dvttd, operation.intValue(), sourceId);
                                s3SourceCrawlerCompleted.add(sourceId);
                            }
                        }
                        System.out.println("Adding Opeartion: " + operation);
                        CatalogData catalogData = new CatalogData(dvttd, operation, null, sourceType, dataSource);
                        CatalogCallable catalogResult = new CatalogCallable(catalogData);
                        Future<CatalogData> future = this.executorService.submit(catalogResult);
                        resultSetFutures.add(future);
                        break block13;
                    }
                    super.executeCatalog(dvttd);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error("Cataloging Eception: ", e);
                    dvttd.put((Object)"runError", (Object)e.getMessage());
                    dvttd.put((Object)"runStatus", (Object)-1);
                    CatalogingRule.postQueryResults(this.postURL, this.certType, dvttd, operation.intValue());
                    if (dataSource == null) break block13;
                    dataSource.disconnect();
                }
            }
            ++var7_8;
        }
        for (Future future : resultSetFutures) {
            try {
                CatalogData resultData = (CatalogData)future.get();
                if (resultData == null) continue;
                JSONObject dvttd = resultData.getDvttd();
                ResultSet resultSet = resultData.getResultSet();
                Long operation = resultData.getOperation();
                String sourceType = resultData.getSourceType();
                jsonUtil.updateJsonWithResult(dvttd, resultSet, false, null, false);
                if (RefDBType.isAmazonS3(sourceType) && operation.intValue() == 12) {
                    logger.info("Initial Column Catalog: " + dvttd);
                    this.updateSerializationLibs(jsonUtil, dvttd, dataSource, resultSet);
                    logger.info("After Serialization Column Catalog: " + dvttd);
                }
                logger.debug("==> ==== dvttd with json result ===");
                logger.debug("==> " + dvttd.toJSONString());
                logger.debug("==> ===============================");
                CatalogingRule.postQueryResults(this.postURL, this.certType, dvttd, operation.intValue());
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("Cataloging Eception: ", e);
                if (dataSource == null) continue;
                dataSource.disconnect();
            }
        }
    }

    private void checkCrawlerStatus(JSONObject dvttd, int operationType, Long sourceId) throws InterruptedException, FileNotFoundException, ParseException, IOException {
        Long pollingDelay = Long.valueOf(FileUtil.getPropertyWithDefault("glue.crawler.check.delay.milliseconds", "10000L"));
        boolean crawlerCompleted = false;
        while (!crawlerCompleted) {
            String responseStr = this.getCrawlerStatus(dvttd);
            logger.info(responseStr);
            JSONObject responseObj = JsonUtil.parseToJsonObject(responseStr);
            if (responseObj.containsKey((Object)"errorMessage")) {
                logger.error(responseObj.get((Object)"errorMessage"));
                dvttd.put((Object)"runError", responseObj.get((Object)"errorMessage"));
                dvttd.put((Object)"runStatus", (Object)-1);
                CatalogingRule.postQueryResults(this.postURL, this.certType, dvttd, operationType);
                continue;
            }
            JSONObject crawlerObj = (JSONObject)responseObj.get((Object)"Crawler");
            String crawlerStatus = String.valueOf(crawlerObj.get((Object)"State"));
            logger.info("Source Id: " + sourceId + " - Crawler Status: " + crawlerStatus);
            if ("READY".equals(crawlerStatus)) {
                crawlerCompleted = true;
                continue;
            }
            Thread.sleep(pollingDelay);
        }
    }

    private String initiateCrawlerExecution(JSONObject dvttd, int operationType) throws ParseException, FileNotFoundException, IOException {
        String responseStr = this.executeCrawler(dvttd);
        logger.debug(responseStr);
        JSONObject responseObj = JsonUtil.parseToJsonObject(responseStr);
        if (responseObj.containsKey((Object)"errorMessage")) {
            logger.error(responseObj.get((Object)"errorMessage"));
            dvttd.put((Object)"runError", responseObj.get((Object)"errorMessage"));
            dvttd.put((Object)"runStatus", (Object)-1);
            CatalogingRule.postQueryResults(this.postURL, this.certType, dvttd, operationType);
            return "FAILED";
        }
        return "SUCCESS";
    }

    private void updateSerializationLibs(JsonUtil jsonUtil, JSONObject dvttd, DataSource dataSource, ResultSet resultSet) throws Exception {
        JSONObject runJSON = jsonUtil.parseStringToJsonObject(String.valueOf(dvttd.get((Object)"runJson")));
        JSONArray array = (JSONArray)runJSON.get((Object)"results");
        HashMap<String, Integer> columnCountByTable = new HashMap<String, Integer>();
        int idx = 0;
        while (idx < array.size()) {
            JSONObject columnRow = (JSONObject)array.get(idx);
            String tableName = String.valueOf(columnRow.get((Object)"TABLE_NAME"));
            Integer count = (Integer)columnCountByTable.get(tableName);
            count = count == null ? 0 : count;
            count = count + 1;
            columnCountByTable.put(tableName, count);
            ++idx;
        }
        for (Map.Entry mapElement : columnCountByTable.entrySet()) {
            this.updateSerializationLibForS3(dvttd, String.valueOf(mapElement.getKey()));
            int sleepFor = 1000 * (Integer)mapElement.getValue();
            logger.info("Sleep For " + sleepFor + " milliseconds");
            Thread.sleep(sleepFor);
        }
        logger.info("Clearing CData Cache");
        dataSource.cleanCDataCache();
        resultSet = dataSource.getColumnCatalog();
        while (resultSet.next()) {
            String columnName = resultSet.getString("COLUMN_NAME");
            String dataType = resultSet.getString("TYPE_NAME");
            int idx2 = 0;
            while (idx2 < array.size()) {
                JSONObject columnRow = (JSONObject)array.get(idx2);
                if (columnName.equalsIgnoreCase(String.valueOf(columnRow.get((Object)"COLUMN_NAME")))) {
                    columnRow.put((Object)"UPDATED_TYPE_NAME", (Object)dataType);
                }
                ++idx2;
            }
        }
        runJSON.put((Object)"results", (Object)array);
        dvttd.put((Object)"runJson", (Object)runJSON.toJSONString());
    }

    private String getCrawlerStatus(JSONObject dvttd) throws ParseException, FileNotFoundException, IOException {
        JSONObject connectionJson = JsonUtil.parseToJsonObject(String.valueOf(dvttd.get((Object)"connectionJson")));
        String accessKey = connectionJson.get((Object)"accessKey").toString();
        String secretKey = connectionJson.get((Object)"secretKey").toString();
        String region = connectionJson.get((Object)"region").toString();
        String crawlerName = connectionJson.get((Object)"glueCrawler").toString();
        String token = FileUtil.getAPIkey();
        List<String> parameterNames = Arrays.asList("token", "accessKey", "secretKey", "region", "crawlerName");
        List<String> parameterValues = Arrays.asList(token, accessKey, secretKey, region, crawlerName);
        ClassLoader classLoader = this.getClass().getClassLoader();
        PropsWithPlaceholderUtil urlProps = this.getFileProperties(classLoader.getResourceAsStream("polling-urls.properties"));
        String crawlerStatusUrl = urlProps.getString("apis.dvsum.crawler_status");
        if ("caSigned".equalsIgnoreCase(this.certType)) {
            return TLSHttpsRequestor.executePost(crawlerStatusUrl, parameterValues, parameterNames);
        }
        return SelfSignedHttps.executePostRequest(crawlerStatusUrl, parameterValues, parameterNames);
    }

    private PropsWithPlaceholderUtil getFileProperties(InputStream is) throws FileNotFoundException, IOException {
        PropsWithPlaceholderUtil appProps = new PropsWithPlaceholderUtil();
        appProps.load(is);
        return appProps;
    }

    private String executeCrawler(JSONObject dvttd) throws ParseException, FileNotFoundException, IOException {
        JSONObject connectionJson = JsonUtil.parseToJsonObject(String.valueOf(dvttd.get((Object)"connectionJson")));
        String accessKey = connectionJson.get((Object)"accessKey").toString();
        String secretKey = connectionJson.get((Object)"secretKey").toString();
        String region = connectionJson.get((Object)"region").toString();
        String crawlerName = connectionJson.get((Object)"glueCrawler").toString();
        String token = FileUtil.getAPIkey();
        List<String> parameterNames = Arrays.asList("token", "accessKey", "secretKey", "region", "crawlerName");
        List<String> parameterValues = Arrays.asList(token, accessKey, secretKey, region, crawlerName);
        ClassLoader classLoader = this.getClass().getClassLoader();
        PropsWithPlaceholderUtil urlProps = this.getFileProperties(classLoader.getResourceAsStream("polling-urls.properties"));
        String executeCrawlerUrl = urlProps.getString("apis.dvsum.execute_crawler");
        if ("caSigned".equalsIgnoreCase(this.certType)) {
            return TLSHttpsRequestor.executePost(executeCrawlerUrl, parameterValues, parameterNames);
        }
        return SelfSignedHttps.executePostRequest(executeCrawlerUrl, parameterValues, parameterNames);
    }

    private String updateSerializationLibForS3(JSONObject dvttd, String tableName) throws ParseException, FileNotFoundException, IOException {
        logger.info("Serialization Started:: " + tableName);
        JSONObject connectionJson = JsonUtil.parseToJsonObject(String.valueOf(dvttd.get((Object)"connectionJson")));
        String accessKey = connectionJson.get((Object)"accessKey").toString();
        String secretKey = connectionJson.get((Object)"secretKey").toString();
        String region = connectionJson.get((Object)"region").toString();
        String dbName = connectionJson.get((Object)"database").toString();
        String s3StagingBucket = "s3://" + connectionJson.get((Object)"stagingBucket").toString();
        s3StagingBucket = String.valueOf(s3StagingBucket) + (connectionJson.get((Object)"s3StagingBucketfolderPath") != null ? "/" + connectionJson.get((Object)"s3StagingBucketfolderPath").toString() : "");
        String token = FileUtil.getAPIkey();
        List<String> parameterNames = Arrays.asList("token", "accessKey", "secretKey", "region", "dbName", "s3StagingBucket", "tableName");
        List<String> parameterValues = Arrays.asList(token, accessKey, secretKey, region, dbName, s3StagingBucket, tableName);
        ClassLoader classLoader = this.getClass().getClassLoader();
        PropsWithPlaceholderUtil urlProps = this.getFileProperties(classLoader.getResourceAsStream("polling-urls.properties"));
        String updateSerializationLibUrl = urlProps.getString("apis.dvsum.update_serialization_lib_for_s3");
        String response = "";
        response = "caSigned".equalsIgnoreCase(this.certType) ? TLSHttpsRequestor.executePost(updateSerializationLibUrl, parameterValues, parameterNames) : SelfSignedHttps.executePostRequest(updateSerializationLibUrl, parameterValues, parameterNames);
        logger.info("Serialization Done:: " + tableName + " - " + response);
        return response;
    }

    public static void postQueryResults(String postQueryResultURL, String certType, JSONObject result, int opType) {
        try {
            logger.debug("postQueryResults");
            JsonUtil jsonUtil = new JsonUtil();
            int resultLimit = 1000000;
            JSONArray jsonArray = new JSONArray();
            jsonArray.add((Object)jsonUtil.limitRunJsonObject(result, resultLimit));
            String data = GzipUtil.compressString(CryptographicUtil.encrypt(jsonArray.toJSONString()));
            String token = FileUtil.getAPIkey();
            System.out.println("Posting for : " + opType);
            String resp = "caSigned".equalsIgnoreCase(certType) ? TLSHttpsRequestor.executePost(postQueryResultURL, Arrays.asList(data, token, String.valueOf(opType)), Arrays.asList("queryResultsEncrypted", "token", "isRef")) : SelfSignedHttps.executePostRequest(postQueryResultURL, Arrays.asList(data, token, String.valueOf(opType)), Arrays.asList("queryResultsEncrypted", "token", "isRef"));
            logger.debug("Server Response: " + resp);
            System.out.println("Posted DVTTD Record [" + result.get((Object)"id") + "] ");
            logger.debug("Posted DVTTD Record [" + result.get((Object)"id") + "] ");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(" Gzip Eception: ", e);
        }
    }

    public class CatalogData {
        JSONObject dvttd;
        Long operation;
        ResultSet resultSet;
        String sourceType;
        DataSource dataSource;

        public CatalogData(JSONObject dvttd, Long operation, ResultSet resultSet, String sourceType, DataSource dataSource) {
            this.dvttd = dvttd;
            this.operation = operation;
            this.resultSet = resultSet;
            this.sourceType = sourceType;
            this.dataSource = dataSource;
        }

        public JSONObject getDvttd() {
            return this.dvttd;
        }

        public void setDvttd(JSONObject dvttd) {
            this.dvttd = dvttd;
        }

        public Long getOperation() {
            return this.operation;
        }

        public void setOperation(Long operation) {
            this.operation = operation;
        }

        public ResultSet getResultSet() {
            return this.resultSet;
        }

        public void setResultSet(ResultSet resultSet) {
            this.resultSet = resultSet;
        }

        public String getSourceType() {
            return this.sourceType;
        }

        public void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public DataSource getDataSource() {
            return this.dataSource;
        }

        public void setDataSource(DataSource dataSource) {
            this.dataSource = dataSource;
        }
    }
}

