/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.model;

import com.dvsum.factory.DataSourceFactory;
import com.dvsum.logger.CustomLogger;
import com.dvsum.logger.LogFormat;
import com.dvsum.model.AddressValidationApi;
import com.dvsum.model.QueryExecutor;
import java.util.ArrayList;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class AdressValidationSequentilaExecution
implements Runnable {
    private static final CustomLogger logger = CustomLogger.getLogger(AdressValidationSequentilaExecution.class);
    private DataSourceFactory dataSourceFactory;
    private JSONArray sequentialQueriesAndConnInfo;
    private String certType;
    private String postQueryResultURL;
    LogFormat logFormat;

    public AdressValidationSequentilaExecution(DataSourceFactory dataSourceFactory, ArrayList<String> resultList, boolean convertResultToList, JSONArray sequentialQueriesAndConnInfo, String certType, String postQueryResultURL, LogFormat logFormat) {
        this.dataSourceFactory = dataSourceFactory;
        this.sequentialQueriesAndConnInfo = sequentialQueriesAndConnInfo;
        this.certType = certType;
        this.postQueryResultURL = postQueryResultURL;
        this.logFormat = logFormat;
    }

    @Override
    public void run() {
        logger.debug("Address Validation Execution Started ..............");
        int i = 0;
        while (i < this.sequentialQueriesAndConnInfo.size()) {
            try {
                JSONObject sample = (JSONObject)this.sequentialQueriesAndConnInfo.get(i);
                boolean convertResultToList = false;
                if ("WS".equals(String.valueOf(sample.get((Object)"SAWSOperation")))) {
                    sample.put((Object)"updateRunResult", (Object)0);
                }
                QueryExecutor queryExecutor = new QueryExecutor(this.dataSourceFactory, (JSONObject)this.sequentialQueriesAndConnInfo.get(i), false, this.logFormat);
                Object result = null;
                JSONParser parser = new JSONParser();
                if ("WS".equals(String.valueOf(sample.get((Object)"SAWSOperation")))) {
                    String jsonString = String.valueOf(result.get((Object)"runJson"));
                    String queryJsonString = String.valueOf(result.get((Object)"queryJSON"));
                    JSONObject queryJson = (JSONObject)parser.parse(queryJsonString);
                    JSONObject runJson = (JSONObject)parser.parse(jsonString);
                    JSONArray results = (JSONArray)runJson.get((Object)"results");
                    String query = String.valueOf(sample.get((Object)"runQuery"));
                    AddressValidationApi geoCodingApi = new AddressValidationApi();
                    JSONObject updateQueries = geoCodingApi.validateAllAddresses(results, queryJson);
                    sample.put((Object)"queryJSON", (Object)updateQueries);
                    sample.put((Object)"isWriteQuery", (Object)1);
                    String sampleJSonString = sample.toJSONString();
                    JSONObject newJson = (JSONObject)parser.parse(sampleJSonString);
                    newJson.put((Object)"SAWSOperation", (Object)"BW");
                    Long start = System.currentTimeMillis();
                    QueryExecutor updateAdresses = new QueryExecutor(this.dataSourceFactory, newJson, false, this.logFormat);
                    Long end = System.currentTimeMillis();
                    logger.debug(" Addr Val Batch Update Execution Time  " + (end - start) / 1000L + "sec " + (end - start) / 60000L + " min");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("Error: ", e);
            }
            ++i;
        }
        logger.debug("Address Validation Execution Completed ..............");
    }
}

