/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.model;

import com.dvsum.logger.CustomLogger;
import com.dvsum.util.Util;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class AddressValidationApi {
    private static final CustomLogger logger = CustomLogger.getLogger(AddressValidationApi.class);
    private static final Integer POOL_SIZE = 48;
    private static Integer CURRENT_CONCURRENT_THREADS = 0;
    private static Integer MAX_CONCURRENT_THREADS = 48;

    public static void main(String[] args) {
    }

    public JSONObject validateAllAddresses(JSONArray addresses, JSONObject metaData) {
        JSONArray validatedAddresses = new JSONArray();
        JSONArray adressesToBeValidated = new JSONArray();
        JSONObject updateQueries = new JSONObject();
        try {
            Long start = System.currentTimeMillis();
            logger.debug("Validating Addresses using Google API");
            int i = 0;
            while (i < addresses.size()) {
                if (i == 0 || i % POOL_SIZE != 0) {
                    adressesToBeValidated.add(addresses.get(i));
                } else {
                    validatedAddresses.addAll((Collection)this.validateAddressesUsingGoogleApi(adressesToBeValidated, metaData));
                    Thread.sleep(2000L);
                    adressesToBeValidated = new JSONArray();
                    adressesToBeValidated.add(addresses.get(i));
                }
                if (i == addresses.size() - 1) {
                    validatedAddresses.addAll((Collection)this.validateAddressesUsingGoogleApi(adressesToBeValidated, metaData));
                }
                ++i;
            }
            Long end = System.currentTimeMillis();
            logger.debug("Address Validation Completed in " + (end - start) / 1000L + "sec " + (end - start) / 60000L + " min");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
        updateQueries.put((Object)"ROWSET", (Object)validatedAddresses);
        StringBuilder builder = new StringBuilder();
        return updateQueries;
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray validateAddressesUsingGoogleApi(JSONArray addresses, JSONObject metaData) {
        JSONObject updateQueries = new JSONObject();
        JSONArray validatedAdresses = new JSONArray();
        ExecutorService pool = Executors.newFixedThreadPool(POOL_SIZE);
        try {
            void var8_10;
            HashSet validatedAddresses = new HashSet();
            int count = 0;
            boolean bl = false;
            while (var8_10 < addresses.size()) {
                JSONObject adressJson = (JSONObject)addresses.get((int)var8_10);
                String adressColName = String.valueOf(metaData.get((Object)"infulladdress"));
                String idColumnValue = String.valueOf(metaData.get((Object)"id"));
                GoogleAddressValidationAPIRequest validationRequest = new GoogleAddressValidationAPIRequest(String.valueOf(adressJson.get((Object)adressColName)), String.valueOf(adressJson.get((Object)idColumnValue)), metaData);
                Future future = pool.submit(validationRequest);
                validatedAddresses.add(future);
                ++count;
                ++var8_10;
            }
            for (Future future : validatedAddresses) {
                if (future.get() == null || ((JSONObject)future.get()).isEmpty()) continue;
                validatedAdresses.add(future.get());
            }
            updateQueries.put((Object)"ROWSET", (Object)validatedAdresses);
            pool.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Exception: ", e);
        }
        return validatedAdresses;
    }

    public class GoogleAddressValidationAPIRequest
    implements Callable {
        private String address;
        private JSONParser parser;
        private JSONObject response;
        private String colVal;
        private JSONObject metaData;

        public GoogleAddressValidationAPIRequest(String addressValue, String identifierValue, JSONObject metaData) {
            this.address = addressValue;
            this.colVal = identifierValue;
            this.parser = new JSONParser();
            this.response = new JSONObject();
            this.metaData = metaData != null ? metaData : new JSONObject();
        }

        public JSONObject call() {
            CURRENT_CONCURRENT_THREADS = CURRENT_CONCURRENT_THREADS + 1;
            HttpClient httpclient = new HttpClient();
            GetMethod httpget = new GetMethod("https://maps.googleapis.com/maps/api/geocode/json");
            Object[] paramValues = new Object[]{this.address, String.valueOf(this.metaData.get((Object)"inapikey"))};
            Object[] parameterName = new Object[]{"address", "key"};
            String responseString = null;
            StringBuilder query = new StringBuilder();
            query.append(" UPDATE " + String.valueOf(this.metaData.get((Object)"tablename")) + " set ");
            NameValuePair[] nameValuePair = new NameValuePair[paramValues.length];
            try {
                try {
                    int i = 1;
                    while (i <= paramValues.length) {
                        nameValuePair[i - 1] = new NameValuePair(parameterName[i - 1].toString(), paramValues[i - 1].toString());
                        ++i;
                    }
                    httpget.setQueryString(nameValuePair);
                    httpclient.executeMethod((HttpMethod)httpget);
                    responseString = httpget.getResponseBodyAsString();
                    JSONParser parser = new JSONParser();
                    JSONObject response = (JSONObject)parser.parse(responseString);
                    JSONArray results = (JSONArray)response.get((Object)"results");
                    String status = String.valueOf(response.get((Object)"status"));
                    if ("OVER_QUERY_LIMIT".equals(status)) {
                        logger.error(response.toJSONString());
                    }
                    if (results != null && results.size() > 0) {
                        JSONObject obj = (JSONObject)results.get(0);
                        JSONArray adressComponent = (JSONArray)obj.get((Object)"address_components");
                        JSONArray types = (JSONArray)obj.get((Object)"types");
                        if (types != null && types.size() > 0 && !query.toString().contains(String.valueOf(String.valueOf(this.metaData.get((Object)"outaddrtype"))) + " = '")) {
                            query.append(String.valueOf(String.valueOf(this.metaData.get((Object)"outaddrtype"))) + " = '" + this.parseString(String.valueOf(types.get(0))) + "' ,");
                        }
                        int i2 = 0;
                        while (i2 < adressComponent.size()) {
                            JSONObject comp = (JSONObject)adressComponent.get(i2);
                            if (comp != null) {
                                JSONArray resultTypes = (JSONArray)comp.get((Object)"types");
                                String compType = String.valueOf(resultTypes.get(0));
                                if (compType != null && "street_number".equals(compType) && String.valueOf(this.metaData.get((Object)"outstnum")) != null && !query.toString().contains(String.valueOf(String.valueOf(this.metaData.get((Object)"outstnum"))) + " = '")) {
                                    query.append(String.valueOf(String.valueOf(this.metaData.get((Object)"outstnum"))) + " = '" + this.parseString(String.valueOf(comp.get((Object)"short_name"))) + "' ,");
                                }
                                if (compType != null && "route".equals(compType) && String.valueOf(this.metaData.get((Object)"outstname")) != null && !query.toString().contains(String.valueOf(String.valueOf(this.metaData.get((Object)"outstname"))) + " = '")) {
                                    query.append(String.valueOf(String.valueOf(this.metaData.get((Object)"outstname"))) + " = '" + this.parseString(String.valueOf(comp.get((Object)"short_name"))) + "' ,");
                                }
                                if (compType != null && "locality".equals(compType) && String.valueOf(this.metaData.get((Object)"outcity")) != null && !query.toString().contains(String.valueOf(String.valueOf(this.metaData.get((Object)"outcity"))) + " = '")) {
                                    query.append(String.valueOf(String.valueOf(this.metaData.get((Object)"outcity"))) + " = '" + this.parseString(String.valueOf(comp.get((Object)"short_name"))) + "' ,");
                                }
                                if (compType != null && "administrative_area_level_1".equals(compType) && String.valueOf(this.metaData.get((Object)"outstate")) != null && !query.toString().contains(String.valueOf(String.valueOf(this.metaData.get((Object)"outstate"))) + " = '")) {
                                    query.append(String.valueOf(String.valueOf(this.metaData.get((Object)"outstate"))) + " = '" + this.parseString(String.valueOf(comp.get((Object)"short_name"))) + "' ,");
                                }
                                if (compType != null && "country".equals(compType) && String.valueOf(this.metaData.get((Object)"outcountry")) != null && !query.toString().contains(String.valueOf(String.valueOf(this.metaData.get((Object)"outcountry"))) + " = '")) {
                                    query.append(String.valueOf(String.valueOf(this.metaData.get((Object)"outcountry"))) + " = '" + this.parseString(String.valueOf(comp.get((Object)"short_name"))) + "' ,");
                                }
                                if (compType != null && "postal_code".equals(compType) && String.valueOf(this.metaData.get((Object)"outzip")) != null && !query.toString().contains(String.valueOf(String.valueOf(this.metaData.get((Object)"outzip"))) + " = '")) {
                                    query.append(String.valueOf(String.valueOf(this.metaData.get((Object)"outzip"))) + " = '" + this.parseString(String.valueOf(comp.get((Object)"short_name"))) + "' ,");
                                }
                                if (compType != null && "postal_code_suffix".equals(compType) && String.valueOf(this.metaData.get((Object)"outzipsuffix")) != null && !query.toString().contains(String.valueOf(String.valueOf(this.metaData.get((Object)"outzipsuffix"))) + " = '")) {
                                    query.append(String.valueOf(String.valueOf(this.metaData.get((Object)"outzipsuffix"))) + " = '" + this.parseString(String.valueOf(comp.get((Object)"short_name"))) + "' ,");
                                }
                                if (compType != null && "premise".equals(compType) && String.valueOf(this.metaData.get((Object)"outpremise")) != null && !query.toString().contains(String.valueOf(String.valueOf(this.metaData.get((Object)"outpremise"))) + " = '")) {
                                    query.append(String.valueOf(String.valueOf(this.metaData.get((Object)"outpremise"))) + " = '" + this.parseString(String.valueOf(comp.get((Object)"short_name"))) + "' ,");
                                }
                                if (compType != null && "subpremise".equals(compType) && String.valueOf(this.metaData.get((Object)"outsubpremise")) != null && !query.toString().contains(String.valueOf(String.valueOf(this.metaData.get((Object)"outsubpremise"))) + " = '")) {
                                    query.append(String.valueOf(String.valueOf(this.metaData.get((Object)"outsubpremise"))) + " = '" + this.parseString(String.valueOf(comp.get((Object)"short_name"))) + "' ,");
                                }
                            }
                            ++i2;
                        }
                        if (obj != null && obj.get((Object)"partial_match") != null && String.valueOf(this.metaData.get((Object)"outpartialmatch")) != null && !query.toString().contains(String.valueOf(String.valueOf(this.metaData.get((Object)"outpartialmatch"))) + " = '")) {
                            query.append(String.valueOf(String.valueOf(this.metaData.get((Object)"outpartialmatch"))) + " = '" + 1 + "' ,");
                        }
                        if (obj != null && String.valueOf(this.metaData.get((Object)"outfulladdress")) != null && !query.toString().contains(String.valueOf(String.valueOf(this.metaData.get((Object)"outfulladdress"))) + " = '")) {
                            query.append(String.valueOf(String.valueOf(this.metaData.get((Object)"outfulladdress"))) + " = '" + this.parseString(String.valueOf(obj.get((Object)"formatted_address"))) + "' ,");
                        }
                    }
                    if (status != null && !query.toString().contains(String.valueOf(String.valueOf(this.metaData.get((Object)"outrawstatus"))) + " = '")) {
                        query.append(String.valueOf(String.valueOf(this.metaData.get((Object)"outrawstatus"))) + " = '" + this.parseString(String.valueOf(status)) + "'");
                    }
                    query.append(" where " + String.valueOf(this.metaData.get((Object)"id")) + " = " + this.colVal);
                    if (Util.isNotNullOrEmpty(query.toString())) {
                        this.response.put((Object)"Adress", (Object)this.address);
                        this.response.put((Object)"WRQRY", (Object)query.toString());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error("Errored adrress " + this.address);
                    logger.error("runError: " + e.getMessage());
                    this.response = new JSONObject();
                    httpget.releaseConnection();
                    CURRENT_CONCURRENT_THREADS = CURRENT_CONCURRENT_THREADS - 1;
                }
            }
            finally {
                httpget.releaseConnection();
                CURRENT_CONCURRENT_THREADS = CURRENT_CONCURRENT_THREADS - 1;
            }
            return this.response;
        }

        public String parseString(String val) {
            return val != null ? val.replace("'", "|") : "";
        }
    }
}

