/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.model;

import com.dvsum.logger.CustomLogger;
import com.dvsum.model.InMemoryProps;
import com.dvsum.util.CryptographicUtil;
import com.dvsum.util.GzipUtil;
import com.dvsum.util.TLSHttpsRequestor;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class AddressValidationAPIRequestor
implements Runnable {
    private static final CustomLogger logger = CustomLogger.getLogger(AddressValidationAPIRequestor.class);
    private JSONArray addresses;
    private JSONObject jsonObject;

    public AddressValidationAPIRequestor(JSONArray addresses, JSONObject jsonObject) {
        this.addresses = addresses;
        this.jsonObject = jsonObject;
    }

    @Override
    public void run() {
        try {
            if (this.addresses != null && !this.addresses.isEmpty()) {
                this.jsonObject.put((Object)"addresses", (Object)CryptographicUtil.encrypt(this.addresses.toJSONString()));
                Object[] headerNames = new Object[]{"x-api-key"};
                Object[] headerValues = new Object[]{InMemoryProps.DVSUM_API_KEY};
                TLSHttpsRequestor.executePost(InMemoryProps.AV_API_URL, GzipUtil.compressString(this.jsonObject.toJSONString()), headerNames, headerValues);
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", e);
        }
    }
}

